/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.data;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.data.MarkupActiveFeatures;
import com.ibm.appscan.ica.markup.data.MarkupNormalizer;
import com.ibm.appscan.ica.markup.data.RawMarkupData;
import com.ibm.appscan.ica.markup.translator.MarkupTranslator;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.ifa.common.IfaSparkContext;
import com.ibm.appscan.vdb.method.Method;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils;

public class MarkupData {
    private JavaRDD<LabeledPoint> m_data;
    private File m_train_file;
    private String m_associated_class;
    private MarkupNormalizer m_normalizer;
    private MarkupTranslator m_checker;
    private RawMarkupData m_raw_data;
    private MarkupActiveFeatures m_active_features;
    private Language.LANGUAGE m_lang;

    public MarkupData(String name, String associated_class, MarkupTranslator checker, RawMarkupData raw, Language.LANGUAGE lang) throws MarkupException {
        this.m_raw_data = raw;
        this.m_associated_class = associated_class;
        this.m_checker = checker;
        this.m_lang = lang;
        this.m_active_features = new MarkupActiveFeatures(this.m_lang);
        this.m_train_file = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "trainers" + File.separator + name + File.separator + lang.toVdbString(), this.m_associated_class + "_" + this.m_active_features.getDirString() + ".train");
        if (!this.m_train_file.exists() || this.m_train_file.length() == 0L) {
            // empty if block
        }
    }

    public MarkupActiveFeatures getActiveFeatures() {
        return this.m_active_features;
    }

    public String getMarkupClass(Method m) throws MarkupException {
        return this.m_checker.getMarkupString(m);
    }

    public Vector getVector(Method m) throws IfaException {
        String[] entries = this.getNormalizer().getNormalizedMethod(m).split(" ");
        ArrayList<Double> temp = new ArrayList<Double>();
        for (int i = 1; i < entries.length; ++i) {
            temp.add(Double.parseDouble(entries[i].split(":")[1]));
        }
        double[] ret = new double[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            ret[i] = (Double)temp.get(i);
        }
        return Vectors.dense((double[])ret);
    }

    public String getAssociatedClass() {
        return this.m_associated_class;
    }

    private MarkupNormalizer getNormalizer() throws MarkupException {
        if (this.m_normalizer == null) {
            this.m_normalizer = new MarkupNormalizer(this.m_checker, this.m_raw_data, this.getAssociatedClass(), this.m_active_features);
        }
        return this.m_normalizer;
    }

    public JavaRDD<LabeledPoint> getData() throws MarkupException {
        if (this.m_data == null) {
            if (!this.m_train_file.exists() || this.m_train_file.length() == 0L) {
                PrintWriter w = null;
                try {
                    this.m_train_file.getParentFile().mkdirs();
                    w = new PrintWriter(this.m_train_file);
                    StringBuffer str = new StringBuffer();
                    for (Method m : this.m_raw_data.getTrainMethods()) {
                        str.append(this.getNormalizer().getNormalizedMethod(m));
                    }
                    w.write(str.toString());
                    w.flush();
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new MarkupException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(w);
                        throw throwable;
                    }
                }
                IOUtil.close((Closeable)w);
            }
            this.m_data = MLUtils.loadLibSVMFile((SparkContext)IfaSparkContext.getCtx(), (String)this.m_train_file.getAbsolutePath(), (int)this.m_active_features.getFeatures().size()).toJavaRDD();
            this.m_data.cache();
        }
        return this.m_data;
    }
}

