/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.trainer;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.ica.markup.data.MarkupActiveFeatures;
import com.ibm.appscan.ica.markup.trainer.MarkupTrainer;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.ifa.model.SparkModel;
import com.ibm.appscan.ifa.model.SparkRandomForestClassifier;
import java.io.File;
import java.util.ArrayList;

public abstract class MarkupTrainerSingle
extends MarkupTrainer {
    private boolean m_feature_init = false;
    private int m_seed = 66887;

    public MarkupTrainerSingle(ArrayList<MarkupActiveFeatures.MARKUP_FEATURES> f) {
        this.init(f, 66887);
    }

    public MarkupTrainerSingle(ArrayList<MarkupActiveFeatures.MARKUP_FEATURES> f, int seed) {
        this.init(f, seed);
    }

    private void init(ArrayList<MarkupActiveFeatures.MARKUP_FEATURES> f, int seed) {
        this.m_seed = seed;
        ArrayList<MarkupActiveFeatures.MARKUP_FEATURES> indeces = new ArrayList<MarkupActiveFeatures.MARKUP_FEATURES>();
        for (MarkupActiveFeatures.MARKUP_FEATURES feat : MarkupActiveFeatures.MARKUP_FEATURES.values()) {
            indeces.add(feat);
        }
        this.getFeatures().addAll(f);
        StringBuffer str = new StringBuffer();
        for (MarkupActiveFeatures.MARKUP_FEATURES feature : f) {
            str.append(indeces.indexOf((Object)feature));
        }
        this.setTrainFile(new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "trainers", this.getClass().getName() + "_" + str.toString() + ".train"));
        this.setIdMapFile(new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "trainers", this.getClass().getName() + "_" + str.toString() + "_id_map.map"));
        this.setTrainSignaturesFile(new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "spark" + File.separator + "trainers", this.getClass().getName() + "_" + str.toString() + ".sigs"));
    }

    public int getSeed() {
        return this.m_seed;
    }

    @Override
    public ArrayList<MarkupActiveFeatures.MARKUP_FEATURES> getFeatures() {
        if (!this.m_feature_init) {
            this.m_feature_init = true;
            super.getFeatures().clear();
            super.getFeatures().add(this.getFeature());
        }
        return super.getFeatures();
    }

    @Override
    protected SparkModel initModel() throws IfaException {
        return new SparkRandomForestClassifier(this.getClass().getName(), this.getData(), this.getNumClasses(), this.getSeed());
    }
}

