/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.trainer.binary;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.ica.markup.trainer.binary.BinaryMarkupTrainer;
import com.ibm.appscan.ica.markup.trainer.binary.SinkArgBinaryTrainer;
import com.ibm.appscan.ica.markup.trainer.binary.SinkSevBinaryTrainer;
import com.ibm.appscan.ica.markup.trainer.binary.SinkVulnBinaryTrainer;
import com.ibm.appscan.ica.markup.translator.MarkupChildTranslator;
import com.ibm.appscan.ica.markup.translator.MarkupTranslator;
import com.ibm.appscan.ica.markup.translator.SinkTranslator;
import com.ibm.appscan.ifa.common.IfaException;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.ao.ActionObject;
import com.ibm.appscan.vdb.method.markup.ao.Sink;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;

public class SinkBinaryTrainer
extends BinaryMarkupTrainer {
    private BinaryMarkupTrainer m_sink_arg = new SinkArgBinaryTrainer();
    private BinaryMarkupTrainer m_sink_sev = new SinkSevBinaryTrainer();
    private BinaryMarkupTrainer m_sink_vuln = new SinkVulnBinaryTrainer();

    @Override
    protected MarkupTranslator initTranslator() {
        return new SinkTranslator();
    }

    @Override
    protected boolean applyMarkup(Method m, String markupString) throws MarkupException {
        if (m.getArgs().size() == 0 || !this.validForSink(m)) {
            return false;
        }
        if (markupString.equals(SinkTranslator.SINK)) {
            try {
                Sink s = new Sink(this.m_sink_vuln.getPredictedClass(m), VDBEnums.SEVERITY.valueOf((String)this.m_sink_sev.getPredictedClass(m)), ((MarkupChildTranslator)this.m_sink_arg.getTranslator()).getDetailString(m, this.m_sink_arg.getPredictedClass(m)));
                m.addActionObject((ActionObject)s);
                m.addComment(this.m_sink_vuln.printPredictions(m));
                m.addComment(this.m_sink_sev.printPredictions(m));
                m.addComment(this.m_sink_arg.printPredictions(m));
                return true;
            }
            catch (BadMarkupException e) {
                return false;
            }
            catch (IfaException e) {
                throw new MarkupException(e);
            }
        }
        return false;
    }

    private boolean validForSink(Method m) throws MarkupException {
        try {
            for (String arg : m.getArgs()) {
                if (!VdbProvider.isTaintType((String)m.getSimpleArg(arg))) continue;
                if (m.getLang() == Language.LANGUAGE.JAVA) {
                    if (VdbProvider.isNumber((String)m.getSimpleArg(arg))) continue;
                    return true;
                }
                return true;
            }
        }
        catch (Exception e) {
            throw new MarkupException(e);
        }
        return false;
    }
}

