/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ica.markup.translator;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.ica.markup.MarkupException;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.rule.Rule;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public abstract class MarkupTranslator {
    private ArrayList<Rule> m_rules;
    private ArrayList<Rule> m_anti_rules;

    public abstract String getMarkupString(Method var1) throws MarkupException;

    public abstract boolean hasMarkup(Method var1);

    public abstract boolean applyMarkup(Method var1, String var2) throws MarkupException;

    public abstract boolean useOnlyMarkedUpMethods();

    protected abstract void initRules() throws MarkupException, BadRuleException;

    protected abstract void initAntiRules() throws MarkupException, BadRuleException;

    protected abstract String getMarkupType();

    public abstract String convertRuleToMarkup(Method var1) throws MarkupException;

    protected abstract String getAntiMatch();

    public boolean isValidClassForMethod(String markupString, Method m) throws MarkupException {
        return true;
    }

    public boolean isSupersetClass(String origMarkupString, String predictedMarkupString) {
        return false;
    }

    public String printRuleMatches(Method m) throws MarkupException {
        StringBuffer str = new StringBuffer();
        for (Rule r : this.getRules()) {
            if (!r.isMatch(m)) continue;
            str.append("\tRule matches:" + r.getRuleName());
            str.append(System.getProperty("line.separator"));
        }
        for (Rule r : this.getAntiRules()) {
            if (!r.isMatch(m)) continue;
            str.append("\tAnti Rule matches:" + r.getRuleName());
            str.append(System.getProperty("line.separator"));
        }
        return str.toString();
    }

    public boolean isRuleMatch(Method m) throws MarkupException {
        for (Rule r : this.getRules()) {
            if (!r.isMatch(m)) continue;
            return true;
        }
        return false;
    }

    public abstract String getDefaultValue();

    public boolean ruleAppliesToMethod(Method m) throws MarkupException {
        if (this.antiRuleApplies(m)) {
            return true;
        }
        return this.ruleApplies(m) && !this.antiRuleApplies(m);
    }

    public String getMarkupFromRule(Method m) throws MarkupException {
        if (this.antiRuleApplies(m)) {
            return this.getAntiMatch();
        }
        if (this.ruleApplies(m) && !this.antiRuleApplies(m)) {
            return this.convertRuleToMarkup(m);
        }
        return null;
    }

    protected boolean ruleApplies(Method m) throws MarkupException {
        if (this.antiRuleApplies(m)) {
            return false;
        }
        for (Rule r : this.getRules()) {
            if (!r.isMatch(m)) continue;
            return true;
        }
        return false;
    }

    protected boolean antiRuleApplies(Method m) throws MarkupException {
        for (Rule r : this.getAntiRules()) {
            if (!r.isMatch(m)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Rule> getRules() throws MarkupException {
        if (this.m_rules == null) {
            this.m_rules = new ArrayList();
            try {
                this.initRules();
            }
            catch (BadRuleException e) {
                throw new MarkupException(e);
            }
            for (VDBEnums.RULE_OPERATOR op : VDBEnums.RULE_OPERATOR.values()) {
                for (RULE_TYPE rt : RULE_TYPE.values()) {
                    this.processBulkRule(op, rt, this.getRules(), false);
                }
            }
        }
        return this.m_rules;
    }

    public ArrayList<Rule> getAntiRules() throws MarkupException {
        if (this.m_anti_rules == null) {
            this.m_anti_rules = new ArrayList();
            try {
                this.initAntiRules();
            }
            catch (BadRuleException e) {
                throw new MarkupException(e);
            }
            for (VDBEnums.RULE_OPERATOR op : VDBEnums.RULE_OPERATOR.values()) {
                for (RULE_TYPE rt : RULE_TYPE.values()) {
                    this.processBulkRule(op, rt, this.getAntiRules(), true);
                }
            }
        }
        return this.m_anti_rules;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processBulkRule(VDBEnums.RULE_OPERATOR op, RULE_TYPE rt, ArrayList<Rule> map, boolean anti) throws MarkupException {
        File f = new File(CommonCore.getDirectoryLocator().getMl() + "spark" + File.separator + (anti ? "anti_rules" : "rules") + File.separator, rt.toString().toLowerCase() + "_" + op.getSimpleName() + "_" + this.getMarkupType() + ".rule");
        if (!f.exists()) {
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            while (line != null) {
                if (line != null && line.length() > 0 && !line.startsWith("#")) {
                    Rule r = new Rule();
                    r.setRuleName("Bulk rule:" + rt.toString() + " " + op.getSimpleName() + " " + line + " - " + this.getMarkupType());
                    Object sr = rt == RULE_TYPE.METHOD ? r.getMethodRule().getSignatureRule() : (rt == RULE_TYPE.CLASS ? r.getMethodRule().getClassRule() : (rt == RULE_TYPE.PACKAGE ? r.getMethodRule().getPackageRule() : r.getMethodRule().getReturnRule()));
                    sr.setRuleOperator(op);
                    sr.setRuleValue(line);
                    map.add(r);
                }
                line = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new MarkupException(e);
                catch (IOException e2) {
                    throw new MarkupException(e2);
                }
                catch (BadRuleException e3) {
                    throw new MarkupException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(br);
                throw throwable;
            }
        }
        IOUtil.close((Closeable)br);
    }

    protected static enum RULE_TYPE {
        METHOD,
        CLASS,
        PACKAGE,
        RETURN;

    }
}

