/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.visualstudio.plugin;

import com.ibm.appscan.visualstudio.plugin.Messages;
import com.ibm.appscan.visualstudio.plugin.actions.AnalyzeAction;
import com.ibm.appscan.visualstudio.plugin.actions.CheckJavaAction;
import com.ibm.appscan.visualstudio.plugin.actions.GenerateReportAction;
import com.ibm.appscan.visualstudio.plugin.actions.IAction;
import com.ibm.appscan.visualstudio.plugin.actions.LoginAction;
import com.ibm.appscan.visualstudio.plugin.actions.PrepareAction;
import java.io.File;
import java.util.Arrays;

public class VSPluginProcessRunner {
    public static void main(String[] args) {
        IAction action;
        if (args.length < 1) {
            System.err.println(Messages.getMessage("invalid.args", new Object[0]));
            System.exit(-1);
        }
        if ((action = VSPluginProcessRunner.parseArgs(args)) != null && action.execute()) {
            System.exit(0);
        }
        System.exit(-1);
    }

    private static IAction parseArgs(String[] args) {
        if (args[0].equalsIgnoreCase("prepare")) {
            return new PrepareAction(new File(args[1]));
        }
        if (args[0].equalsIgnoreCase("analyze")) {
            return new AnalyzeAction(new File(args[1]));
        }
        if (args[0].equalsIgnoreCase("report")) {
            return new GenerateReportAction(new File(args[1]), new File(args[2]));
        }
        if (args[0].equalsIgnoreCase("login")) {
            return new LoginAction(Arrays.copyOfRange(args, 1, args.length));
        }
        if (args[0].equalsIgnoreCase("checkjava")) {
            return new CheckJavaAction();
        }
        return null;
    }
}

