/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.java.stage;

import com.hcl.irx.slice.JavaStagerForSlicing;
import com.hcl.irx.stage.java.JavaStager;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.Messages;
import com.ibm.appscan.discovery.dir.BaseCustomCollector;
import com.ibm.appscan.discovery.java.IJavaStagerConstants;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import com.ibm.appscan.file.extension.ExtensionHelper;
import com.ibm.appscan.file.extension.FileExtensionException;
import com.ibm.appscan.internal.discovery.java.stage.JavaStagerStrategy;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class JavaStagerCollector
extends BaseCustomCollector
implements IJavaStagerConstants {
    private File m_root;
    private JavaStager m_stager;
    private IScanTargetProxy m_proxy;
    private IProgress m_progress;

    public JavaStagerCollector(File crawlRoot, IScanTargetProxy proxy) {
        super(crawlRoot, proxy.getIncludes(), proxy.getExcludes());
        this.m_root = crawlRoot;
        this.m_proxy = proxy;
    }

    protected File getRoot() {
        return this.m_root;
    }

    private JavaStager getStager() {
        if (this.m_stager == null) {
            File stage = new File(this.m_proxy.getScanHome(), "stage");
            this.m_stager = new JavaStager(stage, (IScanTargetMinProxy)this.m_proxy, this.m_progress, this.m_proxy.getIncludes(), this.m_proxy.getExcludes());
            if (SystemUtil.useSlicerForJavaFiles()) {
                this.m_stager = new JavaStagerForSlicing(stage, (IScanTargetMinProxy)this.m_proxy, this.m_progress, this.m_proxy.getIncludes(), this.m_proxy.getExcludes());
            }
        }
        return this.m_stager;
    }

    public void process(File file, String path, IProgress progress) {
        this.m_progress = progress;
        if (this.acceptFile(file)) {
            try {
                this.getStager().stageFileOrDirectory(file);
            }
            catch (IOException e) {
                this.m_proxy.getLogManager().log((Exception)e);
            }
            catch (ExclusionException e) {
                this.m_proxy.getLogManager().log((Exception)((Object)e));
            }
        }
    }

    protected Set<String> getFileExtensions() {
        HashSet<String> ret = new HashSet<String>();
        try {
            ret.addAll(ExtensionHelper.getFileExtensions((String)"java"));
        }
        catch (FileExtensionException e) {
            this.m_proxy.getLogManager().log(new Message(Messages.getMessage((String)"err.read.file.extensions", (Object[])new Object[]{"Java"}), (Throwable)e));
        }
        ret.remove("Java".toLowerCase());
        return ret;
    }

    public Set<IScanFile> getScanFiles() {
        Set files = this.getStager().getStagedScanFiles();
        this.m_proxy.getNameSpaces().addAll(this.getStager().getAnalysisPackagesTrimmed());
        return files;
    }

    public String getType() {
        return "category.java.stager";
    }

    protected String getFileExtensionSetName() {
        return "java";
    }

    protected ScanTargetStrategy getScanTargetStrategy(ScanTargetStrategy parentStrategy) {
        return new JavaStagerStrategy(this.m_root, this.getStager());
    }
}

