/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.regex.string;

import com.ibm.wala.automaton.LabeledString;
import com.ibm.wala.automaton.regex.string.AbstractPatternCompiler;
import com.ibm.wala.automaton.regex.string.ComplementPattern;
import com.ibm.wala.automaton.regex.string.ConcatenationPattern;
import com.ibm.wala.automaton.regex.string.EmptyPattern;
import com.ibm.wala.automaton.regex.string.IntersectionPattern;
import com.ibm.wala.automaton.regex.string.IterationPattern;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.regex.string.UnionPattern;
import com.ibm.wala.automaton.regex.string.VariableBindingPattern;
import com.ibm.wala.automaton.regex.string.VariableReferencePattern;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.ILabelSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.LabeledSymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;

public class RegexToLabeledString
extends AbstractPatternCompiler<LabeledString> {
    @Override
    public LabeledString onComplement(ComplementPattern pattern) {
        return LabeledString.make("(~").concat((LabeledString)((Object)this.compile(pattern.getPattern()))).concat(")");
    }

    @Override
    public LabeledString onConcatenation(ConcatenationPattern pattern) {
        return ((LabeledString)((Object)this.compile(pattern.getHead()))).concat((LabeledString)((Object)this.compile(pattern.getTail())));
    }

    @Override
    public LabeledString onEmpty(EmptyPattern pattern) {
        return LabeledString.make("");
    }

    @Override
    public LabeledString onIntersection(IntersectionPattern pattern) {
        return ((LabeledString)((Object)this.compile(pattern.getLeft()))).concat("&").concat((LabeledString)((Object)this.compile(pattern.getRight())));
    }

    @Override
    public LabeledString onIteration(IterationPattern pattern) {
        LabeledString s = (LabeledString)((Object)this.compile(pattern.getPattern()));
        switch (s.getString().length()) {
            case 0: {
                return LabeledString.make("", s.getLabel());
            }
            case 1: {
                return s.concat("*");
            }
        }
        return LabeledString.make("(").concat(s).concat(")*");
    }

    private String charSymbol(IEnumerableSymbol e) {
        if (e instanceof CharSymbol) {
            char c = ((CharSymbol)e).charValue();
            if (!Character.isISOControl(c)) {
                return Character.toString(c);
            }
            return "\\u" + c;
        }
        return "(unknown)";
    }

    @Override
    public LabeledString onSymbol(SymbolPattern pattern) {
        ISymbol s = pattern.getSymbol();
        ILabelSymbol l = ILabelSymbol.BOTTOM;
        if (s instanceof LabeledSymbol) {
            LabeledSymbol lsym = (LabeledSymbol)s;
            s = lsym.getValueSymbol();
            l = lsym.getLabel();
        }
        String str = null;
        if (s instanceof StringSymbol) {
            str = ((StringSymbol)s).getName();
        } else if (s instanceof CharSymbol) {
            char c = ((CharSymbol)s).charValue();
            str = !Character.isISOControl(c) ? Character.toString(c) : "\\u" + c;
        } else if (s instanceof RangeSymbol) {
            RangeSymbol r = (RangeSymbol)s;
            str = "[" + this.charSymbol(r.getMin()) + "-" + this.charSymbol(r.getMax()) + "]";
        } else {
            str = "(unknown)";
        }
        LabeledString lstr = LabeledString.make(str, l);
        return lstr;
    }

    @Override
    public LabeledString onUnion(UnionPattern pattern) {
        LabeledString s1 = (LabeledString)((Object)this.compile(pattern.getLeft()));
        LabeledString s2 = (LabeledString)((Object)this.compile(pattern.getRight()));
        return LabeledString.make("(").concat(s1).concat("|").concat(s2).concat(")");
    }

    @Override
    public LabeledString onVariableBinding(VariableBindingPattern pattern) {
        return LabeledString.make("(").concat((LabeledString)((Object)this.compile(pattern.getPattern()))).concat(")");
    }

    @Override
    public LabeledString onVariableReference(VariableReferencePattern pattern) {
        return LabeledString.make(pattern.getVariable().toString());
    }
}

