/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.DMap;
import com.ibm.wala.automaton.LabeledString;
import com.ibm.wala.automaton.grammar.string.CFLReachability;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.regex.string.AbstractPattern;
import com.ibm.wala.automaton.regex.string.ConcatenationPattern;
import com.ibm.wala.automaton.regex.string.EmptyPattern;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.IterationPattern;
import com.ibm.wala.automaton.regex.string.RegexToLabeledString;
import com.ibm.wala.automaton.regex.string.RegexToString;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.regex.string.UnionPattern;
import com.ibm.wala.automaton.regex.string.VariableBindingPattern;
import com.ibm.wala.automaton.regex.string.VariableReferencePattern;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.BooleanSymbol;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.ComplementTransition;
import com.ibm.wala.automaton.string.DeepSTSCopier;
import com.ibm.wala.automaton.string.DeepTransitionCopier;
import com.ibm.wala.automaton.string.Determinization;
import com.ibm.wala.automaton.string.FilteredTransition;
import com.ibm.wala.automaton.string.FreshNameFactory;
import com.ibm.wala.automaton.string.FreshStateFactory;
import com.ibm.wala.automaton.string.GraphAdapter;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.ILabelSymbol;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateFactory;
import com.ibm.wala.automaton.string.IStateVisitor;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.ITransitionVisitor;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IllegalAutomatonException;
import com.ibm.wala.automaton.string.IntersectionTransition;
import com.ibm.wala.automaton.string.LabeledGraphAdapter;
import com.ibm.wala.automaton.string.LabeledSymbol;
import com.ibm.wala.automaton.string.MatchContext;
import com.ibm.wala.automaton.string.Minimization;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.PredTransitionSet;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.SimpleSTSCopier;
import com.ibm.wala.automaton.string.SimpleStateCopier;
import com.ibm.wala.automaton.string.SimpleSymbolCopier;
import com.ibm.wala.automaton.string.SimpleTransitionCopier;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Symbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.automaton.util.labeledgraph.EdgeDecorator;
import com.ibm.wala.automaton.util.labeledgraph.IRegexAlgebra;
import com.ibm.wala.automaton.util.labeledgraph.IRegexFactory;
import com.ibm.wala.automaton.util.labeledgraph.LabelReduction;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.graph.labeled.LabeledGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class Automatons {
    public static String prefixState = "s";
    public static String prefixInputSymbol = "i";
    private static Collection<String> cyclicStrings = new HashSet<String>();

    public static String createUniqueStateName(IAutomaton automaton) {
        final HashSet<String> states = new HashSet<String>();
        automaton.traverseStates(new IStateVisitor(){

            @Override
            public void onVisit(IState state) {
                states.add(state.getName());
            }
        });
        return AUtil.createUniqueName(prefixState, states);
    }

    public static String createUniqueInputSymbolName(IAutomaton automaton) {
        final HashSet<String> symbols = new HashSet<String>();
        automaton.traverseTransitions(new ITransitionVisitor(){

            @Override
            public void onVisit(ITransition transition) {
                ISymbol sym = transition.getInputSymbol();
                if (sym != null) {
                    symbols.add(sym.getName());
                }
            }
        });
        return AUtil.createUniqueName(prefixInputSymbol, symbols);
    }

    public static IState createUniqueState(IAutomaton automaton) {
        return new State(Automatons.createUniqueStateName(automaton));
    }

    public static ISymbol createUniqueInputSymbol(IAutomaton automaton) {
        return new Symbol(Automatons.createUniqueInputSymbolName(automaton));
    }

    public static <T extends IState> Set<String> collectStateNames(Collection<T> states) {
        return new HashSet<String>(AUtil.collect(states, new AUtil.IElementMapper<T, String>(){

            @Override
            public String map(IState state) {
                return state.getName();
            }
        }));
    }

    public static Set<String> collectStateNames(IAutomaton automaton) {
        return Automatons.collectStateNames(automaton.getStates());
    }

    public static Set<ISymbol> collectInputSymbols(IAutomaton automaton) {
        final HashSet<ISymbol> symbols = new HashSet<ISymbol>();
        automaton.traverseTransitions(new ITransitionVisitor(){

            @Override
            public void onVisit(ITransition transition) {
                if (!transition.isEpsilonTransition()) {
                    ISymbol s = transition.getInputSymbol();
                    symbols.add(s);
                }
            }
        });
        return symbols;
    }

    public static <T extends ISymbol> Set<String> collectInputSymbolNames(Set<T> symbols) {
        return new HashSet<String>(AUtil.collect(symbols, new AUtil.IElementMapper<T, String>(){

            @Override
            public String map(ISymbol s) {
                return s.getName();
            }
        }));
    }

    public static Set<String> collectInputSymbolNames(IAutomaton automaton) {
        return Automatons.collectInputSymbolNames(Automatons.collectInputSymbols(automaton));
    }

    public static Collection<ISymbol> collectTerminals(IAutomaton ... as) {
        final HashSet<ISymbol> s = new HashSet<ISymbol>();
        for (IAutomaton a : as) {
            a.traverseTransitions(new ITransitionVisitor(){

                @Override
                public void onVisit(ITransition transition) {
                    s.addAll(transition.getTerminals());
                }
            });
        }
        return s;
    }

    public static IAutomaton useUniqueStates(IAutomaton target, IAutomaton base, Map<IState, IState> stateMap) {
        Set<String> baseNames = Automatons.collectStateNames(base);
        return Automatons.useUniqueStates(target, baseNames, stateMap);
    }

    public static IAutomaton useUniqueStates(IAutomaton target, Collection<String> names, Map<IState, IState> stateMap) {
        return Automatons.useUniqueStates(target, new FreshStateFactory(names), stateMap);
    }

    public static IAutomaton useUniqueStates(IAutomaton target, IStateFactory sf) {
        return Automatons.useUniqueStates(target, sf, new HashMap<IState, IState>());
    }

    public static IAutomaton useUniqueStates(IAutomaton target, IStateFactory sf, Map<IState, IState> stateMap) {
        final HashMap<IState, IState> map = stateMap == null ? new HashMap<IState, IState>() : stateMap;
        Set<IState> states = target.getStates();
        for (IState s : states) {
            IState u = sf.createState(prefixState);
            map.put(s, u);
        }
        final HashSet<ITransition> newTransitions = new HashSet<ITransition>();
        target.traverseTransitions(new ITransitionVisitor(){

            @Override
            public void onVisit(ITransition transition) {
                final IState preState = (IState)map.get(transition.getPreState());
                final IState postState = (IState)map.get(transition.getPostState());
                ITransition newTransition = transition.copy(new SimpleTransitionCopier(){

                    @Override
                    public IState copyPostState(ITransition t, IState s) {
                        return postState;
                    }

                    @Override
                    public IState copyPreState(ITransition t, IState s) {
                        return preState;
                    }
                });
                newTransitions.add(newTransition);
            }
        });
        IState initState = (IState)map.get(target.getInitialState());
        HashSet<IState> finalStates = new HashSet<IState>(AUtil.collect(target.getFinalStates(), new AUtil.IElementMapper<IState, IState>(){

            @Override
            public IState map(IState s) {
                return (IState)map.get(s);
            }
        }));
        Automaton result = new Automaton(initState, finalStates, newTransitions);
        return result;
    }

    public static IAutomaton useUniqueInputSymbols(IAutomaton target, IAutomaton base, Map<ISymbol, ISymbol> symMap) {
        Set<String> baseNames = Automatons.collectInputSymbolNames(base);
        return Automatons.useUniqueInputSymbols(target, baseNames, symMap);
    }

    public static IAutomaton useUniqueInputSymbols(IAutomaton target, Set<String> baseNames, Map<ISymbol, ISymbol> symMap) {
        final HashMap<ISymbol, Symbol> map = symMap == null ? new HashMap<ISymbol, Symbol>() : symMap;
        Set<ISymbol> symbols = Automatons.collectInputSymbols(target);
        for (ISymbol s : symbols) {
            String n = AUtil.createUniqueName("i", baseNames);
            Symbol u = new Symbol(n);
            map.put(s, u);
        }
        final HashSet<ITransition> newTransitions = new HashSet<ITransition>();
        target.traverseTransitions(new ITransitionVisitor(){

            @Override
            public void onVisit(ITransition transition) {
                if (transition.getInputSymbol() instanceof IVariable) {
                    newTransitions.add(transition);
                } else {
                    final ISymbol isym = (ISymbol)map.get(transition.getInputSymbol());
                    ITransition newTransition = transition.copy(new SimpleTransitionCopier(){

                        @Override
                        public ISymbol copyInput(ITransition t, ISymbol s) {
                            return isym;
                        }
                    });
                    newTransitions.add(newTransition);
                }
            }
        });
        IState initState = target.getInitialState();
        Set<IState> finalStates = target.getFinalStates();
        Automaton result = new Automaton(initState, finalStates, newTransitions);
        return result;
    }

    public static IAutomaton reverse(IAutomaton fst, IStateFactory sf) {
        IAutomaton result = (IAutomaton)fst.copy(new DeepSTSCopier(new SimpleTransitionCopier(){

            @Override
            public IState copyPostState(ITransition t, IState s) {
                return t.getPreState();
            }

            @Override
            public IState copyPreState(ITransition t, IState s) {
                return t.getPostState();
            }
        }));
        IState init = result.getInitialState();
        Set<IState> fin = result.getFinalStates();
        if (fin.size() == 1) {
            IState f = fin.iterator().next();
            result.setInitialState(f);
            result.getFinalStates().clear();
            result.getFinalStates().add(init);
        } else {
            IState s = sf.createState("s");
            result.setInitialState(s);
            for (IState f : fin) {
                Transition t = new Transition(s, f);
                result.getTransitions().add(t);
            }
            result.getFinalStates().clear();
            result.getFinalStates().add(init);
        }
        return result;
    }

    public static IAutomaton createAny(IState s) {
        return new Automaton(s, new IState[]{s}, new ITransition[]{new Transition(s, s, new RangeSymbol('\u0000', '\uffff'))});
    }

    public static IAutomaton createAny(IStateFactory sf) {
        return Automatons.createAny(sf.createState("s"));
    }

    public static IAutomaton createEmpty(IState s) {
        return new Automaton(s, new IState[]{s}, new ITransition[0]);
    }

    public static IAutomaton createEmpty(IStateFactory sf) {
        return Automatons.createEmpty(sf.createState("s"));
    }

    public static IStateFactory createFreshStateFactory(Collection<IAutomaton> automatons) {
        HashSet<IState> states = new HashSet<IState>();
        for (IAutomaton a : automatons) {
            states.addAll(a.getStates());
        }
        FreshStateFactory sf = new FreshStateFactory(Automatons.collectStateNames(states));
        return sf;
    }

    public static IAutomaton createConcatenation(List<IAutomaton> automatons) {
        IStateFactory sf = Automatons.createFreshStateFactory(automatons);
        if (automatons.isEmpty()) {
            return Automatons.createEmpty(sf.createState("s"));
        }
        Iterator<IAutomaton> i = automatons.iterator();
        IAutomaton result = Automatons.useUniqueStates(i.next(), sf);
        while (i.hasNext()) {
            IAutomaton a = Automatons.useUniqueStates(i.next(), sf);
            Automatons.createSimpleConcatenation(result, a);
        }
        return result;
    }

    public static IAutomaton createConcatenation(IAutomaton automaton1, IAutomaton automaton2) {
        return Automatons.createConcatenation(Arrays.asList(automaton1, automaton2));
    }

    public static void createSimpleConcatenation(IAutomaton automaton1, IAutomaton automaton2) {
        IState initState2 = automaton2.getInitialState();
        Set<IState> finalStates1 = automaton1.getFinalStates();
        for (IState finalState1 : finalStates1) {
            if (finalState1.equals(initState2)) continue;
            Transition newTransition = new Transition(finalState1, initState2);
            automaton1.getTransitions().add(newTransition);
        }
        automaton1.getTransitions().addAll(automaton2.getTransitions());
        automaton1.getFinalStates().clear();
        automaton1.getFinalStates().addAll(automaton2.getFinalStates());
    }

    public static void createSimpleConcatenation(List<IAutomaton> as) {
        if (as.isEmpty()) {
            return;
        }
        Iterator<IAutomaton> i = as.iterator();
        IAutomaton r = i.next();
        while (i.hasNext()) {
            Automatons.createSimpleConcatenation(r, i.next());
        }
    }

    public static IAutomaton createUnion(Collection<IAutomaton> automatons) {
        IStateFactory sf = Automatons.createFreshStateFactory(automatons);
        if (automatons.isEmpty()) {
            return Automatons.createEmpty(sf.createState(prefixState));
        }
        Iterator<IAutomaton> i = automatons.iterator();
        IAutomaton r = Automatons.useUniqueStates(i.next(), sf);
        while (i.hasNext()) {
            IAutomaton a = Automatons.useUniqueStates(i.next(), sf);
            Automatons.createSimpleUnion(r, a);
        }
        return r;
    }

    public static IAutomaton createUnionAutomaton(Collection<ISymbol> syms, IStateFactory sf) {
        IState s0 = sf.createState(prefixState);
        IState s1 = sf.createState(prefixState);
        HashSet<ITransition> transitions = new HashSet<ITransition>();
        for (ISymbol sym : syms) {
            transitions.add(new Transition(s0, s1, sym));
        }
        Automaton a = new Automaton(s0, Collections.singleton(s1), transitions);
        return a;
    }

    public static IAutomaton createUnionAutomaton(Collection<ISymbol> syms) {
        FreshStateFactory sf = new FreshStateFactory();
        return Automatons.createUnionAutomaton(syms, sf);
    }

    public static IAutomaton createUnion(IAutomaton automaton1, IAutomaton automaton2, Map<IState, IState> stateMap) {
        automaton2 = Automatons.useUniqueStates(automaton2, automaton1, stateMap);
        IAutomaton result = (IAutomaton)automaton1.copy(SimpleSTSCopier.defaultCopier);
        Automatons.createSimpleUnion(result, automaton2);
        return result;
    }

    public static void createSimpleUnion(IAutomaton automaton1, IAutomaton automaton2) {
        final IState initState1 = automaton1.getInitialState();
        final IState initState2 = automaton2.getInitialState();
        SimpleStateCopier stateCopier = new SimpleStateCopier(){

            @Override
            public IState copy(IState state) {
                if (state.equals(initState2)) {
                    return initState1;
                }
                return state;
            }
        };
        automaton2 = (IAutomaton)automaton2.copy(new DeepSTSCopier(new DeepTransitionCopier(SimpleSymbolCopier.defaultCopier, stateCopier)));
        automaton1.getFinalStates().addAll(automaton2.getFinalStates());
        automaton1.getTransitions().addAll(automaton2.getTransitions());
    }

    public static IAutomaton createUnion(IAutomaton automaton1, IAutomaton automaton2) {
        return Automatons.createUnion(automaton1, automaton2, new HashMap<IState, IState>());
    }

    public static IAutomaton createCompleteAutomaton(IAutomaton automaton, IState failState, IStateFactory sf, IVariable v, List<ISymbol> outputSymbols, FilteredTransition.IFilter filter) {
        automaton = Automatons.determinize(automaton, sf);
        Set<IState> states = automaton.getStates();
        HashSet<ComplementTransition> newTransitions = new HashSet<ComplementTransition>();
        for (IState s : states) {
            Set<ITransition> nextTransitions = automaton.getTransitions(s);
            ComplementTransition complement = new ComplementTransition(s, failState, v, outputSymbols, filter, nextTransitions);
            newTransitions.add(complement);
        }
        automaton.getTransitions().addAll(newTransitions);
        return automaton;
    }

    public static IAutomaton createComplement(IAutomaton automaton, IVariable v, FilteredTransition.IFilter filter, IStateFactory sf) {
        IAutomaton ca = (IAutomaton)automaton.copy(SimpleSTSCopier.defaultCopier);
        if (sf == null) {
            sf = new FreshStateFactory(ca);
        }
        IState failState = sf.createState(prefixState);
        ca = Automatons.createCompleteAutomaton(ca, failState, sf, v, AUtil.list(new ISymbol[0]), filter);
        FilteredTransition t = new FilteredTransition(failState, failState, (ISymbol)v, new ISymbol[0], filter);
        HashSet<IState> finalStates = new HashSet<IState>(ca.getStates());
        finalStates.add(failState);
        finalStates.removeAll(ca.getFinalStates());
        ca.getTransitions().add(t);
        ca.getFinalStates().clear();
        ca.getFinalStates().addAll(finalStates);
        return ca;
    }

    public static IAutomaton createComplementByChars(IAutomaton automaton) {
        return Automatons.expandByChars(Automatons.createComplement(Automatons.expandByChars(automaton, AUtil.nullProgressMonitor)), AUtil.nullProgressMonitor);
    }

    public static IAutomaton createComplement(IAutomaton automaton, Collection<ISymbol> symbols) {
        return Automatons.createComplement(Automatons.expand(automaton, symbols));
    }

    public static IAutomaton createComplement(IAutomaton automaton, IStateFactory sf) {
        return Automatons.createComplement(automaton, new Variable("_"), null, sf);
    }

    public static IAutomaton createComplement(IAutomaton automaton) {
        return Automatons.createComplement(automaton, new Variable("_"), null, null);
    }

    public static IAutomaton createIntersection(IAutomaton automaton1, IAutomaton automaton2) {
        return Automatons.createIntersection(automaton1, automaton2, AUtil.nullProgressMonitor);
    }

    public static IAutomaton createIntersection(IAutomaton automaton1, IAutomaton automaton2, MonitorUtil.IProgressMonitor monitor) {
        automaton1 = (IAutomaton)automaton1.copy(SimpleSTSCopier.defaultCopier);
        automaton2 = (IAutomaton)automaton2.copy(SimpleSTSCopier.defaultCopier);
        Automatons.eliminateEpsilonTransitions(automaton1, monitor);
        Automatons.eliminateEpsilonTransitions(automaton2, monitor);
        final HashSet<Transition> transitions = new HashSet<Transition>();
        final FreshNameFactory names = new FreshNameFactory();
        DMap<Pair<IState, IState>, IState> map = new DMap<Pair<IState, IState>, IState>(new DMap.Factory<Pair<IState, IState>, IState>(){

            @Override
            public IState create(Pair<IState, IState> key) {
                return new State(names.createName("s"));
            }
        });
        int N = 100;
        int n = 0;
        Set<ITransition> tset1 = automaton1.getTransitions();
        Set<ITransition> tset2 = automaton2.getTransitions();
        Set<ITransition> initSet1 = automaton1.getTransitions(automaton1.getInitialState());
        Set<ITransition> initSet2 = automaton2.getTransitions(automaton2.getInitialState());
        if (!(tset1.size() != initSet1.size() && tset2.size() != initSet2.size() || Automatons.hasSelfTransition(initSet1) || Automatons.hasSelfTransition(initSet2))) {
            tset1 = initSet1;
            tset2 = initSet2;
        }
        for (ITransition t1 : tset1) {
            int n2 = n = n == 100 ? 0 : n + 1;
            if (n == 0 && monitor.isCanceled()) {
                throw CancelRuntimeException.make((String)"intersection operation");
            }
            for (ITransition t2 : tset2) {
                List<ISymbol> output;
                Pair post;
                Pair pre;
                MatchContext ctx = new MatchContext();
                ISymbol input1 = t1.getInputSymbol();
                ISymbol input2 = t2.getInputSymbol();
                if (input1 instanceof IVariable || input2 instanceof IVariable) {
                    ISymbol input;
                    List<ISymbol> output2;
                    FilteredTransition.IFilter filter;
                    pre = Pair.make((Object)t1.getPreState(), (Object)t2.getPreState());
                    post = Pair.make((Object)t1.getPostState(), (Object)t2.getPostState());
                    if (t1 instanceof FilteredTransition) {
                        filter = ((FilteredTransition)t1).getFilter();
                        output2 = t1.getOutputSymbols();
                        input = t1.getInputSymbol();
                    } else if (t2 instanceof FilteredTransition) {
                        filter = ((FilteredTransition)t2).getFilter();
                        output2 = t2.getOutputSymbols();
                        input = t2.getInputSymbol();
                    } else {
                        filter = null;
                        output2 = Collections.emptyList();
                        input = t1.getInputSymbol();
                    }
                    IntersectionTransition t = new IntersectionTransition(map.get(pre), map.get(post), input, output2, filter, Arrays.asList(t1, t2));
                    transitions.add(t);
                    continue;
                }
                if (input1 instanceof RangeSymbol && input2 instanceof RangeSymbol) {
                    RangeSymbol r = RangeSymbol.intersection((RangeSymbol)input1, (RangeSymbol)input2);
                    if (r == null) continue;
                    List<ISymbol> output3 = t1.hasOutputSymbols() ? t1.getOutputSymbols() : (t2.hasOutputSymbols() ? t2.getOutputSymbols() : Collections.emptyList());
                    Pair pre2 = Pair.make((Object)t1.getPreState(), (Object)t2.getPreState());
                    Pair post2 = Pair.make((Object)t1.getPostState(), (Object)t2.getPostState());
                    Transition t = new Transition(map.get(pre2), map.get(post2), (ISymbol)r, output3);
                    transitions.add(t);
                    continue;
                }
                if (input1.matches(input2, ctx)) {
                    pre = Pair.make((Object)t1.getPreState(), (Object)t2.getPreState());
                    post = Pair.make((Object)t1.getPostState(), (Object)t2.getPostState());
                    output = t1.hasOutputSymbols() ? t1.getOutputSymbols() : (t2.hasOutputSymbols() ? t2.getOutputSymbols() : Collections.emptyList());
                    Transition ta = new Transition(map.get(pre), map.get(post), t2.getInputSymbol(), output);
                    transitions.add(ta);
                    continue;
                }
                if (!input2.matches(input1, ctx)) continue;
                pre = Pair.make((Object)t1.getPreState(), (Object)t2.getPreState());
                post = Pair.make((Object)t1.getPostState(), (Object)t2.getPostState());
                output = t1.hasOutputSymbols() ? t1.getOutputSymbols() : (t2.hasOutputSymbols() ? t2.getOutputSymbols() : Collections.emptyList());
                Transition t = new Transition(map.get(pre), map.get(post), t1.getInputSymbol(), output);
                transitions.add(t);
            }
        }
        final IState initState = map.get(Pair.make((Object)automaton1.getInitialState(), (Object)automaton2.getInitialState()));
        final HashSet<IState> finalStates = new HashSet<IState>();
        for (IState f1 : automaton1.getFinalStates()) {
            for (IState f2 : automaton2.getFinalStates()) {
                Pair cs = Pair.make((Object)f1, (Object)f2);
                if (!map.containsKey(cs)) continue;
                finalStates.add(map.get(cs));
            }
        }
        final IAutomaton origAutomaton1 = automaton1;
        IAutomaton a = (IAutomaton)automaton1.copy(new SimpleSTSCopier(){

            @Override
            public Collection<ITransition> copyTransitions(Collection<? extends ITransition> _transitions, Collection<ITransition> result) {
                result.addAll(transitions);
                return result;
            }

            @Override
            public IState copy(IState s) {
                if (s == origAutomaton1.getInitialState()) {
                    return initState;
                }
                return super.copy(s);
            }

            @Override
            public Collection<IState> copyStates(Collection<? extends IState> states, Collection<IState> result) {
                if (states == origAutomaton1.getFinalStates()) {
                    result.addAll(finalStates);
                    return result;
                }
                return super.copyStates(states, result);
            }
        });
        Automatons.eliminateUnreachableStates(a);
        return a;
    }

    private static boolean hasSelfTransition(Collection<? extends ITransition> ts) {
        for (ITransition iTransition : ts) {
            if (!iTransition.getPreState().equals(iTransition.getPostState())) continue;
            return true;
        }
        return false;
    }

    public static IAutomaton translateAutomaton(IAutomaton tr, IAutomaton fst) {
        return Automatons.translateAutomaton(tr, fst, AUtil.nullProgressMonitor);
    }

    public static IAutomaton translateAutomaton(IAutomaton tr, IAutomaton fst, MonitorUtil.IProgressMonitor monitor) {
        tr = (IAutomaton)tr.copy(SimpleSTSCopier.defaultCopier);
        fst = (IAutomaton)fst.copy(SimpleSTSCopier.defaultCopier);
        Automatons.eliminateEpsilonTransitions(tr);
        Automatons.eliminateEpsilonTransitions(fst);
        Collection<ISymbol> allSyms = Automatons.collectTerminals(fst, tr);
        allSyms = RangeSymbol.splitSymbols(allSyms);
        fst = Automatons.expand(fst, allSyms);
        final HashSet<Transition> transitions = new HashSet<Transition>();
        final FreshNameFactory names = new FreshNameFactory();
        DMap<Pair<IState, IState>, IState> map = new DMap<Pair<IState, IState>, IState>(new DMap.Factory<Pair<IState, IState>, IState>(){

            @Override
            public IState create(Pair<IState, IState> key) {
                return new State(names.createName("s"));
            }
        });
        int N = 100;
        int n = 0;
        Set<ITransition> trTrSet = tr.getTransitions();
        Set<ITransition> fstTrSet = fst.getTransitions();
        Set<ITransition> trInitSet = tr.getTransitions(tr.getInitialState());
        Set<ITransition> fstInitSet = fst.getTransitions(fst.getInitialState());
        if (!(trTrSet.size() != trInitSet.size() && fstTrSet.size() != fstInitSet.size() || Automatons.hasSelfTransition(trInitSet) || Automatons.hasSelfTransition(fstInitSet))) {
            trTrSet = trInitSet;
            fstTrSet = fstInitSet;
        }
        for (ITransition t1 : trTrSet) {
            int n2 = n = n == 100 ? 0 : n + 1;
            if (n == 0 && monitor.isCanceled()) {
                throw CancelRuntimeException.make((String)"translation");
            }
            for (ITransition t2 : fstTrSet) {
                IMatchContext ctx = MatchContext.DummyContext;
                if (!t1.accept(t2.getInputSymbol(), ctx)) continue;
                Pair pre = Pair.make((Object)t1.getPreState(), (Object)t2.getPreState());
                Pair post = Pair.make((Object)t1.getPostState(), (Object)t2.getPostState());
                List<ISymbol> output = t1.transit(t2.getInputSymbol());
                if (output.isEmpty()) {
                    Transition t = new Transition(map.get(pre), map.get(post));
                    transitions.add(t);
                    continue;
                }
                IState s = map.get(pre);
                Iterator<ISymbol> k = output.iterator();
                while (k.hasNext()) {
                    Transition t;
                    ISymbol o = k.next();
                    if (k.hasNext()) {
                        State ss = new State(names.createName("s"));
                        t = new Transition(s, ss, o);
                        s = ss;
                    } else {
                        t = new Transition(s, map.get(post), o);
                    }
                    transitions.add(t);
                }
            }
        }
        final IState initState = map.get(Pair.make((Object)tr.getInitialState(), (Object)fst.getInitialState()));
        final HashSet<IState> finalStates = new HashSet<IState>();
        for (IState f1 : tr.getFinalStates()) {
            for (IState f2 : fst.getFinalStates()) {
                Pair cs = Pair.make((Object)f1, (Object)f2);
                if (!map.containsKey(cs)) continue;
                finalStates.add(map.get(cs));
            }
        }
        final IAutomaton origAutomaton1 = tr;
        IAutomaton a = (IAutomaton)tr.copy(new SimpleSTSCopier(){

            @Override
            public Collection<ITransition> copyTransitions(Collection<? extends ITransition> _transitions, Collection<ITransition> result) {
                result.addAll(transitions);
                return result;
            }

            @Override
            public IState copy(IState s) {
                if (s == origAutomaton1.getInitialState()) {
                    return initState;
                }
                return super.copy(s);
            }

            @Override
            public Collection<IState> copyStates(Collection<? extends IState> states, Collection<IState> result) {
                if (states == origAutomaton1.getFinalStates()) {
                    result.addAll(finalStates);
                    return result;
                }
                return super.copyStates(states, result);
            }
        });
        Automatons.eliminateUnreachableStates(a);
        return a;
    }

    public static IAutomaton createSubtraction(IAutomaton a1, IAutomaton a2) {
        return Automatons.createIntersection(a1, Automatons.createComplement(a2));
    }

    public static IPattern toPattern(IAutomaton automaton) {
        Set<VariableBindingPattern> equations = Automatons.createEquations(automaton);
        return Automatons.solvePatternEquations(equations, new Variable(automaton.getInitialState().getName()));
    }

    public static IPattern solvePatternEquations(Set<VariableBindingPattern> equations, IVariable variable) {
        throw new AssertionError((Object)"equation solver is not implemented yet");
    }

    private static Set<VariableBindingPattern> createEquations(IAutomaton automaton) {
        final HashSet<VariableBindingPattern> equations = new HashSet<VariableBindingPattern>();
        automaton.traverseTransitions(new ITransitionVisitor(){

            @Override
            public void onVisit(ITransition transition) {
                Variable lhs = new Variable(transition.getPreState().getName());
                AbstractPattern rhs = null;
                if (!transition.isEpsilonTransition()) {
                    SymbolPattern rhs1 = new SymbolPattern(transition.getInputSymbol());
                    VariableReferencePattern rhs2 = new VariableReferencePattern(new Variable(transition.getPostState().getName()));
                    rhs = new ConcatenationPattern(rhs1, rhs2);
                } else {
                    rhs = new VariableReferencePattern(new Variable(transition.getPostState().getName()));
                }
                VariableBindingPattern equation = new VariableBindingPattern(lhs, rhs);
                equations.add(equation);
            }
        });
        return equations;
    }

    public static Automaton createAutomaton(List<? extends ISymbol> symbols) {
        ISymbol[] syms = new ISymbol[symbols.size()];
        symbols.toArray(syms);
        return Automatons.createAutomaton(syms);
    }

    public static Automaton createAutomaton(ISymbol[] symbols) {
        int i;
        State initState;
        HashSet<ITransition> transitions = new HashSet<ITransition>();
        HashSet<IState> finalStates = new HashSet<IState>();
        State preState = initState = new State("s" + i);
        for (i = 0; i < symbols.length; ++i) {
            State postState = new State("s" + i + 1);
            Transition trans = new Transition(preState, postState, symbols[i]);
            transitions.add(trans);
            preState = postState;
        }
        finalStates.add(preState);
        Automaton automaton = new Automaton((IState)initState, finalStates, transitions);
        return automaton;
    }

    public static void eliminateUnreachableStates(IAutomaton automaton) {
        Set<IState> reachableStates = Automatons.collectReachableStates(automaton);
        IAutomaton rev = Automatons.reverse(automaton, new FreshStateFactory(Automatons.collectStateNames(automaton)));
        Set<IState> reachableStatesB = Automatons.collectReachableStates(rev);
        reachableStates.retainAll(reachableStatesB);
        Iterator<Cloneable> i = automaton.getTransitions().iterator();
        while (i.hasNext()) {
            ITransition t = i.next();
            if (reachableStates.contains(t.getPreState()) && reachableStates.contains(t.getPostState())) continue;
            i.remove();
        }
        i = automaton.getFinalStates().iterator();
        while (i.hasNext()) {
            IState s = (IState)i.next();
            if (reachableStates.contains(s)) continue;
            i.remove();
        }
    }

    public static Set<IState> collectReachableStates(IAutomaton automaton) {
        HashSet<IState> s = new HashSet<IState>();
        Automatons.collectReachableStates(automaton, automaton.getInitialState(), s);
        return s;
    }

    private static void collectReachableStates(IAutomaton automaton, IState s, Set<IState> states) {
        if (states.contains(s)) {
            return;
        }
        states.add(s);
        for (ITransition t : automaton.getTransitions(s)) {
            Automatons.collectReachableStates(automaton, t.getPostState(), states);
        }
    }

    public static void eliminateEpsilonTransitions(IAutomaton automaton) {
        Automatons.eliminateEpsilonTransitions(automaton, AUtil.nullProgressMonitor);
    }

    public static void eliminateEpsilonTransitions(IAutomaton automaton, MonitorUtil.IProgressMonitor monitor) {
        Automatons.eliminateEpsilonTransitions2(automaton, monitor);
    }

    private static <T extends Collection<ITransition>> T collectReachableEpsilonTransitions(IAutomaton a, T l) {
        HashSet<IState> visited = new HashSet<IState>();
        Stack<IState> stack = new Stack<IState>();
        stack.add(a.getInitialState());
        while (!stack.isEmpty()) {
            IState s = (IState)stack.pop();
            if (visited.contains(s)) continue;
            visited.add(s);
            for (ITransition t : a.getTransitions(s)) {
                if (t.isEpsilonTransition()) {
                    l.add((ITransition)t);
                }
                stack.push(t.getPostState());
            }
        }
        return l;
    }

    public static void eliminateEpsilonTransitions2(IAutomaton automaton, MonitorUtil.IProgressMonitor monitor) {
        Automatons.eliminateUnreachableStates(automaton);
        Stack<ITransition> epsilons = Automatons.collectReachableEpsilonTransitions(automaton, new Stack());
        Collections.reverse(epsilons);
        Stack<ITransition> stack = new Stack<ITransition>();
        Set<ITransition> transitions = automaton.getTransitions();
        HashSet<ITransition> epsFins = new HashSet<ITransition>();
        while (!epsilons.isEmpty()) {
            ITransition t = (ITransition)epsilons.pop();
            Automatons.eliminateEpsilonTransitions(automaton, transitions, t, stack, epsilons, epsFins, monitor);
        }
        Automatons.eliminateFinalEpsilonTransitions(automaton, epsFins, monitor);
        Automatons.eliminateUnreachableStates(automaton);
    }

    public static void eliminateEpsilonTransitions(IAutomaton automaton, Set<ITransition> transitions, ITransition t, Stack<ITransition> stack, Stack<ITransition> epsilons, Set<ITransition> epsFins, MonitorUtil.IProgressMonitor monitor) {
        if (stack.contains(t)) {
            return;
        }
        epsilons.remove(t);
        transitions.remove(t);
        stack.push(t);
        IState postState = t.getPostState();
        ArrayList<ITransition> nextTransitions = new ArrayList<ITransition>(automaton.getTransitions(postState));
        for (ITransition t2 : nextTransitions) {
            if (t2.isEpsilonTransition()) {
                Automatons.eliminateEpsilonTransitions(automaton, transitions, t2, stack, epsilons, epsFins, monitor);
                continue;
            }
            if (monitor.isCanceled()) {
                throw CancelRuntimeException.make((String)"epsilon transitin elimination");
            }
            ArrayList<ISymbol> prepend = new ArrayList<ISymbol>();
            Stack<ITransition> trs = new Stack<ITransition>();
            trs.addAll(stack);
            Collections.reverse(trs);
            for (ITransition t1 : trs) {
                prepend.addAll(0, t1.getOutputSymbols());
                ITransition nt = Automatons.combineEpsilonTransition(t1.getPreState(), t2.getPostState(), prepend, Collections.emptyList(), t2);
                transitions.add(nt);
            }
        }
        if (automaton.getFinalStates().contains(postState)) {
            if (t.hasOutputSymbols()) {
                transitions.add(t);
                epsFins.add(t);
            } else {
                automaton.getFinalStates().add(t.getPreState());
            }
        }
        stack.pop();
    }

    public static void eliminateEpsilonTransitions1(IAutomaton automaton, MonitorUtil.IProgressMonitor monitor) {
        Set<ITransition> epsFin = Automatons.eliminateNonfinalEpsilonTransitions(automaton, monitor);
        Automatons.eliminateFinalEpsilonTransitions(automaton, epsFin, monitor);
        Automatons.eliminateUnreachableStates(automaton);
    }

    private static Set<ITransition> eliminateNonfinalEpsilonTransitions(IAutomaton automaton, MonitorUtil.IProgressMonitor monitor) {
        HashSet<ITransition> epsTransitions = new HashSet<ITransition>();
        HashSet<ITransition> epsFin = new HashSet<ITransition>();
        int N = 100;
        int n = 0;
        Iterator<ITransition> i = automaton.getTransitions().iterator();
        while (i.hasNext()) {
            int n2 = n = n == 100 ? 0 : n + 1;
            if (n == 0 && monitor.isCanceled()) {
                throw CancelRuntimeException.make((String)"epsilon transition elimination");
            }
            ITransition t = i.next();
            if (!t.isEpsilonTransition()) continue;
            if (t.getPreState().equals(t.getPostState())) {
                i.remove();
                continue;
            }
            if (automaton.getFinalStates().contains(t.getPostState())) {
                epsFin.add(t);
                continue;
            }
            epsTransitions.add(t);
        }
        HashMap<ITransition, Set<ITransition>> epsilonClosure = new HashMap<ITransition, Set<ITransition>>();
        for (ITransition iTransition : epsTransitions) {
            Automatons.calculateEpsilonClosure(automaton, iTransition, epsilonClosure, epsFin, monitor);
        }
        for (Map.Entry entry : epsilonClosure.entrySet()) {
            Set ts = (Set)entry.getValue();
            automaton.getTransitions().addAll(ts);
        }
        automaton.getTransitions().removeAll(epsTransitions);
        return epsFin;
    }

    private static Set<ITransition> calculateEpsilonClosure(IAutomaton automaton, ITransition transition, Map<ITransition, Set<ITransition>> epsilonClosure, Set<ITransition> epsFin, MonitorUtil.IProgressMonitor monitor) {
        if (epsilonClosure.containsKey(transition)) {
            Set<ITransition> ts3 = epsilonClosure.get(transition);
            return ts3 == null ? Collections.emptySet() : ts3;
        }
        if (transition.isEpsilonTransition()) {
            epsilonClosure.put(transition, null);
            HashSet<ITransition> ts3 = new HashSet<ITransition>();
            final List<ISymbol> output = transition.getOutputSymbols();
            final IState preState = transition.getPreState();
            Set<ITransition> nextTransitions = automaton.getTransitions(transition.getPostState());
            Set<IState> finStates = automaton.getFinalStates();
            if (finStates.contains(transition.getPostState())) {
                ts3.add(transition);
            }
            for (ITransition t : nextTransitions) {
                Set<ITransition> ts2 = Automatons.calculateEpsilonClosure(automaton, t, epsilonClosure, epsFin, monitor);
                if (ts2 == null) continue;
                for (ITransition t2 : ts2) {
                    ITransition t3 = t2.copy(new SimpleTransitionCopier(){

                        @Override
                        public List<ISymbol> copyOutput(ITransition t, List<? extends ISymbol> l, List<ISymbol> result) {
                            result.addAll(output);
                            result.addAll(l);
                            return result;
                        }

                        @Override
                        public IState copyPreState(ITransition t, IState s) {
                            return preState;
                        }
                    });
                    ts3.add(t3);
                    if (!t3.isEpsilonTransition() || !finStates.contains(t3.getPostState())) continue;
                    epsFin.add(t3);
                }
            }
            epsilonClosure.put(transition, ts3);
            return ts3;
        }
        return Collections.singleton(transition);
    }

    private static void eliminateFinalEpsilonTransitions(IAutomaton automaton, Set<ITransition> epsFin, MonitorUtil.IProgressMonitor monitor) {
        HashSet<ITransition> add = new HashSet<ITransition>();
        Set<IState> finStates = automaton.getFinalStates();
        IState initState = automaton.getInitialState();
        PredTransitionSet predSet = new PredTransitionSet((Collection<? extends ITransition>)automaton.getTransitions());
        for (ITransition t2 : epsFin) {
            add.clear();
            if (initState.equals(t2.getPreState())) {
                finStates.add(initState);
                Set<ITransition> succTransitions = automaton.getTransitions(t2.getPostState());
                for (ITransition t3 : succTransitions) {
                    if (t3.isEpsilonTransition()) continue;
                    ITransition t4 = Automatons.combineEpsilonTransition(t2.getPreState(), t3.getPostState(), t2.getOutputSymbols(), Collections.emptyList(), t3);
                    add.add(t4);
                }
            }
            Set predTransitions = predSet.getSet(t2.getPreState());
            for (ITransition t1 : predTransitions) {
                if (t1.isEpsilonTransition()) continue;
                ITransition t3 = Automatons.combineEpsilonTransition(t1.getPreState(), t2.getPostState(), Collections.emptyList(), t2.getOutputSymbols(), t1);
                add.add(t3);
            }
            automaton.getTransitions().addAll(add);
            predSet.addAll(add);
            add.clear();
        }
        automaton.getTransitions().removeAll(epsFin);
    }

    private static ITransition combineEpsilonTransition(final IState preState, final IState postState, final List<ISymbol> prepend, final List<ISymbol> postpend, ITransition t) {
        if (t instanceof FilteredTransition) {
            FilteredTransition ft2 = (FilteredTransition)t;
            final FilteredTransition.IFilter filter2 = ft2.getFilter();
            FilteredTransition.IFilter filter3 = new FilteredTransition.IFilter(){

                @Override
                public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> result) {
                    result = filter2.invoke(symbol, result);
                    result.addAll(0, prepend);
                    result.addAll(postpend);
                    return result;
                }
            };
            FilteredTransition.ICondition cond3 = ft2.getCondition();
            FilteredTransition t3 = new FilteredTransition(preState, postState, t.getInputSymbol(), t.getOutputSymbols(), filter3, cond3);
            return t3;
        }
        final ArrayList<ISymbol> output = new ArrayList<ISymbol>(prepend);
        output.addAll(t.getOutputSymbols());
        output.addAll(postpend);
        ITransition t3 = t.copy(new SimpleTransitionCopier(){

            @Override
            public List<ISymbol> copyOutput(ITransition t, List<? extends ISymbol> l, List<ISymbol> result) {
                result.addAll(output);
                return result;
            }

            @Override
            public IState copyPreState(ITransition t, IState s) {
                return preState;
            }

            @Override
            public IState copyPostState(ITransition t, IState s) {
                return postState;
            }
        });
        return t3;
    }

    /*
     * WARNING - void declaration
     */
    public static void reduceTransitions(IAutomaton automaton) {
        HashMap m = new HashMap();
        Set<ITransition> transitions = automaton.getTransitions();
        HashSet<ITransition> removed = new HashSet<ITransition>();
        for (ITransition iTransition : transitions) {
            void var10_12;
            List<ISymbol> output;
            if (!iTransition.getClass().equals(Transition.class) || iTransition.getInputSymbol() instanceof IVariable) continue;
            ISymbol input = iTransition.getInputSymbol();
            Pair ss = Pair.make((Object)iTransition.getPreState(), (Object)iTransition.getPostState());
            Pair key = Pair.make((Object)ss, output = iTransition.getOutputSymbols());
            Set set = (Set)m.get(key);
            if (set == null) {
                HashSet hashSet = new HashSet();
                m.put(key, hashSet);
            }
            var10_12.add(input);
            removed.add(iTransition);
        }
        transitions.removeAll(removed);
        for (Map.Entry entry : m.entrySet()) {
            Pair key = (Pair)entry.getKey();
            Set input = (Set)entry.getValue();
            Collection<ISymbol> syms = RangeSymbol.mergeSymbols(input);
            for (ISymbol iSymbol : syms) {
                Transition t = new Transition((IState)((Pair)key.fst).fst, (IState)((Pair)key.fst).snd, iSymbol, (List)key.snd);
                transitions.add(t);
            }
        }
    }

    public static IAutomaton determinize(IAutomaton a) {
        return Determinization.determinize(a, null, AUtil.nullProgressMonitor);
    }

    public static IAutomaton determinize(IAutomaton a, IStateFactory sf) {
        return Determinization.determinize(a, sf, AUtil.nullProgressMonitor);
    }

    public static IAutomaton determinize(IAutomaton a, MonitorUtil.IProgressMonitor monitor) {
        return Determinization.determinize(a, null, monitor);
    }

    public static <T extends IAutomaton> T minimize(T automaton) {
        return Minimization.minimize(automaton);
    }

    public static <T extends IAutomaton> T minimize(T automaton, MonitorUtil.IProgressMonitor monitor) {
        return Minimization.minimize(automaton, monitor);
    }

    public static IAutomaton expand(IAutomaton automaton, Collection<ISymbol> allSymbols) {
        return Automatons.expand(automaton, allSymbols, AUtil.nullProgressMonitor);
    }

    public static IAutomaton expand(IAutomaton automaton, Collection<ISymbol> allSymbols, MonitorUtil.IProgressMonitor monitor) {
        automaton = (IAutomaton)automaton.copy(SimpleSTSCopier.defaultCopier);
        if (allSymbols.isEmpty()) {
            return automaton;
        }
        MatchContext ctx = new MatchContext();
        HashSet<ITransition> transitions = new HashSet<ITransition>();
        int N = 100;
        int n = 0;
        for (ITransition t : automaton.getTransitions()) {
            int n2 = n = n == 100 ? 0 : n + 1;
            if (n == 0 && monitor.isCanceled()) {
                throw CancelRuntimeException.make((String)"expanding an automaton");
            }
            for (ISymbol input : allSymbols) {
                if (t.isEpsilonTransition()) {
                    transitions.add(t);
                    continue;
                }
                if (!t.accept(input, ctx)) continue;
                List<ISymbol> outputs = t.transit(input);
                Transition tt = new Transition(t.getPreState(), t.getPostState(), input, outputs);
                transitions.add(tt);
            }
        }
        automaton.getTransitions().clear();
        automaton.getTransitions().addAll(transitions);
        return automaton;
    }

    public static IAutomaton expandByChars(IAutomaton fst) {
        return Automatons.expandByChars(fst, AUtil.nullProgressMonitor);
    }

    public static IAutomaton expandByChars(IAutomaton fst, MonitorUtil.IProgressMonitor monitor) {
        Collection<ISymbol> syms = Automatons.collectTerminals(fst);
        Collection<ISymbol> ex = new HashSet<ISymbol>();
        syms.add(new RangeSymbol('\u0000', '\uffff'));
        for (ISymbol s : syms) {
            if (s instanceof IVariable) continue;
            ex.add(s);
        }
        ex = RangeSymbol.splitSymbols(ex);
        return Automatons.expand(fst, ex, monitor);
    }

    public static String toGraphviz(IAutomaton automaton) {
        return Automatons.toGraphviz(automaton, new SimpleGraphvizLabelGenerator());
    }

    public static String toGraphviz(IAutomaton automaton, IGraphvizLabelGenerator labelGenerator) {
        StringBuffer buff = new StringBuffer();
        buff.append("digraph G {");
        buff.append(AUtil.lineSeparator);
        buff.append("  \"\" [fillcolor=black, shape=point]");
        buff.append(AUtil.lineSeparator);
        buff.append("  \"\" -> \"" + automaton.getInitialState() + "\";");
        buff.append(AUtil.lineSeparator);
        for (IState s : automaton.getFinalStates()) {
            buff.append("  \"" + s + "\" [shape=doublecircle];");
            buff.append(AUtil.lineSeparator);
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (ITransition t : automaton.getTransitions()) {
            lines.add("  \"" + t.getPreState() + "\" -> \"" + t.getPostState() + "\" [label=\"" + labelGenerator.getLabel(t).replaceAll("\"", "\\\"") + "\"];");
        }
        Collections.sort(lines);
        for (String line : lines) {
            buff.append(line);
            buff.append(AUtil.lineSeparator);
        }
        buff.append("}");
        return buff.toString();
    }

    public static IAutomaton createSublanguageAutomaton(IAutomaton a, IState s0, IState s) {
        ITransition[] trans = new ITransition[a.getTransitions().size()];
        a.getTransitions().toArray(trans);
        Automaton ret = new Automaton(s0, new IState[]{s}, trans);
        Automatons.eliminateUnreachableStates(ret);
        return Automatons.expandByChars(ret, AUtil.nullProgressMonitor);
    }

    public static boolean equals(IAutomaton a1, IAutomaton a2) {
        return Automatons.equals(a1, a2, AUtil.nullProgressMonitor);
    }

    public static boolean equals(IAutomaton a1, IAutomaton a2, MonitorUtil.IProgressMonitor monitor) {
        return Automatons.containsAll(a1, a2, monitor) && Automatons.containsAll(a2, a1, monitor);
    }

    public static boolean containsAll(IAutomaton a1, IAutomaton a2) {
        return Automatons.containsAll(a1, a2, AUtil.nullProgressMonitor);
    }

    public static boolean containsAll(IAutomaton a1, IAutomaton a2, MonitorUtil.IProgressMonitor monitor) {
        IAutomaton c = Automatons.createComplement(a1);
        IAutomaton i = Automatons.createIntersection(c, a2, monitor);
        Collection<ISymbol> syms = RangeSymbol.splitSymbols(Automatons.collectTerminals(i));
        IAutomaton e = Automatons.expand(i, syms, monitor);
        return Automatons.isEmpty(e);
    }

    public static boolean containsSome(IAutomaton a1, IAutomaton a2) {
        return Automatons.containsSome(a1, a2, AUtil.nullProgressMonitor);
    }

    public static boolean containsSome(IAutomaton a1, IAutomaton a2, MonitorUtil.IProgressMonitor monitor) {
        IAutomaton i = Automatons.createIntersection(a1, a2);
        Collection<ISymbol> syms = RangeSymbol.splitSymbols(Automatons.collectTerminals(i));
        IAutomaton e = Automatons.expand(i, syms);
        return !Automatons.isEmpty(e);
    }

    public static boolean containsSomeByCFL(IAutomaton a1, IAutomaton a2, MonitorUtil.IProgressMonitor monitor) {
        Collection<ISymbol> syms = RangeSymbol.splitSymbols(Automatons.collectTerminals(a1, a2));
        a2 = Automatons.expand(a2, syms);
        return CFLReachability.containsSome(Grammars.toCFG(a2), a1, monitor);
    }

    public static boolean isEmpty(IAutomaton a) {
        return Automatons.isEpsilonReachable(a) || !Automatons.isReachable(a);
    }

    public static boolean isReachable(IAutomaton a) {
        return Automatons.isReachable(a, a.getInitialState(), a.getFinalStates(), new HashSet<IState>());
    }

    private static boolean isReachable(IAutomaton a, IState s, Collection<IState> finalStates, Collection<IState> h) {
        if (finalStates.contains(s)) {
            return true;
        }
        if (h.contains(s)) {
            return false;
        }
        h.add(s);
        for (ITransition t : a.getTransitions(s)) {
            if (!Automatons.isReachable(a, t.getPostState(), finalStates, h)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEpsilonReachable(IAutomaton a) {
        HashSet<IState> h = new HashSet<IState>();
        for (ITransition t : a.getTransitions(a.getInitialState())) {
            if (t.isEpsilonTransition()) {
                if (Automatons.isEpsilonReachable(a, t.getPostState(), a.getFinalStates(), h)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean isEpsilonReachable(IAutomaton a, IState s, Collection<IState> finalStates, Collection<IState> h) {
        if (finalStates.contains(s)) {
            return true;
        }
        if (h.contains(s)) {
            return false;
        }
        h.add(s);
        for (ITransition t : a.getTransitions(s)) {
            if (t.isEpsilonTransition()) {
                if (Automatons.isEpsilonReachable(a, t.getPostState(), finalStates, h)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static Collection<String> toStrings(final IAutomaton fst) {
        final State pseudoInitial = new State("INIT");
        final State pseudoFinal = new State("FIN");
        EdgeDecorator<IState, Collection<String>> labels = new EdgeDecorator<IState, Collection<String>>(){

            @Override
            public Collection<String> getLabel(IState src, IState dest) {
                if (src == pseudoInitial && dest == fst.getInitialState()) {
                    return Collections.singleton("");
                }
                if (fst.getFinalStates().contains(src) && dest == pseudoFinal) {
                    return Collections.singleton("");
                }
                HashSet<String> result = new HashSet<String>();
                for (ITransition t : fst.getTransitions(src)) {
                    if (!t.getPostState().equals(dest)) continue;
                    ISymbol s = t.getInputSymbol();
                    if (s == null) {
                        result.add("");
                        continue;
                    }
                    if (s instanceof CharSymbol) {
                        result.add(Character.toString(((CharSymbol)s).charValue()));
                        continue;
                    }
                    if (!(s instanceof StringSymbol)) continue;
                    result.add(((StringSymbol)s).getName());
                }
                return result;
            }
        };
        IRegexAlgebra<Collection<String>> edgeVisitor = new IRegexAlgebra<Collection<String>>(){

            @Override
            public Collection<String> concat(Collection<String> e1, Collection<String> e2) {
                if (e1 == cyclicStrings || e2 == cyclicStrings) {
                    return cyclicStrings;
                }
                HashSet<String> s = new HashSet<String>();
                for (String s1 : e1) {
                    for (String s2 : e2) {
                        s.add(s1 + s2);
                    }
                }
                return s;
            }

            @Override
            public Collection<String> kleene(Collection<String> e) {
                return cyclicStrings;
            }

            @Override
            public Collection<String> union(Collection<String> e1, Collection<String> e2) {
                if (e1 == cyclicStrings || e2 == cyclicStrings) {
                    return cyclicStrings;
                }
                HashSet<String> s = new HashSet<String>();
                s.addAll(e1);
                s.addAll(e2);
                return s;
            }
        };
        return Automatons.toStrings(fst, pseudoInitial, pseudoFinal, labels, edgeVisitor);
    }

    public static Collection<String> toStrings(IAutomaton fst, IState pseudoInitial, IState pseudoFinal, EdgeDecorator<IState, Collection<String>> labels, IRegexAlgebra<Collection<String>> labelop) {
        Iterator<IState> exits;
        GraphAdapter graph = new GraphAdapter(fst);
        Iterator<IState> entries = Collections.singleton(fst.getInitialState()).iterator();
        Collection<String> result = LabelReduction.reduceLabels(graph, labels, entries, exits = fst.getFinalStates().iterator(), pseudoInitial, pseudoFinal, labelop);
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public static IPattern toRegex(IAutomaton fst) {
        return Automatons.toRegex(fst, new IRegexAlgebra<IPattern>(){

            @Override
            public IPattern concat(IPattern e1, IPattern e2) {
                return ConcatenationPattern.make(e1, e2);
            }

            @Override
            public IPattern kleene(IPattern e) {
                return IterationPattern.make(e);
            }

            @Override
            public IPattern union(IPattern e1, IPattern e2) {
                return UnionPattern.make(e1, e2);
            }
        });
    }

    public static <S, L, P> P toRegex(LabeledGraph<S, L> graph, S initState, Collection<S> finStates, S pseudoInit, S pseudoFinal, IRegexFactory<P, L> labelop) {
        return LabelReduction.reduceLabels(graph, Collections.singleton(initState), finStates, pseudoInit, pseudoFinal, labelop);
    }

    public static IPattern toRegex(IAutomaton fst, final IRegexAlgebra<IPattern> labelop) {
        LabeledGraphAdapter graph = new LabeledGraphAdapter(fst);
        State pseudoInit = new State("INIT");
        State pseudoFinal = new State("FIN");
        IRegexFactory<IPattern, ISymbol> patternFactory = new IRegexFactory<IPattern, ISymbol>(){

            @Override
            public IPattern makeEmpty() {
                return EmptyPattern.make();
            }

            @Override
            public IPattern makeSymbol(ISymbol s) {
                return SymbolPattern.make(s);
            }

            @Override
            public IPattern kleene(IPattern e) {
                return labelop.kleene(e);
            }

            @Override
            public IPattern union(IPattern e1, IPattern e2) {
                return labelop.union(e1, e2);
            }

            @Override
            public IPattern concat(IPattern e1, IPattern e2) {
                return labelop.concat(e1, e2);
            }
        };
        return Automatons.toRegex(graph, fst.getInitialState(), fst.getFinalStates(), pseudoInit, pseudoFinal, patternFactory);
    }

    public static LabeledString toLabeledRegexString(IAutomaton fst) {
        RegexToLabeledString conv = new RegexToLabeledString();
        IPattern pat = Automatons.toRegex(fst);
        if (pat == null) {
            return null;
        }
        return (LabeledString)((Object)conv.compile(pat));
    }

    public static LabeledString toLabeledRegexString(IAutomaton fst, IRegexAlgebra<IPattern> labelop) {
        RegexToLabeledString conv = new RegexToLabeledString();
        IPattern pat = Automatons.toRegex(fst, labelop);
        if (pat == null) {
            return null;
        }
        return (LabeledString)((Object)conv.compile(pat));
    }

    public static String toRegexString(IAutomaton fst) {
        RegexToString conv = new RegexToString();
        IPattern pat = Automatons.toRegex(fst);
        if (pat == null) {
            return null;
        }
        return (String)conv.compile(pat);
    }

    public static String toRegexString(IAutomaton fst, IRegexAlgebra<IPattern> labelop) {
        RegexToString conv = new RegexToString();
        IPattern pat = Automatons.toRegex(fst, labelop);
        if (pat == null) {
            return null;
        }
        return (String)conv.compile(pat);
    }

    public static Collection<String> toStarStrings(IAutomaton fst) {
        return Automatons.toStarStrings(fst, new IRegexFactory<Collection<String>, ISymbol>(){

            @Override
            public Collection<String> concat(Collection<String> e1, Collection<String> e2) {
                HashSet<String> r = new HashSet<String>();
                for (String s1 : e1) {
                    for (String s2 : e2) {
                        r.add(s1.concat(s2));
                    }
                }
                return r;
            }

            @Override
            public Collection<String> kleene(Collection<String> e) {
                HashSet<String> r = new HashSet<String>();
                Collection<String> c = AUtil.combination(e, new AUtil.IConcatenation<String>(){

                    @Override
                    public String concat(String e1, String e2) {
                        return e1.concat(e2);
                    }

                    @Override
                    public String empty() {
                        return "";
                    }
                });
                block4: for (String s : c) {
                    switch (s.length()) {
                        case 0: {
                            r.add("");
                            continue block4;
                        }
                        case 1: {
                            r.add(s.concat("*"));
                            continue block4;
                        }
                    }
                    r.add("(" + s + ")*");
                }
                return r;
            }

            @Override
            public Collection<String> union(Collection<String> e1, Collection<String> e2) {
                HashSet<String> r = new HashSet<String>();
                r.addAll(e1);
                r.addAll(e2);
                return r;
            }

            @Override
            public Collection<String> makeEmpty() {
                return Collections.singleton("");
            }

            @Override
            public Collection<String> makeSymbol(ISymbol s) {
                String str;
                HashSet<String> result = new HashSet<String>();
                if (s == null) {
                    str = "";
                } else if (s instanceof StringSymbol) {
                    str = ((StringSymbol)s).getName();
                } else if (s instanceof CharSymbol) {
                    str = ((CharSymbol)s).getName();
                } else if (s instanceof RangeSymbol) {
                    RangeSymbol r = (RangeSymbol)s;
                    IEnumerableSymbol lmin = r.getMin();
                    IEnumerableSymbol lmax = r.getMax();
                    str = "[" + lmin + "-" + lmax + "]";
                } else {
                    str = "(?" + s.getClass().getSimpleName() + "?)";
                }
                result.add(str);
                return result;
            }
        });
    }

    public static Collection<String> toStarStrings(IAutomaton fst, IRegexFactory<Collection<String>, ISymbol> labelop) {
        LabeledGraphAdapter graph = new LabeledGraphAdapter(fst);
        State pseudoInitial = new State("INIT");
        State pseudoFinal = new State("FIN");
        Set<IState> entries = Collections.singleton(fst.getInitialState());
        Set<IState> exits = fst.getFinalStates();
        Collection<String> result = LabelReduction.reduceLabels(graph, entries, exits, pseudoInitial, pseudoFinal, labelop);
        return result;
    }

    public static Collection<LabeledString> toLabeledStarStrings(IAutomaton fst) {
        return Automatons.toLabeledStarStrings(fst, new IRegexAlgebra<Collection<LabeledString>>(){

            @Override
            public Collection<LabeledString> concat(Collection<LabeledString> e1, Collection<LabeledString> e2) {
                HashSet<LabeledString> r = new HashSet<LabeledString>();
                for (LabeledString s1 : e1) {
                    for (LabeledString s2 : e2) {
                        r.add(s1.concat(s2));
                    }
                }
                return r;
            }

            @Override
            public Collection<LabeledString> kleene(Collection<LabeledString> e) {
                HashSet<LabeledString> r = new HashSet<LabeledString>();
                Collection<LabeledString> c = AUtil.combination(e, new AUtil.IConcatenation<LabeledString>(){

                    @Override
                    public LabeledString concat(LabeledString e1, LabeledString e2) {
                        return e1.concat(e2);
                    }

                    @Override
                    public LabeledString empty() {
                        return LabeledString.make("");
                    }
                });
                block4: for (LabeledString s : c) {
                    switch (s.getString().length()) {
                        case 0: {
                            r.add(LabeledString.make("", s.getLabel()));
                            continue block4;
                        }
                        case 1: {
                            r.add(s.concat("*"));
                            continue block4;
                        }
                    }
                    r.add(LabeledString.make("(").concat(s).concat(")").concat("*"));
                }
                return r;
            }

            @Override
            public Collection<LabeledString> union(Collection<LabeledString> e1, Collection<LabeledString> e2) {
                HashSet<LabeledString> r = new HashSet<LabeledString>();
                r.addAll(e1);
                r.addAll(e2);
                return LabeledString.reduce(r);
            }
        });
    }

    public static Collection<LabeledString> toLabeledStarStrings(final IAutomaton fst, IRegexAlgebra<Collection<LabeledString>> labelop) {
        GraphAdapter graph = new GraphAdapter(fst);
        final State pseudoInitial = new State("INIT");
        final State pseudoFinal = new State("FIN");
        EdgeDecorator<IState, Collection<LabeledString>> labels = new EdgeDecorator<IState, Collection<LabeledString>>(){

            @Override
            public Collection<LabeledString> getLabel(IState src, IState dest) {
                if (src == pseudoInitial && dest == fst.getInitialState()) {
                    return Collections.singleton(LabeledString.make(""));
                }
                if (fst.getFinalStates().contains(src) && dest == pseudoFinal) {
                    return Collections.singleton(LabeledString.make(""));
                }
                HashSet<LabeledString> result = new HashSet<LabeledString>();
                for (ITransition t : fst.getTransitions(src)) {
                    String str = null;
                    if (!t.getPostState().equals(dest)) continue;
                    ISymbol s = t.getInputSymbol();
                    ILabelSymbol l = ILabelSymbol.BOTTOM;
                    if (s instanceof LabeledSymbol) {
                        LabeledSymbol lsym = (LabeledSymbol)s;
                        s = lsym.getValueSymbol();
                        l = lsym.getLabel();
                    }
                    if (s == null) {
                        str = "";
                    } else if (s instanceof StringSymbol) {
                        str = ((StringSymbol)s).getName();
                    } else if (s instanceof CharSymbol) {
                        str = ((CharSymbol)s).getName();
                    } else if (s instanceof RangeSymbol) {
                        RangeSymbol r = (RangeSymbol)s;
                        LabeledSymbol lmin = (LabeledSymbol)r.getMin();
                        LabeledSymbol lmax = (LabeledSymbol)r.getMax();
                        str = "[" + lmin.getValueSymbol() + "-" + lmax.getValueSymbol() + "]";
                        l = lmin.getLabel().meet(lmax.getLabel());
                    } else {
                        str = "(?" + s.getClass().getSimpleName() + "?)";
                    }
                    LabeledString lstr = LabeledString.make(str, l);
                    result.add(lstr);
                }
                return result;
            }
        };
        Iterator<IState> entries = Collections.singleton(fst.getInitialState()).iterator();
        Iterator<IState> exits = fst.getFinalStates().iterator();
        Collection<LabeledString> result = LabelReduction.reduceLabels(graph, labels, entries, exits, pseudoInitial, pseudoFinal, labelop);
        return result;
    }

    public static Collection<String> stringValues(IAutomaton a, int sizeLimit, boolean nullAtCyclicState) {
        return Automatons.stringValues(a, sizeLimit, new IsFinalState(a), nullAtCyclicState ? new NullAtCyclicState() : new EmptyStringAtCyclicState());
    }

    public static Collection<String> stringValues(IAutomaton a, int sizeLimit, String strAtCyclicState) {
        return Automatons.stringValues(a, sizeLimit, new IsFinalState(a), new StringValuesAtCyclicState(Collections.singleton(strAtCyclicState)));
    }

    public static Collection<String> stringValues(IAutomaton a, int sizeLimit, Function<IState, Boolean> isFinal, Function<IState, Collection<String>> cyclic) {
        return Automatons.stringValues(a, sizeLimit, new TransitionCharacters(sizeLimit), isFinal, cyclic);
    }

    public static Collection<String> stringValues(IAutomaton a, int sizeLimit, Function<ISymbol, Collection<String>> f, Function<IState, Boolean> isFinal, Function<IState, Collection<String>> cyclic) {
        return Automatons.stringValues(a, a.getInitialState(), sizeLimit, f, isFinal, cyclic, new HashSet<IState>());
    }

    private static Collection<String> stringValues(IAutomaton a, IState s, int sizeLimit, Function<ISymbol, Collection<String>> f, Function<IState, Boolean> isFinal, Function<IState, Collection<String>> cyclic, HashSet<IState> h) {
        if (h.contains(s)) {
            Collection ss = (Collection)cyclic.apply((Object)s);
            if (ss == null) {
                return null;
            }
            return ss;
        }
        h.add(s);
        HashSet<String> strs = new HashSet<String>();
        if (((Boolean)isFinal.apply((Object)s)).booleanValue()) {
            strs.add("");
        }
        block0: for (ITransition t : a.getTransitions(s)) {
            Collection<String> strs2 = Automatons.stringValues(a, t.getPostState(), sizeLimit, f, isFinal, cyclic, (HashSet)h.clone());
            if (strs2 == null) {
                return null;
            }
            Collection ss = (Collection)f.apply((Object)t.getInputSymbol());
            if (ss == null) continue;
            for (String str : ss) {
                for (String str2 : strs2) {
                    if (strs.size() >= sizeLimit) continue block0;
                    strs.add(str + str2);
                }
            }
        }
        return strs;
    }

    public static Collection<NumberSymbol> numberValues(IAutomaton a) throws IllegalAutomatonException {
        return Automatons.constantValues(a, NumberSymbol.class);
    }

    public static Collection<CharSymbol> charValues(IAutomaton a) throws IllegalAutomatonException {
        return Automatons.constantValues(a, CharSymbol.class);
    }

    public static Collection<BooleanSymbol> booleanValues(IAutomaton a) throws IllegalAutomatonException {
        return Automatons.constantValues(a, BooleanSymbol.class);
    }

    public static <T> Collection<T> constantValues(IAutomaton a, Class<T> klass) throws IllegalAutomatonException {
        a = (IAutomaton)a.copy(SimpleSTSCopier.defaultCopier);
        Automatons.eliminateEpsilonTransitions(a);
        Set<IState> fin = a.getFinalStates();
        HashSet<T> cs = new HashSet<T>();
        for (ITransition t : a.getTransitions(a.getInitialState())) {
            if (fin.contains(t.getPostState())) {
                ISymbol sym = t.getInputSymbol();
                if (klass.isInstance(sym)) {
                    cs.add(klass.cast(sym));
                    continue;
                }
                throw new IllegalAutomatonException();
            }
            throw new IllegalAutomatonException();
        }
        return cs;
    }

    public static class SimpleGraphvizLabelGenerator
    implements IGraphvizLabelGenerator {
        @Override
        public String getLabel(ITransition t) {
            return t.getInputSymbol() + "/" + t.getOutputSymbols();
        }
    }

    public static interface IGraphvizLabelGenerator {
        public String getLabel(ITransition var1);
    }

    public static final class EmptyStringAtCyclicState
    extends StringValuesAtCyclicState {
        public EmptyStringAtCyclicState() {
            super(Collections.singleton(""));
        }
    }

    public static final class NullAtCyclicState
    extends StringValuesAtCyclicState {
        public NullAtCyclicState() {
            super(null);
        }
    }

    public static class StringValuesAtCyclicState
    implements Function<IState, Collection<String>> {
        private final Collection<String> value;

        public StringValuesAtCyclicState(Collection<String> value) {
            this.value = value;
        }

        public Collection<String> apply(IState s) {
            return this.value;
        }
    }

    public static final class TransitionCharacters
    implements Function<ISymbol, Collection<String>> {
        private final int sizeLimit;

        public TransitionCharacters(int sizeLimit) {
            this.sizeLimit = sizeLimit;
        }

        public Collection<String> apply(ISymbol s) {
            if (s == null) {
                return Collections.singleton("");
            }
            if (s instanceof CharSymbol) {
                CharSymbol c = (CharSymbol)s;
                return Collections.singleton(Character.toString(c.charValue()));
            }
            if (s instanceof StringSymbol) {
                StringSymbol ss = (StringSymbol)s;
                return Collections.singleton(ss.getName());
            }
            if (s instanceof RangeSymbol) {
                RangeSymbol r = (RangeSymbol)s;
                IEnumerableSymbol min = r.getMin();
                IEnumerableSymbol max = r.getMax();
                if (min instanceof CharSymbol && max instanceof CharSymbol) {
                    char imax;
                    CharSymbol cmin = (CharSymbol)min;
                    CharSymbol cmax = (CharSymbol)max;
                    int imin = cmin.charValue();
                    if (imin == (imax = cmax.charValue())) {
                        return Collections.singleton(Character.toString((char)imin));
                    }
                    if (imax - imin < this.sizeLimit) {
                        HashSet<String> ss = new HashSet<String>();
                        for (int i = imin; i <= imax; ++i) {
                            ss.add(Character.toString((char)i));
                        }
                        return ss;
                    }
                }
                return Collections.emptySet();
            }
            return Collections.emptySet();
        }
    }

    private static final class IsFinalState
    implements Function<IState, Boolean> {
        private final IAutomaton a;

        private IsFinalState(IAutomaton a) {
            this.a = a;
        }

        public Boolean apply(IState s) {
            return this.a.getFinalStates().contains(s);
        }
    }
}

