/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.string.FilteredTransition;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class IntersectionTransition
extends FilteredTransition {
    public IntersectionTransition(IState preState, IState postState, ISymbol inputSymbol, List<ISymbol> outputSymbols, FilteredTransition.IFilter filter, Collection<ITransition> transitions) {
        super(preState, postState, inputSymbol, outputSymbols, filter, (FilteredTransition.ICondition)new Condition(transitions));
    }

    public IntersectionTransition(IState preState, IState postState, ISymbol inputSymbol, ISymbol[] outputSymbols, FilteredTransition.IFilter filter, ITransition[] transitions) {
        super(preState, postState, inputSymbol, outputSymbols, filter, (FilteredTransition.ICondition)new Condition(transitions));
    }

    public IntersectionTransition(IState preState, IState postState, ISymbol inputSymbol, ITransition[] transitions) {
        super(preState, postState, inputSymbol, new Condition(transitions));
    }

    private static class Condition
    implements FilteredTransition.ICondition {
        private Collection<ITransition> transitions;

        public Condition(Collection<ITransition> transitions) {
            this.transitions = transitions;
        }

        public Condition(ITransition[] transitions) {
            this(AUtil.list(transitions));
        }

        @Override
        public boolean accept(ISymbol symbol, IMatchContext ctx) {
            for (ITransition t : this.transitions) {
                if (t.accept(symbol, ctx)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Collection<ISymbol> getTerminals() {
            HashSet<ISymbol> s = new HashSet<ISymbol>();
            for (ITransition t : this.transitions) {
                s.addAll(t.getTerminals());
            }
            return s;
        }
    }
}

