/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.DMap;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.DeepSTSCopier;
import com.ibm.wala.automaton.string.DeepTransitionCopier;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.PredTransitionSet;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.SimpleSTSCopier;
import com.ibm.wala.automaton.string.SimpleStateCopier;
import com.ibm.wala.automaton.string.SimpleSymbolCopier;
import com.ibm.wala.automaton.string.StateReplacer;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Minimization {
    public static <T extends IAutomaton> T minimize(T automaton) {
        return Minimization.minimize(automaton, AUtil.nullProgressMonitor);
    }

    public static <T extends IAutomaton> T minimize(T automaton, MonitorUtil.IProgressMonitor monitor) {
        automaton = (IAutomaton)automaton.copy(SimpleSTSCopier.defaultCopier);
        return Minimization.minimizeBackward(Minimization.minimizeForward(automaton, monitor), monitor);
    }

    private static Collection<IState> postStates(Collection<ITransition> ts, IState pre) {
        HashSet<IState> ss = new HashSet<IState>();
        for (ITransition t : ts) {
            ss.add(t.getPostState());
        }
        ss.remove(pre);
        return ss;
    }

    private static Collection<IState> preStates(Collection<ITransition> ts, IState post) {
        HashSet<IState> ss = new HashSet<IState>();
        for (ITransition t : ts) {
            ss.add(t.getPreState());
        }
        ss.remove(post);
        return ss;
    }

    private static <T extends IAutomaton> T minimizeBackward(T automaton, MonitorUtil.IProgressMonitor monitor) {
        automaton = Minimization.minimizeFinalStates(automaton);
        boolean cont = true;
        while (cont) {
            if (monitor.isCanceled()) {
                return automaton;
            }
            cont = false;
            DMap<Pair<ISymbol, IState>, Collection<IState>> m = new DMap<Pair<ISymbol, IState>, Collection<IState>>(){

                @Override
                protected Collection<IState> create(Pair<ISymbol, IState> key) {
                    return new HashSet<IState>();
                }
            };
            IState initState = automaton.getInitialState();
            for (ITransition t : automaton.getTransitions()) {
                IState pre = t.getPreState();
                if (initState.equals(pre)) continue;
                IState post = t.getPostState();
                Pair key = Pair.make((Object)t.getInputSymbol(), (Object)post);
                if (Minimization.postStates(automaton.getTransitions(pre), pre).size() != 1) continue;
                ((Collection)m.get(key)).add(pre);
            }
            HashMap<IState, IState> replace = new HashMap<IState, IState>();
            for (Map.Entry e : m.entrySet()) {
                Collection l = (Collection)e.getValue();
                if (l.size() <= 1) continue;
                Iterator i = l.iterator();
                IState s = (IState)i.next();
                while (i.hasNext()) {
                    replace.put((IState)i.next(), s);
                }
                cont = true;
            }
            if (!cont) continue;
            automaton = (IAutomaton)automaton.copy(new DeepSTSCopier(new StateReplacer(replace)));
        }
        return automaton;
    }

    private static <T extends IAutomaton> T minimizeFinalStates(T automaton) {
        IState finState = null;
        HashSet<IState> finStates = new HashSet<IState>();
        for (IState s : automaton.getFinalStates()) {
            if (!automaton.getTransitions(s).isEmpty()) continue;
            if (finState == null) {
                finState = s;
                continue;
            }
            finStates.add(s);
        }
        if (!finStates.isEmpty()) {
            automaton = Minimization.combineStates(automaton, finStates, finState);
            automaton.getFinalStates().removeAll(finStates);
        }
        return automaton;
    }

    private static <T extends IAutomaton> T minimizeForward(T automaton, MonitorUtil.IProgressMonitor monitor) {
        boolean cont = true;
        while (cont) {
            if (monitor.isCanceled()) {
                return automaton;
            }
            PredTransitionSet predSet = new PredTransitionSet((Collection<? extends ITransition>)automaton.getTransitions());
            cont = false;
            DMap<Pair<IState, ISymbol>, Collection<IState>> m = new DMap<Pair<IState, ISymbol>, Collection<IState>>(){

                @Override
                protected Collection<IState> create(Pair<IState, ISymbol> key) {
                    return new HashSet<IState>();
                }
            };
            for (ITransition t : automaton.getTransitions()) {
                IState pre = t.getPreState();
                IState post = t.getPostState();
                Pair key = Pair.make((Object)pre, (Object)t.getInputSymbol());
                if (Minimization.preStates(predSet.getSet(post), post).size() != 1) continue;
                ((Collection)m.get(key)).add(post);
            }
            HashMap<IState, IState> replace = new HashMap<IState, IState>();
            for (Map.Entry e : m.entrySet()) {
                Collection l = (Collection)e.getValue();
                if (l.size() <= 1) continue;
                Iterator i = l.iterator();
                IState s = (IState)i.next();
                while (i.hasNext()) {
                    replace.put((IState)i.next(), s);
                }
                cont = true;
            }
            if (!cont) continue;
            automaton = (IAutomaton)automaton.copy(new DeepSTSCopier(new StateReplacer(replace)));
        }
        return automaton;
    }

    public static <T extends IAutomaton> T combineStates(T automaton, final Collection<IState> states, final IState newState) {
        return (T)((IAutomaton)automaton.copy(new DeepSTSCopier(new DeepTransitionCopier(SimpleSymbolCopier.defaultCopier, new SimpleStateCopier(){

            @Override
            public IState copy(IState state) {
                if (states.contains(state)) {
                    return newState;
                }
                return state;
            }
        }))));
    }

    public static <T extends IAutomaton> T minimize(T automaton, int sizeLimit) {
        return Minimization.minimize(automaton, sizeLimit, AUtil.nullProgressMonitor);
    }

    public static <T extends IAutomaton> T minimize(T automaton, int sizeLimit, MonitorUtil.IProgressMonitor monitor) {
        automaton = (IAutomaton)automaton.copy(SimpleSTSCopier.defaultCopier);
        Automatons.eliminateEpsilonTransitions(automaton);
        DistAnalysis da = new DistAnalysis((IAutomaton)automaton, sizeLimit, monitor);
        da.doAnalysis(sizeLimit);
        Map<IState, IState> replace = da.makeReplaceMap();
        automaton = (IAutomaton)automaton.copy(new DeepSTSCopier(new StateReplacer(replace)));
        return (T)automaton;
    }

    private static class DistAnalysis {
        private IAutomaton automaton;
        private List<IState> states;
        private DistTable dtable;
        private Collection<ISymbol> symbols;
        private MonitorUtil.IProgressMonitor monitor;
        private Map<IState, Map<ISymbol, Set<ITransition>>> transitionsMap;

        public DistAnalysis(IAutomaton a, int sizeLimit, MonitorUtil.IProgressMonitor monitor) {
            this.monitor = monitor;
            this.automaton = a;
            this.states = new ArrayList<IState>(this.automaton.getStates());
            Collection<ISymbol> terminals = Automatons.collectTerminals(a);
            this.symbols = RangeSymbol.splitSymbols(terminals);
            this.dtable = new DistTable();
            this.transitionsMap = new HashMap<IState, Map<ISymbol, Set<ITransition>>>();
            this.initTable(sizeLimit);
        }

        private void initTable(int sizeLimit) {
            this.dtable.setSizeLimit(sizeLimit);
            Set<IState> finStates = this.automaton.getFinalStates();
            HashSet<IState> nonFinStates = new HashSet<IState>(this.states);
            nonFinStates.removeAll(finStates);
            for (IState nonFinState : nonFinStates) {
                for (IState finState : finStates) {
                    this.dtable.distinguishable(nonFinState, finState);
                }
            }
        }

        private Set<ITransition> getAcceptTransitions(IState s, ISymbol input) {
            Set<ITransition> ts;
            Map<ISymbol, Set<ITransition>> m = this.transitionsMap.get(s);
            if (m == null) {
                m = new HashMap<ISymbol, Set<ITransition>>();
                this.transitionsMap.put(s, m);
            }
            if ((ts = m.get(input)) == null) {
                ts = this.automaton.getAcceptTransitions(s, input);
                m.put(input, ts);
            }
            return ts;
        }

        public void doAnalysis() {
            while (this.doAnalysisOnce()) {
                if (!this.monitor.isCanceled()) continue;
                throw CancelRuntimeException.make((String)"minimization");
            }
        }

        public void doAnalysis(int markLimit) {
            this.dtable.setSizeLimit(markLimit);
            while (this.doAnalysisOnce()) {
                if (!this.monitor.isCanceled()) continue;
                throw CancelRuntimeException.make((String)"minimization");
            }
        }

        public boolean doAnalysisOnce() {
            IStatePairHandler h = new IStatePairHandler(){

                @Override
                public int handle(IState s1, IState s2, int acc) {
                    for (ISymbol sym : DistAnalysis.this.symbols) {
                        Set ts1 = DistAnalysis.this.getAcceptTransitions(s1, sym);
                        Set ts2 = DistAnalysis.this.getAcceptTransitions(s2, sym);
                        boolean empty1 = ts1.isEmpty();
                        boolean empty2 = ts2.isEmpty();
                        boolean shouldMark = false;
                        if (empty1 && !empty2) {
                            shouldMark = true;
                        } else if (!empty1 && empty2) {
                            shouldMark = true;
                        } else {
                            block1: for (ITransition t1 : ts1) {
                                for (ITransition t2 : ts2) {
                                    if (!DistAnalysis.this.dtable.isDistinguishable(t1.getPostState(), t2.getPostState())) continue;
                                    shouldMark = true;
                                    break block1;
                                }
                            }
                        }
                        if (!shouldMark) continue;
                        if (DistAnalysis.this.dtable.distinguishable(s1, s2)) {
                            ++acc;
                            continue;
                        }
                        return -1;
                    }
                    return acc;
                }
            };
            int modified = this.dtable.iterateIndistinguishablePairs(this.states, h);
            return modified > 0;
        }

        public Map<IState, IState> makeReplaceMap() {
            HashMap<IState, IState> r = new HashMap<IState, IState>();
            final ArrayList l = new ArrayList();
            this.dtable.iterateIndistinguishablePairs(this.states, new IStatePairHandler(){

                @Override
                public int handle(IState s1, IState s2, int acc) {
                    boolean exists = false;
                    for (Set set : l) {
                        if (set.contains(s1)) {
                            set.add(s2);
                            exists = true;
                            break;
                        }
                        if (!set.contains(s2)) continue;
                        set.add(s1);
                        exists = true;
                        break;
                    }
                    if (!exists) {
                        HashSet<IState> set = new HashSet<IState>();
                        set.add(s1);
                        set.add(s2);
                        l.add(set);
                    }
                    return 0;
                }
            });
            for (Set set : l) {
                Iterator i = set.iterator();
                IState s = (IState)i.next();
                while (i.hasNext()) {
                    r.put((IState)i.next(), s);
                }
            }
            return r;
        }
    }

    private static class DistTable {
        private Map<IState, Collection<IState>> map = new DMap<IState, Collection<IState>>(){

            @Override
            protected Collection<IState> create(IState key) {
                return new HashSet<IState>();
            }
        };
        private int size = 0;
        private int sizeLimit = Integer.MAX_VALUE;

        public boolean isDistinguishable(IState s1, IState s2) {
            return this.map.get(s1).contains(s2);
        }

        public boolean distinguishable(IState s1, IState s2) {
            if (this.size + 2 > this.sizeLimit) {
                return false;
            }
            this.map.get(s1).add(s2);
            this.map.get(s2).add(s1);
            this.size += 2;
            return true;
        }

        public int iterateIndistinguishablePairs(List<IState> states, IStatePairHandler handler) {
            int acc = 0;
            for (IState s1 : states) {
                Collection<IState> l = this.map.get(s1);
                if (l.isEmpty()) {
                    for (IState s2 : states) {
                        if (s1 == s2) break;
                        if ((acc = handler.handle(s1, s2, acc)) >= 0) continue;
                        return acc;
                    }
                    continue;
                }
                for (IState s2 : states) {
                    if (s1 == s2) break;
                    if (l.contains(s2) || (acc = handler.handle(s1, s2, acc)) >= 0) continue;
                    return acc;
                }
            }
            return acc;
        }

        public void setSizeLimit(int limit) {
            this.sizeLimit = limit;
        }

        public int getSizeLimit() {
            return this.sizeLimit;
        }

        public void clear() {
            this.map.clear();
        }
    }

    private static interface IStatePairHandler {
        public int handle(IState var1, IState var2, int var3);
    }
}

