/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.shared.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.jasper.JspC;

public class JasperRunner {
    private static String[] processJspArgs(JspC jspc, String jspArgs) {
        String[] jspArgsPrep = jspArgs.split(" ");
        StringBuilder sb = new StringBuilder();
        Boolean endOfList = false;
        for (int i = 0; i < jspArgsPrep.length; ++i) {
            String opt = "";
            String field = "";
            if (i == jspArgsPrep.length - 1) {
                endOfList = true;
            }
            if (jspArgsPrep[i].charAt(0) != '-') continue;
            opt = jspArgsPrep[i];
            StringBuilder sbField = new StringBuilder();
            for (int x = i + 1; x < jspArgsPrep.length && jspArgsPrep[x].charAt(0) != '-'; ++x) {
                if (jspArgsPrep[x - 1].charAt(0) == '-') {
                    sbField.append(jspArgsPrep[x]);
                } else {
                    sbField.append(" " + jspArgsPrep[x]);
                }
                if (x != jspArgsPrep.length - 1) continue;
                endOfList = true;
            }
            field = sbField.toString();
            if (opt.equals("-classpath") || opt.equals("-compile") || opt.equals("-smap") || opt.equals("-dumpsmap") || opt.equals("-v")) continue;
            if (opt.equals("-uriroot")) {
                jspc.setUriroot(field);
                continue;
            }
            if (opt.equals("-d")) continue;
            if (opt.equals("-webxml")) {
                jspc.setWebXml(field);
                continue;
            }
            if (opt.equals("-webxmlencoding")) {
                jspc.setWebXmlEncoding(field);
                continue;
            }
            if (!field.isEmpty()) {
                sb.append(opt);
                sb.append(" ");
                sb.append(field);
                if (endOfList.booleanValue()) continue;
                sb.append(' ');
                continue;
            }
            sb.append(opt);
            if (endOfList.booleanValue()) continue;
            sb.append(' ');
        }
        String[] jspArgsComp = sb.length() == 0 ? new String[]{} : sb.toString().split(" ");
        return jspArgsComp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processInputFile(JspC jspc, String inputFile) throws Exception {
        try (BufferedReader reader = null;){
            String[] processedArgs;
            String jspArgs;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8"));
            jspc.setUriroot(reader.readLine());
            String outDir = reader.readLine();
            jspc.setOutputDir(outDir);
            jspc.setWebXml(new File(outDir).getParentFile() + "/web.xml");
            jspc.setWebXmlEncoding("UTF-8");
            String classpath = reader.readLine();
            if (classpath != null) {
                jspc.setClassPath(classpath);
            }
            if (!(jspArgs = reader.readLine()).equals("NoJSPArgs") && (processedArgs = JasperRunner.processJspArgs(jspc, jspArgs)) != null) {
                jspc.setArgs(processedArgs);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            JspC jspc = new JspC();
            jspc.setCompile(true);
            jspc.setFailOnError(false);
            jspc.setClassDebugInfo(true);
            jspc.setSmapSuppressed(false);
            jspc.setSmapDumped(true);
            jspc.setVerbose(1);
            try {
                JasperRunner.processInputFile(jspc, args[0]);
                jspc.execute();
            }
            catch (Exception e) {
                System.exit(-1);
            }
        }
    }
}

