/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.driver;

import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SALogger;
import com.ibm.wala.stringAnalysis.translator.IBB2Grammar;
import com.ibm.wala.stringAnalysis.translator.IIR2Grammar;
import com.ibm.wala.stringAnalysis.translator.IR2GRCache;
import com.ibm.wala.stringAnalysis.translator.LoaderBasedIR2GRFilter;
import com.ibm.wala.stringAnalysis.translator.PathSensitiveIR2GR;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import java.util.Map;

public class CustomPathSensitiveIR2GR<T>
implements IIR2Grammar<T> {
    private static long PATH_CONDITION_THRESHOLD = Integer.getInteger("com.ibm.wala.stringAnalysis.pathConditionThreshold", 50).intValue();
    private final IIR2Grammar<T> pbase;

    public CustomPathSensitiveIR2GR(final IIR2Grammar<T> base, final Map<CGNode, GR> cache) {
        IR2GRCache cached = new IR2GRCache<T, CGNode>(base){

            protected boolean accept(GR gr) {
                return true;
            }

            protected Map<CGNode, GR> getCache() {
                return cache;
            }

            protected CGNode getKey(TranslationContext ctx) {
                return ctx.getCGNode();
            }
        };
        PathSensitiveIR2GR p = new PathSensitiveIR2GR<T>((IIR2Grammar)cached, true){

            protected boolean accept(TranslationContext ctx) {
                IR ir = ctx.getIR();
                int num = ir.getControlFlowGraph().getNumberOfNodes();
                if ((long)num < PATH_CONDITION_THRESHOLD) {
                    IClassLoader loader = ir.getMethod().getDeclaringClass().getClassLoader();
                    if (base instanceof LoaderBasedIR2GRFilter) {
                        LoaderBasedIR2GRFilter fbase = (LoaderBasedIR2GRFilter)base;
                        if (fbase.accept(ctx.getCGNode(), loader.getReference())) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                SALogger.logger.info((Object)("skip path-condition analysis for " + ir.getMethod().getSignature()));
                return false;
            }
        };
        this.pbase = p;
    }

    public IBB2Grammar<T> getBB2Grammar() {
        return this.pbase.getBB2Grammar();
    }

    public GR translate(TranslationContext ctx) {
        return this.pbase.translate(ctx);
    }
}

