/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import com.ibm.wala.stringAnalysis.sanitizerDetection.util.ApplicationResult;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.ApplicationStatusReport;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SASpec;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SanitizerKind;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.StringAnalysisResult;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.TimingData;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public class CollectSaStatus {
    private static final String ExpectedByCurrent_File = "c:/temp/saExpected.csv";
    private static final boolean OVERHEAD_REPORT = false;

    public static void main(String[] args) throws FileNotFoundException, IOException {
        String resultFolderStr = "C:/Temp/saStatus/";
        CollectSaStatus.createAndWriteReport(resultFolderStr);
        System.out.println("Finished");
    }

    private static void createAndWriteReport(String resultFolderStr) throws IOException, FileNotFoundException {
        StringAnalysisResult trueSet = StringAnalysisResult.getTrueSet();
        StringAnalysisResult expected = StringAnalysisResult.getExpected();
        StringAnalysisResult results = StringAnalysisResult.loadResultsFromFolder(resultFolderStr);
        Map<String, ApplicationStatusReport> applicationToStatus = CollectSaStatus.analyzeResults(trueSet, expected, results);
        CollectSaStatus.writeReport(applicationToStatus, resultFolderStr);
        results.printReport(ExpectedByCurrent_File);
    }

    private static void writeReport(Map<String, ApplicationStatusReport> applicationToStatus, String resultFolder) throws FileNotFoundException {
        PrintWriter statusPw = new PrintWriter(new File(resultFolder, "saStatus.csv"));
        PrintWriter summaryPw = new PrintWriter(new File(resultFolder, "saSummary.csv"));
        String title1 = ",,Is Sanitizer,,,Result,,,Classification,,,Diff,,";
        statusPw.println(title1);
        String title2 = "Application,Method,p1,p2,p3,p1,p2,p3,p1,p2,p3,p1,p2,p3,Test case, Comment";
        statusPw.println(title2);
        summaryPw.println("Application,TP,FP,FN,Score,Time Overhead");
        for (String application : applicationToStatus.keySet()) {
            ApplicationStatusReport applicationStatusReport = applicationToStatus.get(application);
            applicationStatusReport.print(statusPw);
            int tp = applicationStatusReport.getTp();
            int fp = applicationStatusReport.getFp();
            int fn = applicationStatusReport.getFn();
            double score = Math.round(100.0 * ((1.0 + (double)tp) / (1.0 + (double)fp + (double)tp + (double)fn)));
            int saTime = applicationStatusReport.getSaTime();
            int totalTime = applicationStatusReport.getTotalTime();
            String timeOverhead = saTime == -1 ? "N/A" : String.format("%.2f Seconds", ((double)saTime + 0.0) / 1000.0);
            summaryPw.println(application + "," + tp + "," + fp + "," + fn + "," + score + "%," + timeOverhead);
        }
        statusPw.close();
        summaryPw.close();
    }

    private static Map<String, ApplicationStatusReport> analyzeResults(StringAnalysisResult trueSet, StringAnalysisResult expected, StringAnalysisResult results) {
        TreeMap<String, ApplicationStatusReport> res = new TreeMap<String, ApplicationStatusReport>();
        for (String application : results.getApplications()) {
            ApplicationResult applicationTrueSet = trueSet.getResults(application);
            if (applicationTrueSet.isEmpty()) continue;
            ApplicationResult applicationExpected = expected.getResults(application);
            ApplicationResult applicationResult = results.getResults(application);
            TimingData applicationTiming = results.getTimingData(application);
            ApplicationStatusReport applicationStatusReport = CollectSaStatus.analyzeResultForOneApplication(application, applicationTrueSet, applicationExpected, applicationResult, applicationTiming);
            res.put(application, applicationStatusReport);
        }
        return res;
    }

    static ApplicationStatusReport analyzeResultForOneApplication(String application, ApplicationResult applicationTrueSet, ApplicationResult applicationExpected, ApplicationResult applicationResult, TimingData applicationTiming) {
        ApplicationStatusReport applicationStatusReport = new ApplicationStatusReport(application, applicationTrueSet, applicationTiming);
        HashSet allMethods = HashSetFactory.make();
        allMethods.addAll(applicationTrueSet.getMethods());
        allMethods.addAll(applicationExpected.getMethods());
        allMethods.addAll(applicationResult.getMethods());
        for (String method : allMethods) {
            Map<SASpec, SanitizerKind> trueSetResMap = applicationTrueSet.getMethodInfo(method);
            Map<SASpec, SanitizerKind> expectedResMap = applicationExpected.getMethodInfo(method);
            Map<SASpec, SanitizerKind> resultResMap = applicationResult.getMethodInfo(method);
            applicationStatusReport.addResult(method, trueSetResMap, expectedResMap, resultResMap);
        }
        return applicationStatusReport;
    }

    public static enum Classification {
        KnownTp(true, true, "TP", ""),
        KnownFp(false, true, "FP", ""),
        NewTp(true, true, "TP", "V"),
        NewFp(false, true, "FP", "X"),
        NewFn(true, false, "FN", "X"),
        SolvedFp(false, false, "TN", "V"),
        KnownFn(true, false, "FN", ""),
        KnownTn(false, false, "", "");

        final boolean isSanitizer;
        final boolean saResult;
        final String diff;
        final String classification;

        private Classification(boolean isSanitizer, boolean saResult, String classification, String diff) {
            this.isSanitizer = isSanitizer;
            this.saResult = saResult;
            this.classification = classification;
            this.diff = diff;
        }
    }
}

