/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.strings.Atom;
import java.util.Map;

public class CrossLanguageMethodTargetSelector
implements MethodTargetSelector {
    private final Map<Atom, MethodTargetSelector> languageSelectors;

    public CrossLanguageMethodTargetSelector(Map<Atom, MethodTargetSelector> languageSelectors) {
        this.languageSelectors = languageSelectors;
    }

    private static Atom getLanguage(MethodReference target) {
        return target.getDeclaringClass().getClassLoader().getLanguage();
    }

    private static Atom getLanguage(CallSiteReference site) {
        return CrossLanguageMethodTargetSelector.getLanguage(site.getDeclaredTarget());
    }

    private MethodTargetSelector getSelector(CallSiteReference site) {
        return this.languageSelectors.get(CrossLanguageMethodTargetSelector.getLanguage(site));
    }

    public IMethod getCalleeTarget(CGNode caller, CallSiteReference site, IClass receiver) {
        assert (this.getSelector(site) != null) : "no selector for " + CrossLanguageMethodTargetSelector.getLanguage(site) + " method " + site;
        return this.getSelector(site).getCalleeTarget(caller, site, receiver);
    }
}

