/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa.analysis;

import com.ibm.wala.cast.ir.cfg.Util;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.impl.GraphInverter;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.util.Iterator;

public class LiveAnalysis {
    public static Result perform(IR ir) {
        return LiveAnalysis.perform((ControlFlowGraph<SSAInstruction, ISSABasicBlock>)ir.getControlFlowGraph(), ir.getSymbolTable());
    }

    public static Result perform(ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, SymbolTable symtab) {
        return LiveAnalysis.perform(cfg, symtab, new BitVector());
    }

    public static Result perform(final ControlFlowGraph<SSAInstruction, ISSABasicBlock> cfg, final SymbolTable symtab, final BitVector considerLiveAtExit) {
        final BitVectorIntSet liveAtExit = new BitVectorIntSet(considerLiveAtExit);
        final SSAInstruction[] instructions = (SSAInstruction[])cfg.getInstructions();
        final BitVectorSolver S = new BitVectorSolver((IKilldallFramework)new IKilldallFramework<ISSABasicBlock, BitVectorVariable>(){
            private final Graph<ISSABasicBlock> G;
            {
                this.G = GraphInverter.invert((NumberedGraph)cfg);
            }

            public Graph<ISSABasicBlock> getFlowGraph() {
                return this.G;
            }

            public ITransferFunctionProvider<ISSABasicBlock, BitVectorVariable> getTransferFunctionProvider() {
                return new ITransferFunctionProvider<ISSABasicBlock, BitVectorVariable>(){

                    public boolean hasNodeTransferFunctions() {
                        return true;
                    }

                    public boolean hasEdgeTransferFunctions() {
                        return false;
                    }

                    public UnaryOperator<BitVectorVariable> getNodeTransferFunction(ISSABasicBlock node) {
                        if (node.isExitBlock()) {
                            final class ExitBlockGenKillOperator
                            extends UnaryOperator<BitVectorVariable> {
                                final /* synthetic */ BitVector val$considerLiveAtExit;
                                final /* synthetic */ BitVectorIntSet val$liveAtExit;

                                ExitBlockGenKillOperator() {
                                    this.val$considerLiveAtExit = bitVector;
                                    this.val$liveAtExit = bitVectorIntSet;
                                }

                                public String toString() {
                                    return "ExitGenKill";
                                }

                                public boolean equals(Object o) {
                                    return o == this;
                                }

                                public int hashCode() {
                                    return 37721;
                                }

                                public byte evaluate(BitVectorVariable lhs, BitVectorVariable rhs) {
                                    boolean changed = lhs.getValue() == null ? !this.val$considerLiveAtExit.isZero() : !lhs.getValue().sameValue((IntSet)this.val$liveAtExit);
                                    lhs.addAll(this.val$considerLiveAtExit);
                                    return changed ? (byte)1 : 0;
                                }
                            }
                            return new ExitBlockGenKillOperator(considerLiveAtExit, liveAtExit);
                        }
                        final class BlockValueGenKillOperator
                        extends UnaryOperator<BitVectorVariable> {
                            private final ISSABasicBlock block;
                            final /* synthetic */ SymbolTable val$symtab;
                            final /* synthetic */ ControlFlowGraph val$cfg;
                            final /* synthetic */ SSAInstruction[] val$instructions;

                            BlockValueGenKillOperator(ISSABasicBlock block) {
                                this.val$symtab = symbolTable;
                                this.val$cfg = controlFlowGraph;
                                this.val$instructions = sSAInstructionArray;
                                this.block = block;
                            }

                            public String toString() {
                                return "GenKill:" + this.block;
                            }

                            public boolean equals(Object o) {
                                return o instanceof BlockValueGenKillOperator && ((BlockValueGenKillOperator)((Object)o)).block.equals(this.block);
                            }

                            public int hashCode() {
                                return this.block.hashCode() * 17;
                            }

                            private void processDefs(SSAInstruction inst, BitVector bits) {
                                for (int j = 0; j < inst.getNumberOfDefs(); ++j) {
                                    bits.clear(inst.getDef(j));
                                }
                            }

                            private void processUses(SSAInstruction inst, BitVector bits) {
                                for (int j = 0; j < inst.getNumberOfUses(); ++j) {
                                    assert (inst.getUse(j) != -1) : inst.toString();
                                    if (this.val$symtab.isConstant(inst.getUse(j))) continue;
                                    bits.set(inst.getUse(j));
                                }
                            }

                            public byte evaluate(BitVectorVariable lhs, BitVectorVariable rhs) {
                                BitVectorIntSet bits = new BitVectorIntSet();
                                IntSet s = rhs.getValue();
                                if (s != null) {
                                    bits.addAll(s);
                                }
                                Iterator succBBs = this.val$cfg.getSuccNodes((Object)this.block);
                                while (succBBs.hasNext()) {
                                    ISSABasicBlock succBB = (ISSABasicBlock)succBBs.next();
                                    int rval = Util.whichPred(this.val$cfg, succBB, this.block);
                                    Iterator sphis = succBB.iteratePhis();
                                    while (sphis.hasNext()) {
                                        bits.add(((SSAPhiInstruction)sphis.next()).getUse(rval));
                                    }
                                }
                                for (int i = this.block.getLastInstructionIndex(); i >= this.block.getFirstInstructionIndex(); --i) {
                                    SSAInstruction inst = this.val$instructions[i];
                                    if (inst == null) continue;
                                    this.processDefs(inst, bits.getBitVector());
                                    this.processUses(inst, bits.getBitVector());
                                }
                                Iterator SS = this.block.iteratePhis();
                                while (SS.hasNext()) {
                                    this.processDefs((SSAInstruction)SS.next(), bits.getBitVector());
                                }
                                BitVectorVariable U = new BitVectorVariable();
                                U.addAll(bits.getBitVector());
                                if (!lhs.sameValue(U)) {
                                    lhs.copyState(U);
                                    return 1;
                                }
                                return 0;
                            }
                        }
                        return new BlockValueGenKillOperator(node, symtab, cfg, instructions);
                    }

                    public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(ISSABasicBlock s, ISSABasicBlock d) {
                        Assertions.UNREACHABLE();
                        return null;
                    }

                    public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
                        return BitVectorUnion.instance();
                    }
                };
            }
        });
        try {
            S.solve(null);
        }
        catch (CancelException e) {
            throw new CancelRuntimeException((Exception)((Object)e));
        }
        return new Result(){

            public String toString() {
                StringBuffer s = new StringBuffer();
                for (int i = 0; i < cfg.getNumberOfNodes(); ++i) {
                    ISSABasicBlock bb = (ISSABasicBlock)cfg.getNode(i);
                    s.append("live entering ").append(bb).append(":").append(S.getOut((Object)bb)).append("\n");
                    s.append("live exiting ").append(bb).append(":").append(S.getIn((Object)bb)).append("\n");
                }
                return s.toString();
            }

            @Override
            public boolean isLiveEntry(ISSABasicBlock bb, int valueNumber) {
                return ((BitVectorVariable)S.getOut((Object)bb)).get(valueNumber);
            }

            @Override
            public boolean isLiveExit(ISSABasicBlock bb, int valueNumber) {
                return ((BitVectorVariable)S.getIn((Object)bb)).get(valueNumber);
            }

            @Override
            public BitVector getLiveBefore(int instr) {
                ISSABasicBlock bb = (ISSABasicBlock)cfg.getBlockForInstruction(instr);
                BitVectorIntSet bits = new BitVectorIntSet();
                IntSet s = ((BitVectorVariable)S.getIn((Object)bb)).getValue();
                if (s != null) {
                    bits.addAll(s);
                }
                for (int i = bb.getLastInstructionIndex(); i >= instr; --i) {
                    int j;
                    SSAInstruction inst = instructions[i];
                    if (inst == null) continue;
                    for (j = 0; j < inst.getNumberOfDefs(); ++j) {
                        bits.remove(inst.getDef(j));
                    }
                    for (j = 0; j < inst.getNumberOfUses(); ++j) {
                        if (symtab.isConstant(inst.getUse(j))) continue;
                        bits.add(inst.getUse(j));
                    }
                }
                return bits.getBitVector();
            }
        };
    }

    public static interface Result {
        public boolean isLiveEntry(ISSABasicBlock var1, int var2);

        public boolean isLiveExit(ISSABasicBlock var1, int var2);

        public BitVector getLiveBefore(int var1);
    }
}

