/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.scm.git;

import com.hcl.appscan.common.scm.IScmProvider;
import com.ibm.appscan.common.utils.PathUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Properties;

public class GitProvider
implements IScmProvider {
    private static String STAGING_PREFIX = "staging" + File.separator + "src" + File.separator;
    private File m_rootDirectory;
    private String m_baseUrl;
    private String m_commitId;
    private String m_branchName;

    public GitProvider(Properties properties) {
        String rootDirectory = properties.getProperty("rootDirectory", "");
        this.m_rootDirectory = new File(rootDirectory);
        this.m_baseUrl = properties.getProperty("baseUrl", "");
        this.m_branchName = properties.getProperty("branch", "");
        this.m_commitId = properties.getProperty("commitId", "");
    }

    public GitProvider(File rootDirectory, String baseUrl, String commitId, String branchName) {
        this.m_rootDirectory = rootDirectory;
        this.m_baseUrl = baseUrl;
        if (!this.m_baseUrl.endsWith("/")) {
            this.m_baseUrl = this.m_baseUrl + "/";
        }
        this.m_commitId = commitId;
        this.m_branchName = branchName;
    }

    public String getUrlForFile(String path) {
        return this.getUrlForFile(path, 0);
    }

    public String getUrlForFile(String path, int line) {
        String url = this.m_baseUrl + "blob/" + this.m_commitId + "/" + path;
        if (line > 0) {
            url = url + "#L" + line;
        }
        return url;
    }

    public String getUrlForFile(File file) {
        return this.getUrlForFile(file, 0);
    }

    public String getUrlForFile(File file, int line) {
        String path = this.m_rootDirectory.toPath().relativize(file.toPath()).toString();
        return this.getUrlForFile(path, line);
    }

    public String getCommitBaseUrl() {
        return this.m_baseUrl + "blob/" + this.m_commitId;
    }

    public String getRepositoryUrl() {
        return this.m_baseUrl;
    }

    public String getCommitId() {
        return this.m_commitId;
    }

    public String getBranchName() {
        return this.m_branchName;
    }

    public String getName() {
        return "git";
    }

    public String getRepositoryRelativePath(String path) {
        if (new File(this.m_rootDirectory, path).isFile()) {
            return path;
        }
        if (new File(path).isAbsolute()) {
            path = this.makeRelative(path);
        } else if (new File(this.m_rootDirectory.getParentFile(), path).isFile() && this.m_rootDirectory.getName().equalsIgnoreCase(Paths.get(path, new String[0]).getName(0).toString())) {
            if ((path = PathUtil.replaceBackslashes((String)path)).contains("/")) {
                path = path.substring(path.indexOf("/") + 1);
            }
        } else {
            File theFile = this.findFileByName(path);
            if (theFile != null) {
                path = this.makeRelative(theFile.getPath());
            }
        }
        return path;
    }

    private String makeRelative(String path) {
        try {
            Path repoPath = this.m_rootDirectory.toPath();
            Path filePath = Paths.get(path, new String[0]);
            String relative = repoPath.relativize(filePath).toString();
            path = relative.contains("..") ? path : relative;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return path;
    }

    private File findFileByName(String path) {
        if (path.startsWith(STAGING_PREFIX)) {
            path = path.substring(12);
        }
        final File fileToFind = new File(path);
        final String name = fileToFind.getName();
        try {
            final ArrayList theFiles = new ArrayList();
            Files.walkFileTree(this.m_rootDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (file.getFileName().toString().equals(name) && file.endsWith(fileToFind.getPath()) && !file.toFile().getAbsolutePath().contains(File.separator + STAGING_PREFIX)) {
                        theFiles.add(file.toFile());
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            return theFiles.isEmpty() ? null : (File)theFiles.get(0);
        }
        catch (IOException e) {
            return fileToFind;
        }
    }
}

