/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.dir;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.discovery.Messages;
import com.ibm.appscan.discovery.dir.ICollector;
import com.ibm.appscan.file.extension.ExtensionHelper;
import com.ibm.appscan.file.extension.FileExtensionException;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class BaseCollector
implements ICollector {
    private Set<IScanFile> m_collectedFiles = new LinkedHashSet<IScanFile>();
    private Set<StringPattern> m_includes;
    private Set<StringPattern> m_excludes;

    protected BaseCollector(Set<StringPattern> includes, Set<StringPattern> excludes) {
        this.m_includes = includes;
        this.m_excludes = excludes;
    }

    protected BaseCollector() {
        this.m_includes = new HashSet<StringPattern>();
        this.m_excludes = new HashSet<StringPattern>();
    }

    @Override
    public Set<IScanFile> getScanFiles() {
        return this.getCollectedFiles();
    }

    @Override
    public void process(File file, String path, IProgress progress) {
        if (this.acceptFile(file)) {
            IScanFile scanFile = ScanModelFactory.newScanFile((File)file);
            scanFile.setSourcePath(file.getAbsolutePath());
            scanFile.setExcluded(this.isFileUserExcluded(file));
            this.m_collectedFiles.add(scanFile);
        }
    }

    @Override
    public void validateScanFiles(IScanTargetMinProxy proxy, IProgress progress, Set<IScanFile> files) {
    }

    protected Set<IScanFile> getCollectedFiles() {
        return this.m_collectedFiles;
    }

    protected Set<StringPattern> getIncludes() {
        return this.m_includes;
    }

    protected Set<StringPattern> getExcludes() {
        return this.m_excludes;
    }

    protected boolean isFileUserExcluded(File file) {
        String path = file.getPath();
        if (!this.m_includes.isEmpty() && !this.matchFound(path, this.m_includes)) {
            return true;
        }
        return this.matchFound(path, this.m_excludes);
    }

    protected boolean acceptFile(File file) {
        String extension = FileUtil.getFileExtension((File)file).toLowerCase();
        return this.getFileExtensions().contains(extension);
    }

    protected abstract String getFileExtensionSetName();

    protected Set<String> getFileExtensions() {
        HashSet<String> fileExtensions = new HashSet<String>();
        String fileExtensionSetName = this.getFileExtensionSetName();
        try {
            fileExtensions.addAll(ExtensionHelper.getFileExtensions((String)fileExtensionSetName));
        }
        catch (FileExtensionException e) {
            CommonCore.getLogManager().log(new Message(Messages.getMessage("err.read.file.extensions", fileExtensionSetName), (Throwable)e));
        }
        return fileExtensions;
    }

    private boolean matchFound(String path, Set<StringPattern> set) {
        for (StringPattern pattern : set) {
            if (!pattern.matches(path)) continue;
            return true;
        }
        return false;
    }
}

