/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee;

import com.ibm.appscan.frameworks.analyzers.generic.CodeProcessor;
import com.ibm.appscan.frameworks.analyzers.javaee.BeanId;
import com.ibm.appscan.frameworks.analyzers.javaee.BeanScope;
import com.ibm.appscan.frameworks.analyzers.javaee.BeanScopeResolver;
import com.ibm.appscan.frameworks.analyzers.javaee.BeanSeed;
import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.javaee.SetGetAttributeUsageExtractor;
import com.ibm.appscan.frameworks.specinfo.ArgToOrigCallExpr;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BeanUsageAnalysis {
    public void analyzeAndPrintInfo(IClassHierarchy cha, AnalysisCache cache, Properties options) throws ClassHierarchyException, InvalidClassFileException {
        BeanScopeResolver beanScopeResolver = this.getResolvedBeanSeeds(cha, cache, options);
        this.printBeanSeedInfo(beanScopeResolver);
    }

    public Pair<Set<BeanDecl>, Map<String, Set<CallSiteReplacement>>> getBeanSpecInfo(IClassHierarchy cha, AnalysisCache cache, Properties options) {
        BeanScopeResolver beanScopeResolver = this.getResolvedBeanSeeds(cha, cache, options);
        Set<BeanSeed> resolvedSeeds = beanScopeResolver.getBeanSeeds();
        HashMap<BeanId, TypeReference> globalMap = beanScopeResolver.getGlobalMap();
        Set<BeanDecl> globalBeanDecls = this.createGlobalBeanDecls(globalMap);
        Map<String, Set<CallSiteReplacement>> callSiteReplacements = this.createCallSiteReplacements(resolvedSeeds);
        return Pair.make(globalBeanDecls, callSiteReplacements);
    }

    private Map<String, Set<CallSiteReplacement>> createCallSiteReplacements(Set<BeanSeed> resolvedSeeds) {
        HashMap callSiteReplacements = HashMapFactory.make();
        for (BeanSeed seed : resolvedSeeds) {
            ObjectRefExpr rhs;
            ArgToOrigCallExpr lhs;
            IMethod enclosingMethod = seed.callerMethod;
            ObjectRefExpr beanRef = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)this.getBeanName(seed.scope, seed.name)), (String)(seed.ap == null ? "" : seed.ap));
            ArgToOrigCallExpr origCallExpr = ArgToOrigCallExpr.make((int)seed.param);
            if (seed.param == -1) {
                lhs = origCallExpr;
                rhs = beanRef;
            } else {
                lhs = beanRef;
                rhs = origCallExpr;
            }
            IClassHierarchy cha = enclosingMethod.getClassHierarchy();
            CallSiteReference callSite = seed.callSite;
            IMethod invokedMethod = cha.resolveMethod(callSite.getDeclaredTarget());
            assert (invokedMethod != null);
            CallSiteReplacement replacement = CallSiteReplacement.make((String)WalaUtil.method2ResolvedVDBSignature(invokedMethod), (int)callSite.getProgramCounter(), (int)seed.srcLine, (SyntheticExpr)AssignmentExpr.make(null, (AssignableSyntheticExpr)lhs, (NonVoidSyntheticExpr)rhs));
            MapUtil.findOrCreateSet((Map)callSiteReplacements, (Object)WalaUtil.method2ResolvedVDBSignature(enclosingMethod)).add(replacement);
        }
        return callSiteReplacements;
    }

    private Set<BeanDecl> createGlobalBeanDecls(HashMap<BeanId, TypeReference> globalMap) {
        HashSet globalBeanDecls = HashSetFactory.make();
        for (BeanId id : globalMap.keySet()) {
            BeanScope scope = id.getScope();
            String name = id.getName();
            String beanName = this.getBeanName(scope, name);
            TypeReference type = globalMap.get(id);
            BeanDecl.BeanLifespan lifespan = this.getLifespanForBeanScope(scope);
            String typeName = type == null ? null : VDBJavaUtil.jvmToVDBType(type.getName().toString());
            BeanDecl beanDecl = BeanDecl.makeWithConcreteType((String)beanName, (String)typeName, (BeanDecl.BeanLifespan)lifespan);
            globalBeanDecls.add(beanDecl);
        }
        return globalBeanDecls;
    }

    private String getBeanName(BeanScope scope, String name) {
        String beanName = scope.toString() + "." + name;
        return beanName;
    }

    private BeanDecl.BeanLifespan getLifespanForBeanScope(BeanScope scope) {
        BeanDecl.BeanLifespan lifespan = null;
        switch (scope) {
            case Application: 
            case Session: {
                lifespan = BeanDecl.BeanLifespan.GLOBAL;
                break;
            }
            case Request: 
            case Page: {
                lifespan = BeanDecl.BeanLifespan.ENTRYPOINT;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return lifespan;
    }

    private void printBeanSeedInfo(BeanScopeResolver beanScopeResolver) {
        Set<BeanSeed> resolvedSeeds = beanScopeResolver.getBeanSeeds();
        HashMap<BeanId, TypeReference> globalMap = beanScopeResolver.getGlobalMap();
        System.out.println("Resolved seeds");
        for (BeanSeed seed : resolvedSeeds) {
            System.out.println(seed.toString());
        }
        System.out.println("Global Bean Map");
        for (BeanId id : globalMap.keySet()) {
            System.out.println(id.toString());
            System.out.println("\t" + globalMap.get(id));
        }
    }

    private BeanScopeResolver getResolvedBeanSeeds(IClassHierarchy cha, AnalysisCache cache, Properties options) {
        String replaceAttrCallsProp = options.getProperty(JavaEEOptions.REPLACE_SET_GET_ATTRIBUTE_CALLS.getName());
        if ("true".equals(replaceAttrCallsProp)) {
            CodeProcessor callProcessor = new CodeProcessor(cha, cache);
            SetGetAttributeUsageExtractor setGetAttributeUsageExtractor = new SetGetAttributeUsageExtractor(cha, callProcessor);
            callProcessor.process();
            HashSet seeds = HashSetFactory.make();
            seeds.addAll(setGetAttributeUsageExtractor.getBeanSeeds());
            BeanScopeResolver beanScopeResolver = new BeanScopeResolver(seeds);
            return beanScopeResolver;
        }
        return new BeanScopeResolver(Collections.emptySet());
    }
}

