/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.jsp;

import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.ITagLibDefInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.TagLibraryDefs;
import com.ibm.appscan.frameworks.util.JavaUtils;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cfg.ExplodedInterproceduralCFG;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.Selector;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class JasperInfo
implements IJSPPrecompilerInfo {
    private final String packageName;
    private int jspPrecomilerVersion = 70;
    private static final Selector JSP_SERVICE_SELECTOR = Selector.make((String)"_jspService(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V");
    private static final Pair<String, Integer> JSP_RUNTIME_INCLUDE_SIG = Pair.make((Object)"org.apache.jasper.runtime.JspRuntimeLibrary.include(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;Ljava/lang/String;Ljavax/servlet/jsp/JspWriter;Z)V", (Object)2);
    private static final Pair<String, Integer> JSP_EL_EVALUATE_SIG = Pair.make((Object)"org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate(Ljava/lang/String;Ljava/lang/Class;Ljavax/servlet/jsp/PageContext;Lorg/apache/jasper/runtime/ProtectedFunctionMapper;Z)Ljava/lang/Object;", (Object)0);
    private static final Pair<String, Integer> JSP_EL_EVALUATE_SIG_80 = Pair.make((Object)"org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate(Ljava/lang/String;Ljava/lang/Class;Ljavax/servlet/jsp/PageContext;Lorg/apache/jasper/runtime/ProtectedFunctionMapper;)Ljava/lang/Object;", (Object)0);

    public static JasperInfo make(Properties options) {
        return new JasperInfo(options);
    }

    public static JasperInfo makeDefault() {
        Properties p = new Properties();
        p.setProperty(JavaEEOptions.JSP_PACKAGE_NAME.getName(), "org.apache.jsp");
        return new JasperInfo(p);
    }

    private JasperInfo(Properties options) {
        String packageNameOpt = options.getProperty(JavaEEOptions.JSP_PACKAGE_NAME.getName());
        if (packageNameOpt == null) {
            throw new IllegalArgumentException(JavaEEOptions.JSP_PACKAGE_NAME.getName() + " option must be set");
        }
        String jspPrecompilerVersionProperty = options.getProperty("javaee.core.jsp.precompiler.version");
        if (jspPrecompilerVersionProperty != null && jspPrecompilerVersionProperty.trim().length() > 0) {
            try {
                this.jspPrecomilerVersion = Integer.valueOf(jspPrecompilerVersionProperty);
            }
            catch (NumberFormatException e) {
                this.jspPrecomilerVersion = Integer.valueOf("70");
            }
        }
        this.packageName = packageNameOpt;
    }

    private static String getJavaClassForJSPFile(String forwardPath) {
        int jspNameStartIndex = forwardPath.lastIndexOf(47) + 1;
        String className = JasperInfo.makeJavaIdentifier(forwardPath.substring(jspNameStartIndex));
        String packageName = "";
        if (jspNameStartIndex > 1) {
            packageName = JasperInfo.makeJavaPackage(forwardPath.substring(1, jspNameStartIndex - 1)) + ".";
        }
        return packageName + className;
    }

    @Override
    public Set<Selector> getEntrypointSelectors() {
        return Collections.singleton(JSP_SERVICE_SELECTOR);
    }

    @Override
    public String getPrecompiledClassNameForJSP(String jspPath) {
        return this.packageName + "." + JasperInfo.getJavaClassForJSPFile(jspPath);
    }

    @Override
    public Pair<String, Integer> getRuntimeIncludeMethodSig() {
        return JSP_RUNTIME_INCLUDE_SIG;
    }

    @Override
    public Pair<String, Integer> getELEvaluateMethodSig() {
        if (this.jspPrecomilerVersion >= 80) {
            return JSP_EL_EVALUATE_SIG_80;
        }
        return JSP_EL_EVALUATE_SIG;
    }

    private static final String makeJavaIdentifier(String identifier) {
        StringBuffer modifiedIdentifier = new StringBuffer(identifier.length());
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            modifiedIdentifier.append('_');
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch) && ch != '_') {
                modifiedIdentifier.append(ch);
                continue;
            }
            if (ch == '.') {
                modifiedIdentifier.append('_');
                continue;
            }
            modifiedIdentifier.append(JasperInfo.mangleChar(ch));
        }
        if (JavaUtils.isJavaKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    private static final String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.forDigit(ch >> 12 & 0xF, 16), Character.forDigit(ch >> 8 & 0xF, 16), Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
        return new String(result);
    }

    private static final String makeJavaPackage(String path) {
        String[] classNameComponents = path.split("/");
        StringBuffer legalClassNames = new StringBuffer();
        for (int i = 0; i < classNameComponents.length; ++i) {
            legalClassNames.append(JasperInfo.makeJavaIdentifier(classNameComponents[i]));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    @Override
    public boolean tagLibAnalysisSupported() {
        return true;
    }

    @Override
    public ITagLibDefInfo getTagLibDefInfo(ExplodedInterproceduralCFG icfg) {
        final TagLibraryDefs defs = TagLibraryDefs.make(icfg);
        defs.analyze();
        return new ITagLibDefInfo(){

            @Override
            public Set<ITagLibDefInfo.ReachingDef> getNamesReachingBlock(BasicBlockInContext<IExplodedBasicBlock> block) {
                HashSet result = HashSetFactory.make();
                IntSet reachingFactNums = ((BitVectorVariable)defs.getSolver().getIn(block)).getValue();
                if (reachingFactNums != null) {
                    IntIterator intIter = reachingFactNums.intIterator();
                    while (intIter.hasNext()) {
                        int nextFact = intIter.next();
                        result.add(defs.getDefForNumber(nextFact));
                    }
                }
                return result;
            }
        };
    }
}

