/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.taglibs;

import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.CForEachInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.ITagLibDefInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.SpringBindInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.TagLibraryInfo;
import com.ibm.wala.dataflow.graph.AbstractMeetOperator;
import com.ibm.wala.dataflow.graph.BitVectorFramework;
import com.ibm.wala.dataflow.graph.BitVectorIdentity;
import com.ibm.wala.dataflow.graph.BitVectorKillAll;
import com.ibm.wala.dataflow.graph.BitVectorKillGen;
import com.ibm.wala.dataflow.graph.BitVectorSolver;
import com.ibm.wala.dataflow.graph.BitVectorUnion;
import com.ibm.wala.dataflow.graph.IKilldallFramework;
import com.ibm.wala.dataflow.graph.ITransferFunctionProvider;
import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.ipa.cfg.ExplodedInterproceduralCFG;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.ObjectArrayMapping;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class TagLibraryDefs {
    private final ExplodedInterproceduralCFG icfg;
    private final OrdinalSetMapping<ITagLibDefInfo.ReachingDef> factNumbering;
    private final Collection<TagLibraryInfo> allTagLibInfo = HashSetFactory.make();
    private final Map<String, BitVector> name2PossibleFacts = HashMapFactory.make();
    private BitVectorSolver<BasicBlockInContext<IExplodedBasicBlock>> solver;

    public static TagLibraryDefs make(ExplodedInterproceduralCFG icfg) {
        return new TagLibraryDefs(icfg);
    }

    private TagLibraryDefs(ExplodedInterproceduralCFG icfg) {
        this.initializeTagLibInfo();
        this.icfg = icfg;
        this.factNumbering = this.getAllFactNumbers();
    }

    private void initializeTagLibInfo() {
        this.allTagLibInfo.add(new SpringBindInfo());
        this.allTagLibInfo.add(new CForEachInfo());
    }

    private OrdinalSetMapping<ITagLibDefInfo.ReachingDef> getAllFactNumbers() {
        ArrayList<ITagLibDefInfo.ReachingDef> facts = new ArrayList<ITagLibDefInfo.ReachingDef>();
        for (CGNode node : this.icfg.getCallGraph()) {
            IR ir = node.getIR();
            if (ir == null) continue;
            SSAInstruction[] instructions = ir.getInstructions();
            block1: for (int i = 0; i < instructions.length; ++i) {
                SSAInstruction instruction = instructions[i];
                if (!(instruction instanceof SSAAbstractInvokeInstruction)) continue;
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                MethodReference declaredTarget = invoke.getDeclaredTarget();
                for (TagLibraryInfo tagLibInfo : this.allTagLibInfo) {
                    ITagLibDefInfo.ReachingDef fact;
                    if (!tagLibInfo.understands(declaredTarget) || (fact = tagLibInfo.getFact(invoke, node, i)) == null) continue;
                    int factNum = facts.size();
                    facts.add(fact);
                    BitVector bv = this.name2PossibleFacts.get(fact.getName());
                    if (bv == null) {
                        bv = new BitVector();
                        this.name2PossibleFacts.put(fact.getName(), bv);
                    }
                    bv.set(factNum);
                    continue block1;
                }
            }
        }
        return new ObjectArrayMapping((Object[])facts.toArray(new ITagLibDefInfo.ReachingDef[facts.size()]));
    }

    public void analyze() {
        block2: {
            BitVectorFramework framework = new BitVectorFramework((Graph)this.icfg, (ITransferFunctionProvider)new TransferFunctions(), this.factNumbering);
            this.solver = new BitVectorSolver((IKilldallFramework)framework);
            try {
                this.solver.solve(null);
            }
            catch (CancelException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public BitVectorSolver<BasicBlockInContext<IExplodedBasicBlock>> getSolver() {
        return this.solver;
    }

    public ITagLibDefInfo.ReachingDef getDefForNumber(int x) {
        return (ITagLibDefInfo.ReachingDef)this.factNumbering.getMappedObject(x);
    }

    private class TransferFunctions
    implements ITransferFunctionProvider<BasicBlockInContext<IExplodedBasicBlock>, BitVectorVariable> {
        private TransferFunctions() {
        }

        public UnaryOperator<BitVectorVariable> getNodeTransferFunction(BasicBlockInContext<IExplodedBasicBlock> node) {
            IExplodedBasicBlock ebb = (IExplodedBasicBlock)node.getDelegate();
            SSAInstruction instruction = ebb.getInstruction();
            if (instruction instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invokeInstruction = (SSAAbstractInvokeInstruction)instruction;
                MethodReference declaredTarget = invokeInstruction.getDeclaredTarget();
                for (TagLibraryInfo tagLibInfo : TagLibraryDefs.this.allTagLibInfo) {
                    if (!tagLibInfo.understands(declaredTarget)) continue;
                    int instructionIndex = ebb.getFirstInstructionIndex();
                    CGNode cgNode = node.getNode();
                    ITagLibDefInfo.ReachingDef fact = tagLibInfo.getFact(invokeInstruction, cgNode, instructionIndex);
                    if (fact == null) continue;
                    BitVector kill = (BitVector)TagLibraryDefs.this.name2PossibleFacts.get(fact.getName());
                    BitVector gen = new BitVector();
                    gen.set(TagLibraryDefs.this.factNumbering.getMappedIndex((Object)fact));
                    return new BitVectorKillGen(kill, gen);
                }
            }
            return BitVectorIdentity.instance();
        }

        public boolean hasNodeTransferFunctions() {
            return true;
        }

        public UnaryOperator<BitVectorVariable> getEdgeTransferFunction(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dst) {
            if (this.isCallToReturnEdge(src, dst) && this.someCallee(src)) {
                return BitVectorKillAll.instance();
            }
            return BitVectorIdentity.instance();
        }

        private boolean someCallee(BasicBlockInContext<IExplodedBasicBlock> src) {
            SSAInstruction srcInst = ((IExplodedBasicBlock)src.getDelegate()).getInstruction();
            if (srcInst instanceof SSAAbstractInvokeInstruction) {
                for (BasicBlockInContext succ : Iterator2Iterable.make((Iterator)TagLibraryDefs.this.icfg.getSuccNodes(src))) {
                    if (src.getNode().equals(succ.getNode())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isCallToReturnEdge(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dst) {
            SSAInstruction srcInst = ((IExplodedBasicBlock)src.getDelegate()).getInstruction();
            return srcInst instanceof SSAAbstractInvokeInstruction && src.getNode().equals(dst.getNode());
        }

        public boolean hasEdgeTransferFunctions() {
            return true;
        }

        public AbstractMeetOperator<BitVectorVariable> getMeetOperator() {
            return BitVectorUnion.instance();
        }
    }
}

