/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SpringURLInfo {
    private final Map<String, Set<String>> beanId2URLs;
    private final Map<String, Map<String, Set<String>>> beanId2Method2URLs;

    public static SpringURLInfo makeEmpty() {
        Map<String, Set<String>> tmp1 = Collections.emptyMap();
        Map<String, Map<String, Set<String>>> tmp2 = Collections.emptyMap();
        return new SpringURLInfo(tmp1, tmp2);
    }

    public static SpringURLInfo make(Map<String, Set<String>> beanId2URLs, Map<String, Map<String, Set<String>>> beanId2Method2URLs) {
        return new SpringURLInfo(beanId2URLs, beanId2Method2URLs);
    }

    private SpringURLInfo(Map<String, Set<String>> beanId2URLs, Map<String, Map<String, Set<String>>> beanId2Method2URLs) {
        this.beanId2URLs = beanId2URLs;
        this.beanId2Method2URLs = beanId2Method2URLs;
    }

    public Set<String> getURLs(String beanId, String entrypointMethodName) {
        Set<String> result;
        Map<String, Set<String>> method2URLs = this.beanId2Method2URLs.get(beanId);
        if (method2URLs != null && (result = method2URLs.get(entrypointMethodName)) != null) {
            return result;
        }
        result = this.beanId2URLs.get(beanId);
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }
}

