/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.analyzers.generic.CodeProcessor;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.analyzers.struts1.AbstractStrutsCodeVisitor;
import com.ibm.appscan.frameworks.analyzers.struts1.AnalyzedBean;
import com.ibm.appscan.frameworks.specinfo.ArgToOrigCallExpr;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.Property;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StrutsDynaBeanAnalyzer
extends AbstractStrutsCodeVisitor {
    private static final Logger logger = TaintLogger.i().getLogger();
    private static final TypeReference DYNA_ACTION_FORM_REF = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)"org.apache.struts.action.DynaActionForm"));
    private final Map<MethodReference, Pair<Integer, Integer>> beanPropAccessMethod2PropNamePos = HashMapFactory.make();
    private final Map<String, Set<CallSiteReplacement>> replacementsForBeanAccesses = HashMapFactory.make();
    private final Map<String, String> actionClass2GlobalBeanName;
    private final Map<String, AnalyzedBean> actionClass2AnalyzedBean;

    public static StrutsDynaBeanAnalyzer make(IClassHierarchy cha, Set<String> actionClassesWithDynaBeans, Map<String, String> actionClass2GlobalBeanName, Map<String, AnalyzedBean> actionClass2AnalyzedBean) {
        return new StrutsDynaBeanAnalyzer(cha, actionClassesWithDynaBeans, actionClass2GlobalBeanName, actionClass2AnalyzedBean);
    }

    private StrutsDynaBeanAnalyzer(IClassHierarchy cha, Set<String> actionClassesWithDynaBeans, Map<String, String> actionClass2GlobalBeanName, Map<String, AnalyzedBean> actionClass2AnalyzedBean) {
        super(cha, actionClassesWithDynaBeans, Collections.emptySet());
        this.actionClass2GlobalBeanName = actionClass2GlobalBeanName;
        this.actionClass2AnalyzedBean = actionClass2AnalyzedBean;
        this.populateBeanPropMethodMap();
    }

    private void populateBeanPropMethodMap() {
        this.addBeanPropMethodIfResolvable("org.apache.commons.beanutils.BeanUtils", "getSimpleProperty(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/String;", (Pair<Integer, Integer>)Pair.make((Object)0, (Object)1));
        this.addBeanPropMethodIfResolvable("org.apache.struts.action.DynaActionForm", "get(Ljava/lang/String;)Ljava/lang/Object;", (Pair<Integer, Integer>)Pair.make((Object)0, (Object)1));
    }

    private void addBeanPropMethodIfResolvable(String className, String selector, Pair<Integer, Integer> argPositions) {
        MethodReference dynaActionFormGet = WalaUtil.getUnresolvedMethodRef(className, selector);
        IMethod m = this.cha.resolveMethod(dynaActionFormGet);
        if (m != null) {
            this.beanPropAccessMethod2PropNamePos.put(m.getReference(), argPositions);
        }
    }

    public boolean accepts(IMethod m, CallSiteReference callSiteRef, CodeProcessor.ICallSiteInfo callInfo) {
        throw new UnsupportedOperationException();
    }

    public void visitCallSite(IMethod m, IR ir, DefUse du, TypeAbstraction[] types, CallSiteReference callSiteRef, SSAAbstractInvokeInstruction invoke, CodeProcessor.ICallSiteInfo callInfo) {
        throw new UnsupportedOperationException();
    }

    public void visitMethod(IMethod m, IR ir, DefUse du, TypeAbstraction[] type) {
        IClass dynaActionFormClass = this.cha.lookupClass(DYNA_ACTION_FORM_REF);
        int actionFormArgValNum = 3;
        String className = StringStuff.jvmToReadableType((String)m.getDeclaringClass().getName().toString());
        String globalBeanName = this.actionClass2GlobalBeanName.get(className);
        if (globalBeanName == null) {
            logger.info((Object)("no global bean name for class " + className));
            return;
        }
        AnalyzedBean analyzedBean = this.actionClass2AnalyzedBean.get(className);
        if (analyzedBean == null) {
            logger.info((Object)("no info for bean for class " + className));
            return;
        }
        HashSet handled = HashSetFactory.make();
        LinkedList<Integer> worklist = new LinkedList<Integer>();
        handled.add(3);
        worklist.add(3);
        while (!worklist.isEmpty()) {
            int curValNum = (Integer)worklist.remove();
            for (SSAInstruction use : Iterator2Iterable.make((Iterator)du.getUses(curValNum))) {
                if (use instanceof SSACheckCastInstruction) {
                    SSACheckCastInstruction cast = (SSACheckCastInstruction)use;
                    TypeReference declaredResultType = cast.getDeclaredResultTypes()[0];
                    IClass castType = this.cha.lookupClass(declaredResultType);
                    if (castType == null || !this.cha.isAssignableFrom(dynaActionFormClass, castType)) {
                        logger.info((Object)("unexpected cast of DynaActionForm to type " + castType));
                        continue;
                    }
                    int def = cast.getDef();
                    if (!handled.add(def)) continue;
                    worklist.add(def);
                    continue;
                }
                if (use instanceof SSAAbstractInvokeInstruction) {
                    SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)use;
                    MethodReference declaredTarget = WalaUtil.resolveMethodRef(invoke.getDeclaredTarget(), this.cha);
                    if (this.beanPropAccessMethod2PropNamePos.containsKey(declaredTarget)) {
                        Pair<Integer, Integer> posInfo = this.beanPropAccessMethod2PropNamePos.get(declaredTarget);
                        StringConstantFlow constantFlow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
                        Collection possibleStrings = constantFlow.findIntraprocStringsFlowingToVar(invoke.getUse(((Integer)posInfo.snd).intValue()));
                        if (possibleStrings.size() > 1) {
                            logger.info((Object)("multiple property names " + possibleStrings));
                            continue;
                        }
                        for (String propName : possibleStrings) {
                            if (!this.propertyWithNameExists(analyzedBean, propName)) continue;
                            ArgToOrigCallExpr origReturnVal = ArgToOrigCallExpr.make((int)-1);
                            ObjectRefExpr rval = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)globalBeanName), (String)propName);
                            rval = VDBJavaUtil.invokeFromJVMSig(null, "java.lang.Object.toString()Ljava/lang/String;", Collections.singletonMap(0, rval));
                            AssignmentExpr replacementExpr = AssignmentExpr.make(null, (AssignableSyntheticExpr)origReturnVal, (NonVoidSyntheticExpr)rval);
                            CallSiteReference callSite = invoke.getCallSite();
                            CallSiteReplacement replacement = CallSiteReplacement.make((String)WalaUtil.method2ResolvedVDBSignature(this.cha.resolveMethod(declaredTarget)), (int)callSite.getProgramCounter(), (int)WalaUtil.getSourceLine(m, callSite), (SyntheticExpr)replacementExpr);
                            MapUtil.findOrCreateSet(this.replacementsForBeanAccesses, (Object)WalaUtil.method2ResolvedVDBSignature(m)).add(replacement);
                        }
                        continue;
                    }
                    logger.info((Object)("dyna bean passed to unknown method " + declaredTarget));
                    continue;
                }
                logger.info((Object)("need to handle instr " + use + " type " + use.getClass()));
            }
        }
    }

    private boolean propertyWithNameExists(AnalyzedBean analyzedBean, String propName) {
        for (Property p : analyzedBean.getBeanProperties()) {
            if (!p.getName().equals(propName)) continue;
            return true;
        }
        return false;
    }

    public boolean visitsCallSites() {
        return false;
    }

    public void run() {
        CodeProcessor processor = new CodeProcessor(this.cha, new AnalysisCache());
        processor.addVisitor((CodeProcessor.ICodeVisitor)this);
        processor.process();
    }

    public Map<String, Set<CallSiteReplacement>> getReplacementsForBeanAccesses() {
        return this.replacementsForBeanAccesses;
    }
}

