/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.loader;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dotnet.cil.CILInvokeInstruction;
import com.ibm.wala.dotnet.cil.Translator;
import com.ibm.wala.dotnet.loader.CLRClass;
import com.ibm.wala.dotnet.loader.LowLevelInterface;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.IndirectionData;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.VoidFunction;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class CLRMethod<C, F, M, A, T>
implements IBytecodeMethod {
    final M handle;
    private final CLRClass<C, F, M, A, T> declarer;
    private final MethodReference ref;
    private Translator.BCInfo<C, F, M, A, T> bcInfo;

    public CLRMethod(M handle, CLRClass<C, F, M, A, T> declarer) {
        this.handle = handle;
        this.declarer = declarer;
        this.ref = this.computeRef();
    }

    private MethodReference computeRef() {
        String name = this.getReader().methodGetName(this.handle);
        Descriptor d = this.declarer.getClassLoader().computeMethodDescriptor(this.declarer.handle, this.handle);
        return MethodReference.findOrCreate((TypeReference)this.declarer.getReference(), (Atom)Atom.findOrCreateUnicodeAtom((String)name), (Descriptor)d);
    }

    private LowLevelInterface<C, F, M, A, T> getReader() {
        return this.declarer.getClassLoader().getAssembly().reader;
    }

    public String toString() {
        return this.getReference().toString();
    }

    public MethodReference getReference() {
        return this.ref;
    }

    public boolean isAbstract() {
        return this.getReader().methodIsAbstract(this.handle);
    }

    public boolean isClinit() {
        return this.getReader().methodIsClinit(this.handle);
    }

    public boolean isFinal() {
        return this.getReader().methodIsFinal(this.handle);
    }

    public boolean isInit() {
        return this.getReader().methodIsInit(this.handle);
    }

    public boolean isNative() {
        return this.getReader().methodIsNative(this.handle);
    }

    public boolean isPrivate() {
        return this.getReader().methodIsPrivate(this.handle);
    }

    public boolean isPublic() {
        return this.getReader().methodIsPublic(this.handle);
    }

    public boolean isSynchronized() {
        return this.getReader().methodIsSynchronized(this.handle);
    }

    public boolean isStatic() {
        return this.getReader().methodIsStatic(this.handle);
    }

    public IClassHierarchy getClassHierarchy() {
        return this.declarer.getClassHierarchy();
    }

    public CLRClass<C, F, M, A, T> getDeclaringClass() {
        return this.declarer;
    }

    public boolean isSynthetic() {
        return false;
    }

    public int getMaxStackHeight() {
        return this.getReader().methodGetMaxStackHeight(this.handle) + 10;
    }

    public Atom getName() {
        return this.getReference().getName();
    }

    public Descriptor getDescriptor() {
        return this.getReference().getDescriptor();
    }

    public Selector getSelector() {
        return this.getReference().getSelector();
    }

    public String getSignature() {
        return this.getReference().getSignature();
    }

    public Collection<Annotation> getCustomAttributeTypes() {
        T[] attributeHandles = this.getReader().methodGetCustomAttributes(this.handle);
        if (attributeHandles == null) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make();
        for (T t : attributeHandles) {
            C c = this.getReader().attributeGetType(t);
            assert (!this.getReader().classNotValid(c));
            result.add(Annotation.make((TypeReference)this.declarer.getClassLoader().getReference(c)));
        }
        return result;
    }

    public int getNumberOfParameters() {
        return this.getReader().methodGetNumberOfParameters(this.handle) + (this.isStatic() ? 0 : 1);
    }

    public TypeReference getParameterType(int i) {
        if (!this.isStatic()) {
            if (i == 0) {
                return this.getDeclaringClass().getReference();
            }
            --i;
        }
        C typeHandle = this.getReader().methodGetParameterType(this.handle, i);
        assert (!this.getReader().classNotValid(typeHandle));
        return this.declarer.getClassLoader().getReference(typeHandle);
    }

    public TypeReference getReturnType() {
        C typeHandle = this.getReader().methodGetReturnType(this.handle);
        return this.declarer.getClassLoader().getReference(typeHandle);
    }

    public boolean isBridge() {
        return false;
    }

    public boolean hasExceptionHandler() {
        return this.getReader().methodHasExceptionHandler(this.handle);
    }

    public boolean hasLocalVariableTable() {
        return this.getReader().methodHasLocalVariableTable(this.handle);
    }

    public int getMaxLocals() {
        return this.getNumberOfParameters() + (this.isStatic() ? 0 : 1) + this.getReader().methodGetMaxLocals(this.handle);
    }

    public int getLineNumber(int bcIndex) {
        return this.getReader().methodGetLineNumber(this.handle, bcIndex);
    }

    public String getLocalVariableName(int bcIndex, int localNumber) {
        return this.getReader().methodGetLocalVariableName(this.handle, bcIndex, localNumber);
    }

    public C getLocalVariableType(int localNumber) {
        return this.getReader().methodGetLocalVariableType(this.handle, localNumber);
    }

    public boolean isProtected() {
        return false;
    }

    public Accessibility getAccessibility() {
        int accessMask = this.getReader().methodGetAccessMask(this.handle);
        switch (accessMask) {
            case 0: {
                return Accessibility.COMPILER_CONTROLLED;
            }
            case 1: {
                return Accessibility.PRIVATE;
            }
            case 2: {
                return Accessibility.FAM_AND_ASSEM;
            }
            case 3: {
                return Accessibility.ASSEM;
            }
            case 4: {
                return Accessibility.FAMILY;
            }
            case 5: {
                return Accessibility.FAM_OR_ASSEM;
            }
            case 6: {
                return Accessibility.PUBLIC;
            }
        }
        throw new RuntimeException();
    }

    public TypeReference[] getDeclaredExceptions() throws InvalidClassFileException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public byte[] getBytecode() {
        return this.getReader().methodGetBytecode(this.handle);
    }

    public ExceptionEntry[] getExceptionEntries() {
        return this.getReader().methodGetHandlers(this, this.handle);
    }

    private Translator.BCInfo<C, F, M, A, T> getInfo() {
        if (this.bcInfo == null) {
            assert (this.getBytecode() != null);
            this.bcInfo = Translator.translate(this);
        }
        return this.bcInfo;
    }

    public IInstruction[] getInstructions() {
        return this.getInfo().getInstructions();
    }

    public int getBytecodeIndex(int index) {
        return this.getInfo().getProgramCounter(index);
    }

    public int[] getAddressTakenLocals() {
        return this.getInfo().getAddressTakenLocals();
    }

    public ExceptionHandler[][] getHandlers() {
        return this.getInfo().getHandlers();
    }

    public Collection<CallSiteReference> getCallSites() throws InvalidClassFileException {
        if (this.isAbstract() || this.isNative()) {
            return Collections.emptyList();
        }
        HashSet result = HashSetFactory.make();
        IInstruction[] instrs = this.getInstructions();
        for (int index = 0; index < instrs.length; ++index) {
            IInstruction instr = instrs[index];
            if (instr == null || !(instr instanceof CILInvokeInstruction)) continue;
            CILInvokeInstruction invoke = (CILInvokeInstruction)instr;
            result.add(CallSiteReference.make((int)this.getInfo().getProgramCounter(index), (MethodReference)invoke.getCallee(), (IInvokeInstruction.IDispatch)invoke.getInvocationCode()));
        }
        return result;
    }

    public String getSourceFileName(int offset) {
        return this.getReader().methodGetSourceFileName(this.handle, offset);
    }

    public IndirectionData getIndirectionData() {
        return this.declarer.getClassLoader().scope.makeIndirectionData(this);
    }

    public Collection<Annotation> getAnnotations() {
        final HashSet<Annotation> x = new HashSet<Annotation>();
        this.getDeclaringClass().visitSuperclasses(new VoidFunction<CLRClass<C, F, M, A, T>>(){

            public void apply(CLRClass<C, F, M, A, T> c) {
                CLRMethod m = (CLRMethod)c.getMethod(CLRMethod.this.getSelector());
                if (m != null) {
                    for (Annotation a : m.getDeclaredAttributes()) {
                        x.add(a);
                    }
                }
            }
        });
        return x;
    }

    public Collection<Annotation> getAnnotations(boolean runtimeVisibile) {
        return this.getAnnotations();
    }

    public Annotation[] getDeclaredAttributes() {
        T[] attrDescs = this.getReader().methodGetCustomAttributes(this.handle);
        return this.getDeclaringClass().getClassLoader().instantiateAttributes(attrDescs);
    }

    public M getHandle() {
        return this.handle;
    }

    private Collection<Annotation> makeAnnotations(T[] attributeHandles) {
        HashSet result = HashSetFactory.make();
        for (T t : attributeHandles) {
            C c = this.getReader().attributeGetType(t);
            assert (!this.getReader().classNotValid(c));
            result.add(Annotation.make((TypeReference)this.declarer.getClassLoader().getReference(c)));
        }
        return result;
    }

    public Collection<Annotation>[] getParameterAnnotations() {
        Collection[] result = new Collection[this.getNumberOfParameters()];
        for (int i = 0; i < this.getNumberOfParameters(); ++i) {
            result[i] = this.makeAnnotations(this.getReader().methodGetCustomParameterAttributes(this.handle, i));
        }
        return result;
    }

    public IMethod.SourcePosition getSourcePosition(final int instructionIndex) throws InvalidClassFileException {
        return new IMethod.SourcePosition(){

            public int compareTo(Object o) {
                return 0;
            }

            public int getFirstLine() {
                return CLRMethod.this.getLineNumber(instructionIndex);
            }

            public int getLastLine() {
                return 0;
            }

            public int getFirstCol() {
                return 0;
            }

            public int getLastCol() {
                return 0;
            }

            public int getFirstOffset() {
                return 0;
            }

            public int getLastOffset() {
                return 0;
            }
        };
    }

    public IMethod.SourcePosition getParameterSourcePosition(int paramNum) throws InvalidClassFileException {
        return null;
    }

    public static enum Accessibility {
        COMPILER_CONTROLLED,
        PRIVATE,
        FAM_AND_ASSEM,
        ASSEM,
        FAMILY,
        FAM_OR_ASSEM,
        PUBLIC;

    }

    public class ExceptionEntry {
        public final HandlerKind handlerKind;
        public final TypeReference catchType;
        public final int tryStart;
        public final int tryEnd;
        public final int filterStart;
        public final int handlerStart;
        public final int handlerEnd;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.catchType == null ? 0 : this.catchType.hashCode());
            result = 31 * result + this.filterStart;
            result = 31 * result + this.handlerEnd;
            result = 31 * result + (this.handlerKind == null ? 0 : this.handlerKind.hashCode());
            result = 31 * result + this.handlerStart;
            result = 31 * result + this.tryEnd;
            result = 31 * result + this.tryStart;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExceptionEntry other = (ExceptionEntry)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.catchType == null ? other.catchType != null : !this.catchType.equals((Object)other.catchType)) {
                return false;
            }
            if (this.filterStart != other.filterStart) {
                return false;
            }
            if (this.handlerEnd != other.handlerEnd) {
                return false;
            }
            if (this.handlerKind == null ? other.handlerKind != null : !this.handlerKind.equals((Object)other.handlerKind)) {
                return false;
            }
            if (this.handlerStart != other.handlerStart) {
                return false;
            }
            if (this.tryEnd != other.tryEnd) {
                return false;
            }
            return this.tryStart == other.tryStart;
        }

        public ExceptionEntry(HandlerKind handlerKind, TypeReference catchType, int tryStart, int tryEnd, int filterStart, int handlerStart, int handlerEnd) {
            this.handlerKind = handlerKind;
            this.catchType = catchType;
            this.tryStart = tryStart;
            this.tryEnd = tryEnd;
            this.filterStart = filterStart;
            this.handlerStart = handlerStart;
            this.handlerEnd = handlerEnd;
        }

        public ExceptionEntry(String handlerKind, int catchTypeToken, int tryStart, int tryLength, int filterStart, int handlerStart, int handlerLength) {
            this.handlerKind = HandlerKind.valueOf(handlerKind);
            if (catchTypeToken != -1) {
                Object classHandle = CLRMethod.this.getReader().resolveTypeToken(CLRMethod.this.handle, catchTypeToken);
                assert (!CLRMethod.this.getReader().classNotValid(classHandle));
                this.catchType = CLRMethod.this.getDeclaringClass().getClassLoader().getReference(classHandle);
            } else {
                this.catchType = this.handlerKind == HandlerKind.CATCH ? CLRTypeReference.SystemException : null;
            }
            this.tryStart = tryStart;
            this.tryEnd = tryStart + tryLength;
            this.filterStart = filterStart;
            this.handlerStart = handlerStart;
            this.handlerEnd = handlerStart + handlerLength;
        }

        public int getHandlerLabel() {
            switch (this.handlerKind) {
                case CATCH: 
                case FINALLY: 
                case FAULT: {
                    return this.handlerStart;
                }
                case FILTER: {
                    return this.filterStart;
                }
            }
            return -1;
        }

        private CLRMethod<C, F, M, A, T> getOuterType() {
            return CLRMethod.this;
        }

        public String toString() {
            return "handler[" + this.tryStart + "," + this.tryEnd + ":" + this.handlerStart + "," + this.handlerEnd + "]";
        }
    }

    public static enum HandlerKind {
        CATCH{

            @Override
            public boolean hasExceptionValue() {
                return true;
            }
        }
        ,
        FILTER,
        FAULT,
        FINALLY;


        public boolean hasExceptionValue() {
            return false;
        }
    }
}

