/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.command;

import com.ibm.wala.andromeda.cg.AccuracyLevel;
import com.ibm.wala.andromeda.cg.IEntrypointLocator;
import com.ibm.wala.andromeda.cg.TICallGraph;
import com.ibm.wala.andromeda.lang.DotNetServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.andromeda.lang.ILanguageSpecificServicesForFastanalysis;
import com.ibm.wala.andromeda.lang.JavaServicesForFastanalysis;
import com.ibm.wala.automaton.VerificationMonitor;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.stringAnalysis.sanitizerDetection.command.ISaProgress;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.IBackwardPropagation;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.JavaCFGStringAnalyzerProvider;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.MultiLanguageM2LStringAnalyzerProvider;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.MultiLanguageRegularStringAnalyzerProvider;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.OfflineBackwardPropagation;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.StringAnalysisDriver;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SAConfig;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SignatureUtil;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.StringAnalysisStatus;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SanitizerDetector {
    private final AnalysisScope scope;
    private final ClassHierarchy ch;
    private final AnalysisCache cache;
    private final ILangServices langServices;
    private final ILanguageSpecificServicesForFastanalysis fastLangServices;
    private final AccuracyLevel accuracyLevel;
    private final VerificationMonitor monitor;
    private final Logger logger;
    private final SAConfig.SAType saType;
    private final ISaProgress saProgress;
    private Collection<String> candidateSignatures;
    private final IBackwardPropagation propagation;

    public SanitizerDetector(String application, AnalysisScope scope, ILangServices langSpecificServices, SAConfig.SAType saType, ISaProgress saProgress, VerificationMonitor monitor, Logger logger) throws ClassHierarchyException {
        this.scope = scope;
        this.langServices = langSpecificServices;
        Language lang = langSpecificServices.getLanguage();
        if (Language.JAVA.equals((Object)lang)) {
            this.ch = ClassHierarchy.make((AnalysisScope)scope);
            this.fastLangServices = JavaServicesForFastanalysis.JAVA;
        } else if (CLRLanguage.lang.equals(lang)) {
            this.ch = ClassHierarchy.make((AnalysisScope)scope, (ClassLoaderFactory)((ClassLoaderFactory)scope), (Language)this.langServices.getLanguage());
            this.fastLangServices = DotNetServicesForFastanalysis.DOTNET;
        } else {
            throw new UnimplementedError();
        }
        this.cache = new AnalysisCache();
        this.accuracyLevel = AccuracyLevel.getDefaultLevel();
        this.monitor = monitor;
        this.logger = logger;
        this.saType = saType;
        this.saProgress = saProgress;
        this.candidateSignatures = null;
        this.propagation = OfflineBackwardPropagation.loadFromResource(langSpecificServices.getOfflineSpecificationFile());
    }

    public void setCandidates(Collection<String> candidates) {
        this.candidateSignatures = candidates;
    }

    public void findSanitizers(StringAnalysisStatus stat) {
        List<IMethod> candidates = this.locateCandidates();
        if (SAUtil.DEBUG) {
            this.logger.debug((Object)"candidates:");
            for (IMethod m : candidates) {
                this.logger.debug((Object)m.getSignature());
            }
        }
        int numberOfCandidates = candidates.size();
        this.logger.info((Object)("Processing " + numberOfCandidates + " candidates: "));
        this.saProgress.setNumberOfCandidates(numberOfCandidates);
        for (IMethod m : candidates) {
            this.logger.info((Object)("\t" + m.getSignature()));
        }
        for (IMethod m : candidates) {
            this.saProgress.setCurrentCandidate(m.getSignature());
            this.monitor.setCanceled(false);
            try {
                this.examineCandidate(m, stat);
            }
            catch (AssertionError e) {
                this.logger.warn((Object)("Assertion error analyzing candidate " + m.getSignature()), (Throwable)((Object)e));
            }
            catch (Exception e) {
                this.logger.warn((Object)("Error analyzing candidate " + m.getSignature()), (Throwable)e);
            }
        }
        this.saProgress.setCurrentCandidate(null);
    }

    private List<IMethod> locateCandidates() {
        ArrayList<IMethod> candidates = new ArrayList<IMethod>();
        for (IClassLoader cl : this.ch.getLoaders()) {
            if (!this.scope.isApplicationLoader(cl)) continue;
            Iterator iter = cl.iterateAllClasses();
            while (iter.hasNext()) {
                IClass c = (IClass)iter.next();
                block2: for (IMethod m : c.getDeclaredMethods()) {
                    if (!this.isCandidate(m)) continue;
                    if (this.candidateSignatures == null) {
                        candidates.add(m);
                        continue;
                    }
                    if (this.candidateSignatures.contains(m.getSignature())) {
                        candidates.add(m);
                        continue;
                    }
                    for (String sig : this.candidateSignatures) {
                        if (!m.getSignature().contains(sig)) continue;
                        candidates.add(m);
                        continue block2;
                    }
                }
            }
        }
        return candidates;
    }

    private boolean isCandidate(IMethod m) {
        if (m.isAbstract()) {
            return false;
        }
        if (m.isNative()) {
            return false;
        }
        if (m.isSynthetic()) {
            return false;
        }
        if (SignatureUtil.matchesSanitizerPattern((IClassHierarchy)this.ch, m, this.langServices)) {
            return true;
        }
        return SAConfig.SAType.M2L.equals((Object)this.saType) && SignatureUtil.matchesValidatorPattern((IClassHierarchy)this.ch, m, this.langServices);
    }

    private void examineCandidate(IMethod m, StringAnalysisStatus stat) throws IllegalArgumentException, CallGraphBuilderCancelException {
        String signature = m.getSignature();
        this.logger.info((Object)("Examining: " + signature));
        TICallGraph cg = this.buildCallGraph(m);
        this.logger.info((Object)("CG for candidate " + signature + " contains " + cg.getNumberOfNodes() + " nodes"));
        CGNode n = (CGNode)cg.getNodes(m.getReference()).iterator().next();
        if (this.isValidatorCandidate(n) || this.isTaintPropagatingCandidate(n, (CallGraph)cg)) {
            this.logger.info((Object)("scanning " + signature));
            StringAnalysisDriver<?> driver = this.createDriver((CallGraph)cg);
            driver.scanMethods(Collections.singleton(n), (CallGraph)cg, this.cache, stat, (MonitorUtil.IProgressMonitor)this.monitor, this.logger);
        }
    }

    private boolean isValidatorCandidate(CGNode node) {
        return TypeReference.Boolean.equals((Object)node.getMethod().getReturnType());
    }

    private boolean isTaintPropagatingCandidate(CGNode node, CallGraph cg) {
        IR ir = node.getIR();
        DefUse du = node.getDU();
        if (ir == null || du == null) {
            return false;
        }
        HashSet worklist = this.getReturnedVariables(node.getIR());
        HashSet visited = HashSetFactory.make(worklist);
        while (!worklist.isEmpty()) {
            Iterator<Integer> it = worklist.iterator();
            worklist = HashSetFactory.make();
            while (it.hasNext()) {
                int v = it.next();
                visited.add(v);
                SSAInstruction def = du.getDef(v);
                if (def == null) {
                    if (ir.getSymbolTable().isParameter(v)) {
                        return true;
                    }
                } else {
                    for (int i = 0; i < def.getNumberOfUses(); ++i) {
                        int vv = def.getUse(i);
                        if (visited.contains(vv)) continue;
                        worklist.add(vv);
                    }
                }
                Iterator iter = du.getUses(v);
                while (iter.hasNext()) {
                    SSAAbstractInvokeInstruction invoke;
                    String sig;
                    SSAInstruction use = (SSAInstruction)iter.next();
                    if (!(use instanceof SSAAbstractInvokeInstruction) || !this.propagation.hasPropagation(sig = (invoke = (SSAAbstractInvokeInstruction)use).getDeclaredTarget().getSignature())) continue;
                    for (int i = 0; i < invoke.getNumberOfUses(); ++i) {
                        if (invoke.getUse(i) != v) continue;
                        for (int j : this.propagation.propagate(sig, invoke.getNumberOfUses(), i)) {
                            int vv = invoke.getUse(j);
                            if (visited.contains(vv)) continue;
                            worklist.add(vv);
                        }
                    }
                }
            }
        }
        return false;
    }

    private Set<Integer> getReturnedVariables(IR ir) {
        HashSet result = HashSetFactory.make((int)1);
        for (SSAInstruction i : ir.getInstructions()) {
            if (!(i instanceof SSAReturnInstruction)) continue;
            result.add(i.getUse(0));
        }
        return result;
    }

    private StringAnalysisDriver<?> createDriver(CallGraph cg) {
        AnalysisOptions analysisOptions = new AnalysisOptions();
        switch (this.saType) {
            case REG: {
                return this.createDriverReg(analysisOptions);
            }
            case CFG: {
                return this.createDriverCfg(analysisOptions);
            }
            case M2L: {
                return this.createDriverM2L(analysisOptions);
            }
        }
        throw new RuntimeException("unknown language: " + this.langServices.getLanguage());
    }

    private StringAnalysisDriver<?> createDriverReg(AnalysisOptions analysisOptions) {
        MultiLanguageRegularStringAnalyzerProvider saImpl = new MultiLanguageRegularStringAnalyzerProvider(this.langServices.getLanguage());
        return new StringAnalysisDriver<IAutomaton>(saImpl, analysisOptions, this.langServices);
    }

    private StringAnalysisDriver<?> createDriverCfg(AnalysisOptions analysisOptions) {
        JavaCFGStringAnalyzerProvider saImpl = new JavaCFGStringAnalyzerProvider();
        return new StringAnalysisDriver<IContextFreeGrammar>(saImpl, analysisOptions, this.langServices);
    }

    private StringAnalysisDriver<?> createDriverM2L(AnalysisOptions analysisOptions) {
        MultiLanguageM2LStringAnalyzerProvider saImpl = new MultiLanguageM2LStringAnalyzerProvider(this.langServices.getLanguage());
        return new StringAnalysisDriver<IDeclarationSet>(saImpl, analysisOptions, this.langServices);
    }

    private TICallGraph buildCallGraph(final IMethod m) throws IllegalArgumentException, CallGraphBuilderCancelException {
        IEntrypointLocator entrypointLocator = new IEntrypointLocator(){

            public Set<IMethod> locateEntrypoints(IClassHierarchy cha) {
                IMethod classInitializer = null;
                classInitializer = m.getDeclaringClass().getClassInitializer();
                HashSet ret = HashSetFactory.make();
                ret.add(m);
                if (classInitializer != null) {
                    ret.add(classInitializer);
                }
                return ret;
            }
        };
        TICallGraph cg = new TICallGraph((IClassHierarchy)this.ch, entrypointLocator, this.langServices, this.fastLangServices, this.cache, this.accuracyLevel);
        return cg;
    }
}

