/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.util.collections.HashMapFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResultsUtil
extends DefaultHandler {
    private String tempVal;
    private boolean sinkContext = false;
    private boolean classInfoContext = false;
    private boolean relevant = false;
    private boolean vulnerabilityContext = false;
    private Map<String, SingleIssueResult> resultsMap = HashMapFactory.make();
    private Map<ResultOrigin, Double> totalTimesMap = new LinkedHashMap<ResultOrigin, Double>();
    private int numOfLines = 0;
    private Language lang;
    private boolean externalEntries;
    private static ResultsUtil soleInstance;

    public static ResultsUtil getSoleInstance() {
        if (soleInstance == null) {
            soleInstance = new ResultsUtil();
        }
        return soleInstance;
    }

    private ResultsUtil() {
    }

    public void registerTotalTime(ResultOrigin origin, double totalTime) {
        this.totalTimesMap.put(origin, totalTime);
    }

    public void registerNumberOfSystemLines(int numOfLines) {
        this.numOfLines = numOfLines;
    }

    public void registerResult(ResultOrigin origin, String sourceFileName, int lineNo) {
        String key = sourceFileName + ":" + lineNo;
        if (!this.resultsMap.containsKey(key)) {
            this.resultsMap.put(key, new SingleIssueResult());
        }
        this.resultsMap.get(key).add(origin);
    }

    public void clear() {
        this.resultsMap.clear();
    }

    public boolean loadResultsFromFortify(String fvdlFileName) {
        File fvdlFile = new File(fvdlFileName);
        if (fvdlFile.exists()) {
            try {
                this.parseFvdl(fvdlFile);
                return true;
            }
            catch (ParserConfigurationException e) {
                return false;
            }
            catch (SAXException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    private void parseFvdl(File file) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(file, (DefaultHandler)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tempVal = "";
        if (qName.equalsIgnoreCase("Vulnerability")) {
            this.vulnerabilityContext = true;
        }
        if (qName.equalsIgnoreCase("ClassInfo") && this.vulnerabilityContext) {
            this.classInfoContext = true;
        }
        if (this.lang.equals(CLRLanguage.lang)) {
            if (qName.equalsIgnoreCase("SourceLocation")) {
                this.sinkContext = true;
            }
        } else if (qName.equalsIgnoreCase("sink")) {
            this.sinkContext = true;
        }
        if (qName.equalsIgnoreCase("ExternalEntries")) {
            this.externalEntries = true;
        }
        if (qName.equalsIgnoreCase("SourceLocation") && this.sinkContext && this.relevant && !this.externalEntries) {
            String fullPath = attributes.getValue("path");
            fullPath = fullPath.replace("\\", "/");
            String path = fullPath.substring(fullPath.lastIndexOf("/") + 1);
            int line = Integer.parseInt(attributes.getValue("line"));
            this.registerResult(ResultOrigin.FORTIFY, path, line);
        }
        if (qName.equalsIgnoreCase("ScanTime")) {
            double scanTime = Double.parseDouble(attributes.getValue("value"));
            this.registerTotalTime(ResultOrigin.FORTIFY, scanTime);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tempVal = new String(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.lang.equals(CLRLanguage.lang)) {
            if (qName.equalsIgnoreCase("AnalyzerName") && this.classInfoContext) {
                this.classInfoContext = false;
                if (this.tempVal.equalsIgnoreCase("dataflow")) {
                    this.relevant = true;
                }
            }
        } else if (qName.equalsIgnoreCase("DefaultSeverity") && this.classInfoContext) {
            this.classInfoContext = false;
            if (Double.parseDouble(this.tempVal) > 2.0) {
                this.relevant = true;
            }
        }
        if (qName.equalsIgnoreCase("ClassInfo")) {
            this.classInfoContext = false;
        }
        if (qName.equalsIgnoreCase("ExternalEntries")) {
            this.externalEntries = false;
        }
        if (qName.equalsIgnoreCase("Vulnerability")) {
            this.vulnerabilityContext = false;
            this.relevant = false;
        }
        if (this.lang.equals(CLRLanguage.lang)) {
            if (qName.equalsIgnoreCase("SourceLocation")) {
                this.sinkContext = false;
            }
        } else if (qName.equalsIgnoreCase("sink")) {
            this.sinkContext = false;
        }
    }

    public String toString() {
        return this.getCSV();
    }

    public String getCSV() {
        String newline = System.getProperty("line.separator");
        int totalFindings = 0;
        String result = "location";
        result = result + "," + (Object)((Object)ResultOrigin.IBM);
        result = result + newline;
        ArrayList<String> keys = new ArrayList<String>(this.resultsMap.keySet());
        Collections.sort(keys);
        for (String fileNameAndLineNo : keys) {
            SingleIssueResult currentIssue = this.resultsMap.get(fileNameAndLineNo);
            Integer ibmRes = currentIssue.get(ResultOrigin.IBM);
            if (ibmRes == null) continue;
            result = result + fileNameAndLineNo;
            result = result + "," + ibmRes;
            result = result + newline;
            totalFindings += ibmRes.intValue();
        }
        result = result + newline;
        result = result + "total time";
        result = result + "," + (this.totalTimesMap.containsKey((Object)ResultOrigin.IBM) ? (Serializable)this.totalTimesMap.get((Object)ResultOrigin.IBM) : "-1") + ",";
        result = result + newline;
        result = result + "total findings";
        result = result + "," + totalFindings;
        result = result + newline;
        result = result + "number of system lines";
        result = result + "," + this.numOfLines;
        result = result + newline;
        result = result + "Language";
        result = result + "," + this.lang;
        return result;
    }

    public void registerLanguage(Language lang) {
        this.lang = lang;
    }

    private class SingleIssueResult {
        private Map<ResultOrigin, Integer> reportedBy = new HashMap<ResultOrigin, Integer>();

        public SingleIssueResult() {
            for (ResultOrigin origin : ResultOrigin.values()) {
                this.reportedBy.put(origin, 0);
            }
        }

        public int get(ResultOrigin origin) {
            return this.reportedBy.get((Object)origin);
        }

        public void add(ResultOrigin origin) {
            this.reportedBy.put(origin, this.reportedBy.get((Object)origin) + 1);
        }
    }

    public static enum ResultOrigin {
        TRUE,
        IBM,
        FORTIFY,
        OUNCE;


        public boolean isTrue() {
            return this.equals((Object)TRUE);
        }
    }
}

