/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.html;

import com.ibm.wala.cast.js.html.FileMapping;
import com.ibm.wala.cast.js.html.IncludedPosition;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import java.util.ArrayList;
import java.util.List;

public class CompositeFileMapping
implements FileMapping {
    private final List<FileMapping> mappings = new ArrayList<FileMapping>(2);

    public CompositeFileMapping(FileMapping a, FileMapping b) {
        this.addMapping(a);
        this.addMapping(b);
    }

    private void addMapping(FileMapping fm) {
        if (fm instanceof CompositeFileMapping) {
            this.mappings.addAll(((CompositeFileMapping)fm).mappings);
        } else {
            this.mappings.add(fm);
        }
    }

    @Override
    public IncludedPosition getIncludedPosition(CAstSourcePositionMap.Position line) {
        for (FileMapping fm : this.mappings) {
            IncludedPosition result = fm.getIncludedPosition(line);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String toString() {
        return this.mappings.toString();
    }
}

