/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ipa.callgraph;

import com.ibm.wala.analysis.reflection.InstanceKeyWithNode;
import com.ibm.wala.cast.ipa.callgraph.ScopeMappingInstanceKeys;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptConstructorFunctions;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallString;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallStringContext;
import com.ibm.wala.util.intset.IntSet;

public class RecursionBoundContextSelector
implements ContextSelector {
    private final ContextSelector base;
    private final int recursionBound;
    private static final int MAX_INTERESTING_PARAM = 5;

    public RecursionBoundContextSelector(ContextSelector base, int recursionBound) {
        this.base = base;
        this.recursionBound = recursionBound;
    }

    public Context getCalleeTarget(CGNode caller, CallSiteReference site, IMethod callee, InstanceKey[] actualParameters) {
        Context baseContext = this.base.getCalleeTarget(caller, site, callee, actualParameters);
        boolean exceedsRecursionBound = this.exceedsRecursionBound(baseContext, 0);
        if (!exceedsRecursionBound) {
            return baseContext;
        }
        if (callee instanceof JavaScriptConstructorFunctions.JavaScriptConstructor) {
            return new CallStringContext(new CallString(site, caller.getMethod()));
        }
        return Everywhere.EVERYWHERE;
    }

    private boolean exceedsRecursionBound(Context baseContext, int curLevel) {
        if (curLevel > this.recursionBound) {
            return true;
        }
        CGNode callerNode = (CGNode)baseContext.get(ContextKey.CALLER);
        if (callerNode != null && this.exceedsRecursionBound(callerNode.getContext(), curLevel + 1)) {
            return true;
        }
        for (int i = 0; i < 5; ++i) {
            FilteredPointerKey.SingleInstanceFilter filter = (FilteredPointerKey.SingleInstanceFilter)baseContext.get(ContextKey.PARAMETERS[i]);
            if (filter == null) continue;
            InstanceKey ik = filter.getInstance();
            if (ik instanceof ScopeMappingInstanceKeys.ScopeMappingInstanceKey) {
                ik = ((ScopeMappingInstanceKeys.ScopeMappingInstanceKey)ik).getBase();
            }
            if (!(ik instanceof InstanceKeyWithNode) || !this.exceedsRecursionBound(((InstanceKeyWithNode)ik).getNode().getContext(), curLevel + 1)) continue;
            return true;
        }
        return false;
    }

    public IntSet getRelevantParameters(CGNode caller, CallSiteReference site) {
        return this.base.getRelevantParameters(caller, site);
    }
}

