/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.weblogic.compilers;

import com.hcl.appscan.discovery.java.utils.JDKHelper;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.discovery.jsp.compilers.ExternalJSPCompiler;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Map;

public class WeblogicJSPCompiler
extends ExternalJSPCompiler {
    private String m_jspCompiler = "weblogic.jspc";

    WeblogicJSPCompiler(String[] classpathEntries) {
        super(classpathEntries);
    }

    public String getServerType() {
        return "WEBLOGIC";
    }

    protected String getCompilerClasspath() {
        return this.getServerClasspath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createInputFile() throws IOException {
        File file = new File(this.m_outDir.getParentFile(), "compiler.args");
        PrintStream out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), true, "UTF-8");
        try {
            String jspArgs;
            out.println(this.m_webapp.getPath());
            out.println(this.m_outDir.getPath());
            IBuildInfo info = this.m_proxy.getBuildInfo();
            String classpath = ClasspathUtil.joinPaths((String[])new String[]{info.getProperty("classpath"), info.getProperty("additional_classpath")});
            if (!classpath.isEmpty()) {
                out.println(classpath);
            }
            if ((jspArgs = info.getProperty("jsp_compiler_args")) != null && !jspArgs.isEmpty()) {
                out.println(jspArgs);
            } else {
                out.println("NoJSPArgs");
            }
            File file2 = file;
            return file2;
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> processInputFile(String inputFile) throws IOException {
        Hashtable<String, String> args = new Hashtable<String, String>();
        try (BufferedReader reader = null;){
            String jspArgs;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8"));
            args.put("webapp", reader.readLine());
            args.put("outDir", reader.readLine());
            String classpath = reader.readLine();
            if (classpath != null) {
                args.put("classpath", classpath);
            }
            if (!(jspArgs = reader.readLine()).equals("NoJSPArgs")) {
                args.put("jspArgs", jspArgs);
            }
        }
        return args;
    }

    protected boolean run(IProgress progress) throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("CLASSPATH", this.getCompilerClasspath());
        File inputFile = this.createInputFile();
        Map<String, String> inputArgs = WeblogicJSPCompiler.processInputFile(inputFile.getPath());
        String[] args = new String[]{JDKHelper.getJavaExec((IScanTargetMinProxy)this.m_proxy), this.m_jspCompiler, "-classpath", ClasspathUtil.generateSmallClassPath((String)inputArgs.get("classpath")), "-compileAll", "-forceGeneration", "-keepgenerated", "-verbose", "-k", "-g", "-d", inputArgs.get("outDir"), "-webapp", inputArgs.get("webapp")};
        return this.compile(env, args) == 0;
    }

    public File[] getCompiledClasses(String jspPath, IProgress progress) {
        StringBuilder str = new StringBuilder();
        String[] splitFileName = jspPath.split("/");
        str.append("jsp_servlet" + File.separator);
        for (String fileName : splitFileName) {
            if (fileName.endsWith(".jsp")) {
                String className = "__" + fileName.toLowerCase().replace(".jsp", ".class");
                str.append(className);
                continue;
            }
            String renameDir = "_" + fileName.toLowerCase() + File.separator;
            str.append(renameDir);
        }
        File primaryClass = new File(this.m_outDir, str.toString());
        return new File[]{primaryClass};
    }
}

