/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.json;

import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONString;
import org.apache.commons.json.internal.BeanSerializer;

public class JSONWriter {
    protected Writer writer = null;
    private boolean inObject = false;
    private boolean inArray = false;
    private boolean keyPlaced = false;
    private boolean firstEntry = false;
    private Stack closures = null;
    private boolean closed = false;

    public JSONWriter(Writer writer) throws NullPointerException {
        Class<?> clazz = writer.getClass();
        if (!(StringWriter.class.isAssignableFrom(clazz) || CharArrayWriter.class.isAssignableFrom(clazz) || BufferedWriter.class.isAssignableFrom(clazz))) {
            writer = new BufferedWriter(writer);
        }
        this.writer = writer;
        this.closures = new Stack();
    }

    public JSONWriter array() throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inObject) {
            if (!this.keyPlaced) {
                throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified to contain a new array");
            }
        } else if (this.inArray && !this.firstEntry) {
            this.writer.write(",");
        }
        this.writer.write("[");
        this.inArray = true;
        this.inObject = false;
        this.keyPlaced = false;
        this.firstEntry = true;
        this.closures.push("]");
        return this;
    }

    public JSONWriter endArray() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (!this.inArray) {
            throw new IllegalStateException("Current writer position is not within a JSON array");
        }
        this.writer.write((String)this.closures.pop());
        if (!this.closures.isEmpty()) {
            String string = (String)this.closures.peek();
            if (string.equals("}")) {
                this.inObject = true;
                this.inArray = false;
            } else {
                this.inObject = false;
                this.inArray = true;
            }
            this.firstEntry = false;
        } else {
            this.inArray = false;
            this.inObject = false;
            this.firstEntry = true;
        }
        return this;
    }

    public JSONWriter endObject() throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (!this.inObject) {
            throw new IllegalStateException("Current writer position is not within a JSON object");
        }
        if (this.keyPlaced) {
            throw new IllegalStateException("Current writer position in an object and has a key placed, but no value has been assigned to the key.  Cannot end.");
        }
        this.writer.write((String)this.closures.pop());
        if (!this.closures.isEmpty()) {
            String string = (String)this.closures.peek();
            if (string.equals("}")) {
                this.inObject = true;
                this.inArray = false;
            } else {
                this.inObject = false;
                this.inArray = true;
            }
            this.firstEntry = false;
        } else {
            this.inArray = false;
            this.inObject = false;
            this.firstEntry = true;
        }
        return this;
    }

    public JSONWriter key(String string) throws IOException, IllegalStateException, NullPointerException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (string == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (!this.inObject) {
            throw new IllegalStateException("Current writer position is not inside a JSON Object, a key cannot be placed.");
        }
        if (!this.keyPlaced) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
        } else {
            throw new IllegalStateException("Current writer position is inside a JSON Object an with an open key waiting for a value.  Another key cannot be placed.");
        }
        this.keyPlaced = true;
        this.writeString(string);
        this.writer.write(":");
        return this;
    }

    public JSONWriter object() throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inObject) {
            if (!this.keyPlaced) {
                throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified to contain a new object");
            }
        } else if (this.inArray && !this.firstEntry) {
            this.writer.write(",");
        }
        this.writer.write("{");
        this.inObject = true;
        this.inArray = false;
        this.keyPlaced = false;
        this.firstEntry = true;
        this.closures.push("}");
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(boolean bl) throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writer.write(Boolean.toString(bl));
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the boolean value.");
            this.writer.write(Boolean.toString(bl));
            this.keyPlaced = false;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(double d) throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writer.write(Double.toString(d));
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the double value.");
            this.writer.write(Double.toString(d));
            this.keyPlaced = false;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(long l) throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writer.write(Long.toString(l));
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the long value.");
            this.writer.write(Long.toString(l));
            this.keyPlaced = false;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(int n) throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writer.write(Integer.toString(n));
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the int value.");
            this.writer.write(Integer.toString(n));
            this.keyPlaced = false;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(short s) throws IOException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writer.write(Short.toString(s));
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the short value.");
            this.writer.write(Short.toString(s));
            this.keyPlaced = false;
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONWriter value(Object object) throws IOException, IllegalStateException, JSONException {
        if (this.closed) {
            throw new IllegalStateException("The writer has been closed.  No further operations allowed.");
        }
        if (this.inArray) {
            if (this.firstEntry) {
                this.firstEntry = false;
            } else {
                this.writer.write(",");
            }
            this.writeObject(object);
            return this;
        } else {
            if (!this.inObject) throw new IllegalStateException("Writer is currently not in an array or object, cannot write value");
            if (!this.keyPlaced) throw new IllegalStateException("Current containment is a JSONObject, but a key has not been specified for the boolean value.");
            this.writeObject(object);
            this.keyPlaced = false;
        }
        return this;
    }

    public void close() throws IOException, IllegalStateException {
        if (!this.closed) {
            if (this.inObject && this.keyPlaced) {
                throw new IllegalStateException("Object has key without value.  Cannot close.");
            }
            while (!this.closures.isEmpty()) {
                this.writer.write((String)this.closures.pop());
            }
            this.writer.flush();
            this.writer.close();
            this.closed = true;
        }
    }

    public JSONWriter flush() throws IOException {
        this.writer.flush();
        return this;
    }

    private void writeString(String string) throws IOException {
        this.writer.write(34);
        char[] cArray = string.toCharArray();
        block11: for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block11;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block11;
                }
                case '\u0000': {
                    this.writer.write("\\0");
                    continue block11;
                }
                case '\b': {
                    this.writer.write("\\b");
                    continue block11;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block11;
                }
                case '\n': {
                    this.writer.write("\\n");
                    continue block11;
                }
                case '\f': {
                    this.writer.write("\\f");
                    continue block11;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block11;
                }
                case '/': {
                    this.writer.write("\\/");
                    continue block11;
                }
                default: {
                    if (c >= ' ' && c <= '~') {
                        this.writer.write(c);
                        continue block11;
                    }
                    this.writer.write("\\u");
                    this.writer.write(this.rightAlignedZero(Integer.toHexString(c), 4));
                }
            }
        }
        this.writer.write(34);
    }

    private String rightAlignedZero(String string, int n) {
        if (n == string.length()) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    private void writeNumber(Number number) throws IOException {
        if (null == number) {
            this.writeNull();
        }
        if (number instanceof Float) {
            if (((Float)number).isNaN()) {
                this.writeNull();
            }
            if (Float.NEGATIVE_INFINITY == number.floatValue()) {
                this.writeNull();
            }
            if (Float.POSITIVE_INFINITY == number.floatValue()) {
                this.writeNull();
            }
        }
        if (number instanceof Double) {
            if (((Double)number).isNaN()) {
                this.writeNull();
            }
            if (Double.NEGATIVE_INFINITY == number.doubleValue()) {
                this.writeNull();
            }
            if (Double.POSITIVE_INFINITY == number.doubleValue()) {
                this.writeNull();
            }
        }
        this.writer.write(number.toString());
    }

    private void writeObject(Object object) throws IOException, JSONException {
        Class<?> clazz;
        if (object == null) {
            this.writeNull();
        } else if (JSONArtifact.class.isAssignableFrom(clazz = object.getClass())) {
            this.writer.write(((JSONArtifact)object).toString());
        } else if (Number.class.isAssignableFrom(clazz)) {
            this.writeNumber((Number)object);
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            this.writer.write(((Boolean)object).toString());
        } else if (String.class.isAssignableFrom(clazz)) {
            this.writeString((String)object);
        } else if (JSONString.class.isAssignableFrom(clazz)) {
            this.writer.write(((JSONString)object).toJSONString());
        } else {
            this.writer.write(BeanSerializer.toJson(object, true).write());
        }
    }

    private void writeNull() throws IOException {
        this.writer.write("null");
    }
}

