/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.filter;

import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.filter.Filter;
import com.ibm.appscan.filter.FilterException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class FilterManager {
    private HashMap<Language.LANGUAGE, ArrayList<Filter>> m_exclude_filters;
    private ArrayList<String> m_no_trace_sev_include;
    private ArrayList<String> m_no_trace_conf_include;
    private Filter m_noisy;

    public boolean isExcluded(Finding f) throws FilterException {
        return this.getExcludedReason(f) != null;
    }

    public String getExcludedReason(Finding f) throws FilterException {
        for (Filter filter : this.getExcludeFilterMap().get(f.getLanguage())) {
            if (!filter.isExcludeMatch(f)) continue;
            return filter.getName();
        }
        return null;
    }

    public ArrayList<Filter> getExcludeFilters(Language.LANGUAGE lang) throws FilterException {
        return this.getExcludeFilterMap().get(lang);
    }

    private HashMap<Language.LANGUAGE, ArrayList<Filter>> getExcludeFilterMap() throws FilterException {
        if (this.m_exclude_filters == null) {
            this.m_exclude_filters = new HashMap();
            for (Language.LANGUAGE l : Language.LANGUAGE.values()) {
                File gen;
                this.m_exclude_filters.put(l, new ArrayList());
                String subdir = l.toVdbString();
                File dir = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "scan_filters" + File.separator + "exclude" + File.separator + subdir);
                if (dir.exists()) {
                    for (File file : dir.listFiles()) {
                        this.m_exclude_filters.get(l).add(new Filter(file));
                    }
                }
                if (l != Language.LANGUAGE.JAVA && l != Language.LANGUAGE.DOT_NET || !(gen = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "scan_filters" + File.separator + "exclude" + File.separator + "general")).exists()) continue;
                for (File file : gen.listFiles()) {
                    this.m_exclude_filters.get(l).add(new Filter(file));
                }
            }
        }
        return this.m_exclude_filters;
    }

    public boolean isNoTraceIncluded(Finding f) throws FilterException {
        if (this.isExcluded(f)) {
            return false;
        }
        return this.getNoTraceSeverities().contains(f.getData().getSeverity().toLowerCase()) && this.getNoTraceConfidences().contains(f.getData().getConfidence().toLowerCase());
    }

    private ArrayList<String> getNoTraceSeverities() throws FilterException {
        if (this.m_no_trace_sev_include == null) {
            this.m_no_trace_sev_include = new ArrayList();
            File f = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "scan_filters", "no-trace.txt");
            if (f.exists()) {
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(f));
                    String line = br.readLine();
                    while (line != null) {
                        if (line.startsWith("severity")) {
                            String sevs = line.split("=")[1];
                            for (String sev : sevs.split(",")) {
                                this.m_no_trace_sev_include.add(sev.replaceAll("\\s+", "").toLowerCase());
                            }
                        }
                        line = br.readLine();
                    }
                }
                catch (IOException e) {
                    try {
                        throw new FilterException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(br);
                        throw throwable;
                    }
                }
                IOUtil.close((Closeable)br);
            }
        }
        return this.m_no_trace_sev_include;
    }

    private ArrayList<String> getNoTraceConfidences() throws FilterException {
        if (this.m_no_trace_conf_include == null) {
            this.m_no_trace_conf_include = new ArrayList();
            File f = new File(CommonCore.getDirectoryLocator().getMl() + File.separator + "scan_filters", "no-trace.txt");
            if (f.exists()) {
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(f));
                    String line = br.readLine();
                    while (line != null) {
                        if (line.startsWith("confidence")) {
                            String sevs = line.split("=")[1];
                            for (String sev : sevs.split(",")) {
                                this.m_no_trace_conf_include.add(sev.replaceAll("\\s+", "").toLowerCase());
                            }
                        }
                        line = br.readLine();
                    }
                }
                catch (IOException e) {
                    try {
                        throw new FilterException(e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(br);
                        throw throwable;
                    }
                }
                IOUtil.close((Closeable)br);
            }
        }
        return this.m_no_trace_conf_include;
    }
}

