/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.filter.processing;

import com.ibm.appscan.filter.Filter;
import com.ibm.appscan.filter.FilterEnums;
import com.ibm.appscan.filter.FilterException;
import com.ibm.appscan.filter.conditions.Condition;
import com.ibm.appscan.filter.conditions.ProhibitedCallsFindingCondition;
import com.ibm.appscan.filter.conditions.PropertyCondition;
import com.ibm.appscan.filter.conditions.RegexTraceNodeCondition;
import com.ibm.appscan.filter.conditions.RequiredCallsFindingCondition;
import com.ibm.appscan.filter.conditions.SinkFindingCondition;
import com.ibm.appscan.filter.conditions.SourceFindingCondition;
import com.ibm.appscan.filter.rules.ConfidenceRule;
import com.ibm.appscan.filter.rules.Rule;
import com.ibm.appscan.filter.rules.SeverityRule;
import com.ibm.appscan.filter.rules.TraceRule;
import com.ibm.appscan.filter.rules.exclude.ExcludeApiRule;
import com.ibm.appscan.filter.rules.exclude.ExcludeContextRule;
import com.ibm.appscan.filter.rules.exclude.ExcludeDirectoryRule;
import com.ibm.appscan.filter.rules.exclude.ExcludeFileRule;
import com.ibm.appscan.filter.rules.exclude.ExcludeProjectRule;
import com.ibm.appscan.filter.rules.exclude.ExcludeTraceRule;
import com.ibm.appscan.filter.rules.exclude.ExcludeVulnerabilityRule;
import com.ibm.appscan.filter.rules.include.IncludeApiRule;
import com.ibm.appscan.filter.rules.include.IncludeContextRule;
import com.ibm.appscan.filter.rules.include.IncludeDirectoryRule;
import com.ibm.appscan.filter.rules.include.IncludeFileRule;
import com.ibm.appscan.filter.rules.include.IncludeProjectRule;
import com.ibm.appscan.filter.rules.include.IncludeTraceRule;
import com.ibm.appscan.filter.rules.include.IncludeVulnerabilityRule;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class FilterReader {
    private XMLStreamReader m_reader;
    private InputStream m_stream;
    private Filter m_filter;
    private int m_behavior;
    private int m_type;
    private TraceRule m_trace;
    private Condition m_current_condition;

    public FilterReader(File f) throws FilterException {
        try {
            this.m_stream = new BufferedInputStream(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new FilterException(e);
        }
    }

    public FilterReader(InputStream stream) {
        this.m_stream = stream;
    }

    private XMLStreamReader getReader() throws FilterException {
        if (this.m_reader == null) {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            try {
                this.m_reader = factory.createXMLStreamReader(this.m_stream);
            }
            catch (XMLStreamException e) {
                throw new FilterException(e);
            }
        }
        return this.m_reader;
    }

    public void load() throws FilterException {
        this.m_filter = new Filter();
        this.load(this.m_filter);
    }

    public void load(Filter f) throws FilterException {
        this.m_filter = f;
        try {
            while (this.getReader().hasNext()) {
                int event = this.getReader().next();
                switch (event) {
                    case 1: {
                        if ("filter".equals(this.getReader().getLocalName().toLowerCase())) {
                            this.m_filter.setExcludeMatchingFindings(Boolean.parseBoolean(this.getReader().getAttributeValue(null, "exclude_matching_findings")));
                            this.m_filter.setGlobal(Boolean.parseBoolean(this.getReader().getAttributeValue(null, "global")));
                            this.m_filter.setGlobalExclusion(Boolean.parseBoolean(this.getReader().getAttributeValue(null, "global_exclusion")));
                            this.m_filter.setName(this.getReader().getAttributeValue(null, "name"));
                            this.m_filter.setVersion(this.getReader().getAttributeValue(null, "version"));
                            break;
                        }
                        if ("rule".equals(this.getReader().getLocalName().toLowerCase())) {
                            this.m_behavior = Integer.parseInt(this.getReader().getAttributeValue(null, "rule_behavior"));
                            this.m_type = Integer.parseInt(this.getReader().getAttributeValue(null, "rule_type"));
                            if (this.m_type != 9) break;
                            this.m_trace = this.m_behavior == 1 ? new IncludeTraceRule() : new ExcludeTraceRule();
                            this.m_filter.addRule(this.m_trace);
                            break;
                        }
                        if ("condition".equals(this.getReader().getLocalName().toLowerCase())) {
                            this.m_filter.addRule(this.getRuleFromType(this.getReader().getElementText()));
                            break;
                        }
                        if ("sinkfindingcondition".equals(this.getReader().getLocalName().toLowerCase())) {
                            this.m_current_condition = new SinkFindingCondition(null, null);
                            this.m_trace.addCondition(this.m_current_condition);
                            break;
                        }
                        if ("sourcefindingcondition".equals(this.getReader().getLocalName().toLowerCase())) {
                            this.m_current_condition = new SourceFindingCondition(null, null);
                            this.m_trace.addCondition(this.m_current_condition);
                            break;
                        }
                        if ("prohibitedcallsfindingcondition".equals(this.getReader().getLocalName().toLowerCase())) {
                            this.m_current_condition = new ProhibitedCallsFindingCondition(null, null);
                            this.m_trace.addCondition(this.m_current_condition);
                            break;
                        }
                        if ("requiredcallsfindingcondition".equals(this.getReader().getLocalName().toLowerCase())) {
                            this.m_current_condition = new RequiredCallsFindingCondition(null, null);
                            this.m_trace.addCondition(this.m_current_condition);
                            break;
                        }
                        if ("regextracenodecondition".equals(this.getReader().getLocalName().toLowerCase())) {
                            RegexTraceNodeCondition r = new RegexTraceNodeCondition(this.getReader().getAttributeValue(null, "regex"), this.m_current_condition);
                            this.m_current_condition.addChildCondition(r);
                            this.m_current_condition = r;
                            break;
                        }
                        if (!"propertycondition".equals(this.getReader().getLocalName().toLowerCase())) break;
                        PropertyCondition p = new PropertyCondition(this.getReader().getElementText(), this.m_current_condition);
                        this.m_current_condition.addChildCondition(p);
                        this.m_current_condition = p;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        if ("regextracenodecondition".equals(this.getReader().getLocalName().toLowerCase())) {
                            this.m_current_condition = this.m_current_condition.getParent();
                            break;
                        }
                        if (!"propertycondition".equals(this.getReader().getLocalName().toLowerCase())) break;
                        this.m_current_condition = this.m_current_condition.getParent();
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new FilterException(e);
        }
    }

    private Rule getRuleFromType(String value) {
        if (this.m_type == 1) {
            if (this.m_behavior == 1) {
                return new IncludeFileRule(value);
            }
            return new ExcludeFileRule(value);
        }
        if (this.m_type == 2) {
            if (this.m_behavior == 1) {
                return new IncludeDirectoryRule(value);
            }
            return new ExcludeDirectoryRule(value);
        }
        if (this.m_type == 3) {
            if (this.m_behavior == 1) {
                return new IncludeApiRule(value);
            }
            return new ExcludeApiRule(value);
        }
        if (this.m_type == 4) {
            if (this.m_behavior == 1) {
                return new IncludeProjectRule(value);
            }
            return new ExcludeProjectRule(value);
        }
        if (this.m_type == 5) {
            if (this.m_behavior == 1) {
                return new IncludeVulnerabilityRule(value);
            }
            return new ExcludeVulnerabilityRule(value);
        }
        if (this.m_type == 7) {
            return new ConfidenceRule(this.getConfidence(Integer.parseInt(value)));
        }
        if (this.m_type == 8) {
            return new SeverityRule(this.getSeverity(Integer.parseInt(value)));
        }
        if (this.m_type == 9) {
            return new SeverityRule(this.getSeverity(Integer.parseInt(value)));
        }
        if (this.m_type == 10) {
            if (this.m_behavior == 1) {
                return new IncludeContextRule(value);
            }
            return new ExcludeContextRule(value);
        }
        return null;
    }

    private String getConfidence(int i) {
        for (FilterEnums.CONFIDENCE_TYPE ct : FilterEnums.CONFIDENCE_TYPE.values()) {
            if (ct.toInt() != i) continue;
            return ct.toString();
        }
        return null;
    }

    private String getSeverity(int i) {
        for (FilterEnums.SEVERITY_TYPE st : FilterEnums.SEVERITY_TYPE.values()) {
            if (st.toInt() != i) continue;
            return st.toString();
        }
        return null;
    }
}

