/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.sourcepos;

import com.ibm.wala.sourcepos.InvalidRangeException;
import com.ibm.wala.sourcepos.Position;

public class Range {
    private Position start;
    private Position end;

    Range() {
        this.start = new Position();
        this.end = new Position();
    }

    Range(Position start, Position end) throws InvalidRangeException {
        if (start == null) {
            throw new InvalidRangeException(InvalidRangeException.Cause.START_UNDEFINED);
        }
        if (end == null) {
            throw new InvalidRangeException(InvalidRangeException.Cause.END_UNDEFINED);
        }
        if (end.isBefore(start)) {
            throw new InvalidRangeException(InvalidRangeException.Cause.END_BEFORE_START);
        }
        if (start.isUndefined() && !end.isUndefined()) {
            throw new InvalidRangeException(InvalidRangeException.Cause.START_UNDEFINED);
        }
        if (!start.isUndefined() && end.isUndefined()) {
            throw new InvalidRangeException(InvalidRangeException.Cause.END_UNDEFINED);
        }
        this.start = start;
        this.end = end;
    }

    boolean isUndefined() {
        return this.start.isUndefined();
    }

    boolean isWithin(Range r) {
        return r != null && !this.start.isBefore(r.start) && !r.end.isBefore(this.end);
    }

    int[] toArray() {
        return new int[]{this.start.getLine(), this.start.getColumn(), this.end.getLine(), this.end.getColumn()};
    }

    public Position getStartPosition() {
        return this.start;
    }

    public Position getEndPosition() {
        return this.end;
    }

    public String toString() {
        return this.start.isUndefined() ? "<undefined>" : "(" + this.getStartPosition() + ") - (" + this.getEndPosition() + ")";
    }
}

