/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dataflow.graph;

import com.ibm.wala.fixpoint.BitVectorVariable;
import com.ibm.wala.fixpoint.UnaryOperator;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;

public class BitVectorFilter
extends UnaryOperator<BitVectorVariable> {
    private final BitVectorIntSet mask;

    public BitVectorFilter(BitVector mask) {
        if (mask == null) {
            throw new IllegalArgumentException("null mask");
        }
        this.mask = new BitVectorIntSet(mask);
    }

    @Override
    public byte evaluate(BitVectorVariable lhs, BitVectorVariable rhs) throws IllegalArgumentException {
        if (rhs == null) {
            throw new IllegalArgumentException("rhs == null");
        }
        BitVectorVariable U = new BitVectorVariable();
        U.copyState(lhs);
        IntSet r = rhs.getValue();
        if (r == null) {
            return 0;
        }
        BitVectorIntSet rr = new BitVectorIntSet();
        rr.addAll(r);
        rr.removeAll(this.mask);
        System.err.println("adding " + rr + " to " + lhs);
        U.addAll(rr.getBitVector());
        if (!lhs.sameValue(U)) {
            lhs.copyState(U);
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "U - " + this.mask;
    }

    @Override
    public int hashCode() {
        return 29 * this.mask.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BitVectorFilter) {
            BitVectorFilter other = (BitVectorFilter)o;
            return this.mask.equals(other.mask);
        }
        return false;
    }
}

