/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.FifoQueue;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class FifoQueueNoDuplicates<T>
extends FifoQueue<T> {
    private final Set<T> wasInQueue = HashSetFactory.make();

    public Iterator<T> getPushedNodes() {
        return this.wasInQueue.iterator();
    }

    @Override
    public void push(T element) {
        if (this.wasInQueue.add(element)) {
            this.inQueue.add(element);
            this.qItems.add(element);
        }
    }

    @Override
    public void push(Iterator<? extends T> elements) throws IllegalArgumentException {
        if (elements == null) {
            throw new IllegalArgumentException("elements == null");
        }
        while (elements.hasNext()) {
            T element = elements.next();
            if (!this.wasInQueue.add(element)) continue;
            this.inQueue.add(element);
            this.qItems.add(element);
        }
    }

    public boolean everContained(T element) {
        return this.wasInQueue.contains(element);
    }

    public Set<T> queuedSet() {
        return Collections.unmodifiableSet(this.wasInQueue);
    }
}

