/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.jsp;

import com.ibm.appscan.frameworks.analyzers.javaee.jsp.BeanDirectAccess;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.BeanElAccess;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.ElAccessFromExpression;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.ElAccessFromExpressionWithPath;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.RequestParamAccess;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.UnhandledELException;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.ITagLibDefInfo;
import com.ibm.appscan.frameworks.specinfo.ArgToOrigCallExpr;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class ElAccess {
    static final Logger logger = TaintLogger.i().getLogger();
    private static Set<String> elImplicitObjects = new LinkedHashSet<String>();
    private final IMethod elEvaluateCaller;
    private final CallSiteReference elEvalCallSite;
    private final int srcLine;

    public String toString() {
        return "ElAccess [callSiteReference=" + this.elEvalCallSite + ", elEvaluateCall=" + this.elEvaluateCaller + "]";
    }

    protected ElAccess(IMethod elEvaluateCaller, CallSiteReference callSiteReference, int srcLine) {
        this.elEvaluateCaller = elEvaluateCaller;
        this.elEvalCallSite = callSiteReference;
        this.srcLine = srcLine;
    }

    public static ElAccess getElAccess(IClassHierarchy cha, String elExpression, IMethod elEvaluateCaller, CallSiteReference elEvalCallSite, int srcLine, Set<ITagLibDefInfo.ReachingDef> reachingNames) throws UnhandledELException {
        List<String> accessPath = ElAccess.getAccessPath(elExpression);
        if (accessPath == null || accessPath.size() == 0) {
            throw new UnhandledELException();
        }
        ElAccess elAccessFromReachingNames = ElAccess.getELAccessFromReachingNames(elExpression, accessPath, reachingNames, elEvaluateCaller, elEvalCallSite, srcLine, cha);
        if (elAccessFromReachingNames != null) {
            return elAccessFromReachingNames;
        }
        String accessStart = accessPath.get(0);
        if (accessPath.size() == 1 && !elImplicitObjects.contains(accessStart)) {
            return new BeanDirectAccess(accessStart, elEvaluateCaller, elEvalCallSite, srcLine);
        }
        if (accessStart.equals(ELImplicitObject.param.name()) || accessStart.equals(ELImplicitObject.paramValues.name())) {
            return new RequestParamAccess(cha, accessPath, elEvaluateCaller, elEvalCallSite, srcLine);
        }
        if (!elImplicitObjects.contains(accessStart) || accessStart.equals(ELImplicitObject.applicationScope.name()) || accessStart.equals(ELImplicitObject.sessionScope.name()) || accessStart.equals(ELImplicitObject.requestScope.name()) || accessStart.equals(ELImplicitObject.pageScope.name())) {
            return new BeanElAccess(cha, accessPath, elEvaluateCaller, elEvalCallSite, srcLine);
        }
        throw new UnhandledELException();
    }

    private static ElAccess getELAccessFromReachingNames(String elExpression, List<String> accessPath, Set<ITagLibDefInfo.ReachingDef> reachingNames, IMethod elEvaluateCaller, CallSiteReference elEvalCallSite, int srcLine, IClassHierarchy cha) {
        HashSet possibleAccesses = HashSetFactory.make();
        for (ITagLibDefInfo.ReachingDef reaching : reachingNames) {
            String name = reaching.getName();
            if (name.equals(elExpression)) {
                possibleAccesses.add(new ElAccessFromExpression(elEvaluateCaller, elEvalCallSite, srcLine, reaching.getExpr(), reaching.getGlobalDecls()));
                continue;
            }
            if (!name.equals(accessPath.get(0))) continue;
            possibleAccesses.add(new ElAccessFromExpressionWithPath(elEvaluateCaller, elEvalCallSite, srcLine, reaching.getExpr(), reaching.getGlobalDecls(), accessPath, cha));
        }
        if (possibleAccesses.isEmpty()) {
            return null;
        }
        assert (possibleAccesses.size() == 1) : "need to handle multiple possible accesses";
        return (ElAccess)possibleAccesses.iterator().next();
    }

    private static List<String> getAlternativeAccessPath(String expression, String varName, String begin, String end, String quote) {
        Pattern pattern = Pattern.compile(begin + varName + "(\\[" + quote + varName + quote + "\\]){1}" + end);
        Matcher m = pattern.matcher(expression);
        if (!m.matches()) {
            return null;
        }
        String txt = expression.subSequence(2, expression.length() - 1).toString();
        ArrayList<String> paths = new ArrayList<String>();
        int i = txt.indexOf("[" + quote);
        if (i != -1) {
            paths.add(txt.substring(0, i).trim());
            txt = txt.substring(i + 2);
            i = txt.indexOf(quote + "]");
            if (i != -1) {
                paths.add(txt.substring(0, i).trim());
                return paths;
            }
        }
        return null;
    }

    private static List<String> getAccessPath(String elExpression) {
        String varNameRegExp = "\\s*[A-Za-z_$][A-Za-z0-9_$]*\\s*";
        String ELExpressionStart = "\\$\\{";
        String ELExpressionEnd = "\\}";
        Pattern elAccessPattern = Pattern.compile(ELExpressionStart + varNameRegExp + "(\\." + varNameRegExp + ")*" + ELExpressionEnd);
        Matcher m = elAccessPattern.matcher(elExpression);
        if (!m.matches()) {
            List<String> alt = ElAccess.getAlternativeAccessPath(elExpression, varNameRegExp, ELExpressionStart, ELExpressionEnd, "\"");
            if (alt != null) {
                return alt;
            }
            alt = ElAccess.getAlternativeAccessPath(elExpression, varNameRegExp, ELExpressionStart, ELExpressionEnd, "'");
            if (alt != null) {
                return alt;
            }
            return null;
        }
        String modifiedELExpression = elExpression.subSequence(2, elExpression.length() - 1).toString();
        ArrayList<String> accessPath = new ArrayList<String>();
        int indexOfAccessModifier = modifiedELExpression.indexOf(".");
        while (indexOfAccessModifier != -1) {
            accessPath.add(modifiedELExpression.substring(0, indexOfAccessModifier).trim());
            modifiedELExpression = modifiedELExpression.substring(indexOfAccessModifier + 1);
            indexOfAccessModifier = modifiedELExpression.indexOf(".");
        }
        accessPath.add(modifiedELExpression.trim());
        return accessPath;
    }

    public abstract NonVoidSyntheticExpr getSyntheticExpr();

    public CallSiteReplacement getCallSiteReplacement() {
        NonVoidSyntheticExpr syntheticExpr = this.getSyntheticExpr();
        AssignmentExpr replacementAssignment = AssignmentExpr.make(null, (AssignableSyntheticExpr)ArgToOrigCallExpr.make((int)-1), (NonVoidSyntheticExpr)syntheticExpr);
        IClassHierarchy cha = this.elEvaluateCaller.getClassHierarchy();
        IMethod invokedMethod = cha.resolveMethod(this.elEvalCallSite.getDeclaredTarget());
        assert (invokedMethod != null);
        return CallSiteReplacement.make((String)WalaUtil.method2ResolvedVDBSignature(invokedMethod), (int)this.elEvalCallSite.getProgramCounter(), (int)this.srcLine, (SyntheticExpr)replacementAssignment);
    }

    public IMethod getCallerMethod() {
        return this.elEvaluateCaller;
    }

    public abstract Set<BeanDecl> getGlobalBeanDecls();

    static {
        for (ELImplicitObject io : ELImplicitObject.values()) {
            elImplicitObjects.add(io.name());
        }
    }

    public static enum ELImplicitObject {
        pageContext,
        pageScope,
        requestScope,
        sessionScope,
        applicationScope,
        param,
        paramValues,
        header,
        cookie,
        initParam;


        public String toString() {
            return this.name();
        }
    }
}

