/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.analyzers.generic.CodeProcessor;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsEntrypointUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Set;

abstract class AbstractStrutsCodeVisitor
implements CodeProcessor.ICodeVisitor {
    protected final IClassHierarchy cha;
    protected final Set<IClass> classesOfInterest = HashSetFactory.make();
    protected final Set<IMethod> methodsOfInterest = HashSetFactory.make();

    protected AbstractStrutsCodeVisitor(IClassHierarchy cha, Set<String> actionClassNames, Set<String> exceptionHandlerClassNames) {
        this.cha = cha;
        this.determineMethodsOfInterest(actionClassNames, exceptionHandlerClassNames);
    }

    private void determineMethodsOfInterest(Set<String> actionClassNames, Set<String> exceptionHandlerClassNames) {
        Set<String> entrypointSignatures;
        IClass klass;
        for (String actionClassName : actionClassNames) {
            klass = this.cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(actionClassName));
            if (klass == null) continue;
            entrypointSignatures = StrutsEntrypointUtil.getActionEntrypointSignatures(klass);
            this.updateMethodsAndClassesOfInterest(entrypointSignatures);
        }
        for (String excHandlerClassName : exceptionHandlerClassNames) {
            klass = this.cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(excHandlerClassName));
            if (klass == null) continue;
            entrypointSignatures = StrutsEntrypointUtil.getExcHandlerEntrypointSignatures(klass);
            this.updateMethodsAndClassesOfInterest(entrypointSignatures);
        }
    }

    private void updateMethodsAndClassesOfInterest(Set<String> entrypointSignatures) {
        for (String sig : entrypointSignatures) {
            MethodReference methodRef = StringStuff.makeMethodReference((String)sig);
            IMethod entryMethod = this.cha.resolveMethod(methodRef);
            if (entryMethod == null) continue;
            this.methodsOfInterest.add(entryMethod);
            this.classesOfInterest.add(entryMethod.getDeclaringClass());
        }
    }

    public boolean accepts(IClassLoader loader) {
        return WalaUtil.isApplicationClassLoader(loader, this.cha);
    }

    public boolean accepts(IClass c) {
        return this.classesOfInterest.contains(c);
    }

    public boolean accepts(IMethod m) {
        return this.methodsOfInterest.contains(m);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classesOfInterest == null ? 0 : this.classesOfInterest.hashCode());
        result = 31 * result + (this.methodsOfInterest == null ? 0 : this.methodsOfInterest.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStrutsCodeVisitor other = (AbstractStrutsCodeVisitor)obj;
        if (this.classesOfInterest == null ? other.classesOfInterest != null : !this.classesOfInterest.equals(other.classesOfInterest)) {
            return false;
        }
        return !(this.methodsOfInterest == null ? other.methodsOfInterest != null : !this.methodsOfInterest.equals(other.methodsOfInterest));
    }
}

