/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.util;

import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.Property;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BeanDeclUtil {
    private static final Logger logger = TaintLogger.i().getLogger();

    public static Set<BeanDecl> mergeDecls(Set<BeanDecl> b1, Set<BeanDecl> b2, IClassHierarchy cha) {
        if (b1 == null) {
            throw new IllegalArgumentException("b1 is null");
        }
        if (b2 == null) {
            throw new IllegalArgumentException("b2 is null");
        }
        HashMap declName2Decls = HashMapFactory.make();
        for (BeanDecl decl : b1) {
            MapUtil.findOrCreateList((Map)declName2Decls, (Object)decl.getId()).add(decl);
        }
        for (BeanDecl decl : b2) {
            MapUtil.findOrCreateList((Map)declName2Decls, (Object)decl.getId()).add(decl);
        }
        HashSet result = HashSetFactory.make();
        for (String declName : declName2Decls.keySet()) {
            BeanDecl newBeanDecl;
            ArrayList<BeanDecl> decls = new ArrayList<BeanDecl>(new LinkedHashSet((Collection)declName2Decls.get(declName)));
            if (decls.size() == 1) {
                result.add(decls.get(0));
                continue;
            }
            BeanDecl firstDecl = (BeanDecl)decls.get(0);
            BeanDecl.BeanLifespan lifespan = firstDecl.getLifespan();
            HashSet properties = HashSetFactory.make();
            properties.addAll(firstDecl.getProperties());
            String dynaBeanSupertypeName = firstDecl.getDynaBeanSupertypeName();
            for (int i = 1; i < decls.size(); ++i) {
                BeanDecl curDecl = (BeanDecl)decls.get(i);
                assert (curDecl.getLifespan().equals((Object)lifespan)) : "beans with same name " + declName + " but differing lifespans " + lifespan + " and " + curDecl.getLifespan();
                BeanDeclUtil.mergeProperties(properties, curDecl.getProperties());
                assert (dynaBeanSupertypeName == null && curDecl.getDynaBeanSupertypeName() == null || dynaBeanSupertypeName.equals(curDecl.getDynaBeanSupertypeName()));
            }
            IClass klass = BeanDeclUtil.moreSpecific(decls, cha);
            if (!properties.isEmpty()) {
                assert (klass.getReference().equals((Object)TypeReference.JavaLangObject));
                newBeanDecl = BeanDecl.makeWithProperties((String)declName, (BeanDecl.BeanLifespan)lifespan, (Collection)properties, (String)dynaBeanSupertypeName);
            } else {
                newBeanDecl = BeanDecl.makeWithConcreteType((String)declName, (String)VDBJavaUtil.jvmToVDBType(klass.getName().toString()), (BeanDecl.BeanLifespan)lifespan);
            }
            result.add(newBeanDecl);
        }
        return result;
    }

    private static void mergeProperties(Collection<Property> properties, Collection<Property> addProperties) {
        for (Property p : addProperties) {
            if (properties.contains(p)) continue;
            for (Property ps : properties) {
                if (!ps.getName().equals(p.getName())) continue;
                logger.warn((Object)("bean property with same name " + ps.getName() + " but differnt type " + p + " and " + ps));
            }
            properties.add(p);
        }
    }

    private static IClass moreSpecific(List<BeanDecl> decls, IClassHierarchy cha) {
        IClass finalKlass = null;
        for (BeanDecl curDecl : decls) {
            finalKlass = BeanDeclUtil.resolveName(curDecl.getType(), cha);
            for (BeanDecl otherDecl : decls) {
                if (otherDecl.equals((Object)curDecl) || cha.isAssignableFrom(BeanDeclUtil.resolveName(otherDecl.getType(), cha), finalKlass)) continue;
                finalKlass = null;
                break;
            }
            if (finalKlass == null) continue;
            break;
        }
        if (finalKlass == null) {
            finalKlass = cha.lookupClass(TypeReference.JavaLangObject);
        }
        return finalKlass;
    }

    private static IClass resolveName(String type, IClassHierarchy cha) {
        IClass curKlass;
        if (type == null) {
            curKlass = cha.lookupClass(TypeReference.JavaLangObject);
        } else {
            curKlass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)type));
            if (curKlass == null) {
                curKlass = cha.lookupClass(TypeReference.JavaLangObject);
            }
        }
        return curKlass;
    }
}

