/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice;

import com.hcl.irx.slice.Bucket;
import com.hcl.irx.slice.IrxMinorCacheManagement;
import com.hcl.irx.slice.Messages;
import com.hcl.irx.slice.SliceIrGenerator;
import com.hcl.irx.slice.SliceLogManager;
import com.hcl.irx.slice.Slicer;
import com.hcl.irx.slice.wafl.JavaWaflGen;
import com.hcl.irx.slice.xml.ScanXml;
import com.hcl.irx.slice.xml.TargetInfoSliceXml;
import com.hcl.irx.slice.xml.TargetsSliceXml;
import com.hcl.irx.stage.Stager;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.utils.ArchiveUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.xml.XmlFileWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;

public class AppScan {
    private static String SLICE_ZIP = "slice.zip";
    private long m_ir_gen_time;
    private IScanTargetMinProxy m_proxy;

    public void prepare(Bucket bucket, JavaWaflGen waflgen, Stager stager, IScanTargetMinProxy proxy) throws AppScanException, IOException, InterruptedException {
        boolean ipva_found;
        this.m_proxy = proxy;
        File slice_irx = new File(bucket.getBucketDir(), SLICE_ZIP);
        try {
            ArrayList<XmlFileWriter> xml_files = new ArrayList<XmlFileWriter>();
            xml_files.add(new ScanXml(bucket.getBucketDir()));
            xml_files.add(new TargetsSliceXml(bucket.getBucketDir()));
            xml_files.add(new TargetInfoSliceXml(bucket.getBucketDir(), proxy, bucket, stager));
            for (XmlFileWriter xml : xml_files) {
                try {
                    xml.saveXml();
                }
                catch (TransformerException e) {
                    throw new AppScanException((Throwable)e);
                }
                catch (ParserConfigurationException e) {
                    throw new AppScanException((Throwable)e);
                }
            }
            new TargetInfoSliceXml(bucket.getBucketDir(), proxy, bucket, stager).saveXml();
            IrxMinorCacheManagement.copyIrxMinorToSliceDir(bucket, bucket.getBucketDir(), slice_irx);
            if (slice_irx.exists()) {
                ArchiveUtil.unzip((File)slice_irx, (File)bucket.getBucketDir(), (String[])new String[0]);
                slice_irx.delete();
                if (Slicer.getIPVA(bucket.getBucketDir()) != null) {
                    if (this.m_proxy != null) {
                        this.m_proxy.getLogManager().log(new Message(1, Messages.getMessage("retrieve.from.cache", bucket.getBucketDir().getAbsolutePath())));
                    }
                    return;
                }
                this.m_proxy.getLogManager().log(new Message(1, Messages.getMessage("slice.cache.poisoned", bucket.getId())));
            }
        }
        catch (Exception e) {
            this.m_proxy.getLogManager().log(new Message(1, Messages.getMessage("slice.cache.poisoned", bucket.getId())));
            FileUtils.cleanDirectory((File)bucket.getBucketDir());
        }
        boolean error = false;
        SliceIrGenerator ir_gen = new SliceIrGenerator(new SaveLocation(bucket.getBucketDir()), bucket.getBucketDir());
        long ir_gen_start = System.currentTimeMillis();
        try {
            ir_gen.addEnvironmentVariable("SLICER_WAFL_PATH", waflgen.getWaflFileForBucket(bucket, stager).getAbsolutePath());
            ir_gen.addEnvironmentVariable("USE_SLICER", "true");
            ir_gen.run();
        }
        catch (Exception e) {
            error = true;
        }
        this.m_ir_gen_time = System.currentTimeMillis() - ir_gen_start;
        boolean bl = ipva_found = Slicer.getIPVA(bucket.getBucketDir()) != null;
        if (!ipva_found) {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("slice.fail.rerun.balnk.wafl", bucket.getBucketDir().getAbsolutePath())));
            SliceLogManager log_file = new SliceLogManager(new File(proxy.getScanHome(), "logs"), "slice.prepare.err.log");
            log_file.log(new Message(1, Messages.getMessage("slice.fail.rerun.balnk.wafl", bucket.getBucketDir().getAbsolutePath())));
            Files.write(Paths.get(bucket.getBucketDir().getAbsolutePath(), "wafl.fail.log"), Messages.getMessage("wafl.gen.fail", new Object[0]).getBytes(), new OpenOption[0]);
            Files.write(Paths.get(bucket.getBucketDir().getAbsolutePath(), "blank_frameworks.wafl"), JavaWaflGen.BLANK_WAFL_CONTENTS.getBytes(), new OpenOption[0]);
            try {
                ir_gen.run();
            }
            catch (Exception e) {
                error = true;
            }
        }
        if (error) {
            String dir = bucket.getBucketDir().getAbsolutePath();
            if (dir.startsWith(this.m_proxy.getScanHome().getAbsolutePath())) {
                dir = dir.substring(this.m_proxy.getScanHome().getAbsolutePath().length() + 1);
            }
            this.m_proxy.getLogManager().log(new Message(1, Messages.getMessage("error.processing.slice", bucket.getId(), dir)));
        }
        boolean bl2 = ipva_found = Slicer.getIPVA(bucket.getBucketDir()) != null;
        if (ipva_found) {
            if (SystemUtil.useCacheForSlicer()) {
                this.createSliceIrx(bucket);
            }
        } else {
            this.m_proxy.getLogManager().log(new Message(1, Messages.getMessage("slice.ipva.missing", bucket.getId())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSliceIrx(Bucket bucket) throws IOException, AppScanException {
        final Path bucket_root = Paths.get(bucket.getBucketDir().getAbsolutePath(), new String[0]);
        final File slice_irx = new File(bucket.getBucketDir(), SLICE_ZIP);
        final ZipOutputStream out = new ZipOutputStream(new FileOutputStream(slice_irx));
        try {
            Files.walkFileTree(bucket_root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                    if (!file.getFileName().toString().equals(slice_irx.getName())) {
                        Path slice_entry = bucket_root.relativize(file);
                        out.putNextEntry(new ZipEntry(slice_entry.toString()));
                        byte[] bytes = Files.readAllBytes(file);
                        out.write(bytes, 0, bytes.length);
                        out.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        finally {
            IOUtil.close((Closeable)out);
        }
        try {
            IrxMinorCacheManagement.insertIrxMinorToCache(bucket, bucket.getBucketDir(), slice_irx);
            slice_irx.delete();
            if (this.m_proxy != null) {
                this.m_proxy.getLogManager().log(new Message(1, Messages.getMessage("not.retrieve.from.cache", bucket.getBucketDir().getAbsolutePath())));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new AppScanException((Throwable)e);
        }
    }

    public long getIrGenTime() {
        return this.m_ir_gen_time;
    }
}

