/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.http;

import com.hcl.appscan.sdk.http.DefaultHttpProgress;
import com.hcl.appscan.sdk.http.HttpPart;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.http.IHttpProgress;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

public class HttpClient {
    private String m_boundary;
    private long m_totalMultipartLength;
    private long m_uploadedMultipartLength;
    private static final String CR_LF = "\r\n";
    private static final String TWO_HYPHENS = "--";
    private IHttpProgress m_progressAdapter;
    private Proxy m_proxy;

    public HttpClient(IHttpProgress progressAdapter, Proxy proxy) {
        this.m_progressAdapter = progressAdapter;
        this.m_proxy = proxy;
    }

    public HttpClient() {
        this(new DefaultHttpProgress(), Proxy.NO_PROXY);
    }

    public HttpClient(Proxy proxy) {
        this(new DefaultHttpProgress(), proxy);
    }

    public HttpClient(IHttpProgress progressAdapter) {
        this(progressAdapter, Proxy.NO_PROXY);
    }

    public HttpResponse get(String url, Map<String, String> headerProperties, String body) throws IOException {
        return this.makeRequest(Method.GET, url, headerProperties, body);
    }

    public HttpResponse post(String url, Map<String, String> headerProperties, String body) throws IOException {
        if (body == null) {
            body = "";
        }
        return this.makeRequest(Method.POST, url, headerProperties, body);
    }

    public HttpResponse put(String url, Map<String, String> headerProperties, String body) throws IOException {
        return this.makeRequest(Method.PUT, url, headerProperties, body);
    }

    public HttpResponse delete(String url, Map<String, String> headerProperties, String body) throws IOException {
        return this.makeRequest(Method.DELETE, url, headerProperties, body);
    }

    public HttpResponse getForm(String url, Map<String, String> headerProperties, Map<String, String> params) throws IOException {
        String body = this.buildQueryString(params);
        return this.get(url, headerProperties, body);
    }

    public HttpResponse postForm(String url, Map<String, String> headerProperties, Map<String, String> params) throws IOException {
        String body = this.buildQueryString(params);
        return this.post(url, headerProperties, body);
    }

    public HttpResponse putForm(String url, Map<String, String> headerProperties, Map<String, String> params) throws IOException {
        String body = this.buildQueryString(params);
        return this.put(url, headerProperties, body);
    }

    public HttpResponse deleteForm(String url, Map<String, String> headerProperties, Map<String, String> params) throws IOException {
        String body = this.buildQueryString(params);
        return this.delete(url, headerProperties, body);
    }

    public HttpResponse postMultipart(String url, Map<String, String> headerProperties, List<HttpPart> parts) throws IOException {
        this.m_boundary = "*****" + Long.toString(System.currentTimeMillis()) + "*****";
        headerProperties.put("Content-Type", "multipart/form-data; boundary=" + this.m_boundary);
        return this.makeMultipartRequest(Method.POST, url, headerProperties, parts);
    }

    private HttpResponse makeMultipartRequest(Method method, String url, Map<String, String> headerProperties, List<HttpPart> parts) throws IOException {
        HttpURLConnection conn = this.makeConnection(url, method, headerProperties);
        DataOutputStream outputStream = null;
        conn.setChunkedStreamingMode(1024);
        if (parts != null && !parts.isEmpty()) {
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            outputStream = new DataOutputStream(conn.getOutputStream());
            this.m_uploadedMultipartLength = 0L;
            this.m_totalMultipartLength = this.getTotalPartsLength(parts);
            this.updateProgress();
            for (HttpPart part : parts) {
                int bytesRead;
                StringBuilder builder = new StringBuilder();
                builder.append(TWO_HYPHENS + this.m_boundary + CR_LF);
                Map<String, String> partHeaders = part.getPartHeaders();
                for (String header : partHeaders.keySet()) {
                    builder.append(header + ": " + partHeaders.get(header) + CR_LF);
                }
                outputStream.writeBytes(builder.toString() + CR_LF);
                outputStream.flush();
                byte[] buffer = new byte[1024];
                while ((bytesRead = part.getPartBodyInputStream().read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    this.m_uploadedMultipartLength += (long)bytesRead;
                    this.updateProgress();
                }
                outputStream.writeBytes(CR_LF);
                outputStream.flush();
            }
            outputStream.writeBytes(TWO_HYPHENS + this.m_boundary + TWO_HYPHENS + CR_LF);
            outputStream.flush();
            this.updateProgress();
        }
        outputStream.flush();
        outputStream.close();
        this.m_progressAdapter.endProgress();
        return new HttpResponse(conn);
    }

    private HttpResponse makeRequest(Method method, String url, Map<String, String> headerProperties, String payload) throws IOException {
        HttpURLConnection conn = this.makeConnection(url, method, headerProperties);
        if (payload != null) {
            conn.setDoOutput(true);
            DataOutputStream writer = new DataOutputStream(conn.getOutputStream());
            writer.writeBytes(payload);
            writer.flush();
            writer.close();
        }
        return new HttpResponse(conn);
    }

    private HttpURLConnection makeConnection(String url, Method method, Map<String, String> headerProperties) throws IOException {
        URL requestURL = new URL(url);
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)requestURL.openConnection(this.m_proxy);
        conn.setRequestMethod(method.name());
        conn.setReadTimeout(0);
        if (headerProperties != null) {
            for (String key : headerProperties.keySet()) {
                conn.setRequestProperty(key, headerProperties.get(key));
            }
        }
        return conn;
    }

    private long getTotalPartsLength(List<HttpPart> parts) {
        long totalSize = 0L;
        for (HttpPart part : parts) {
            totalSize += part.getPartLength();
        }
        return totalSize;
    }

    private void updateProgress() {
        int progress = (int)((float)this.m_uploadedMultipartLength / (float)this.m_totalMultipartLength * 100.0f);
        this.m_progressAdapter.setProgress(progress);
    }

    private String buildQueryString(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        if (params == null) {
            return "";
        }
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(key, "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(value, "UTF-8"));
        }
        return result.toString();
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

