/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.ase;

import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.error.InvalidTargetException;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.DefaultProgress;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.results.ASEResultsProvider;
import com.hcl.appscan.sdk.results.IResultsProvider;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.scanners.ASoCScan;
import com.hcl.appscan.sdk.scanners.ScanConstants;
import java.io.Serializable;
import java.util.Map;

public class ASEScan
extends ASoCScan
implements ScanConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String REPORT_FORMAT = "json";

    public ASEScan(Map<String, String> properties, IScanServiceProvider provider) {
        super(properties, new DefaultProgress(), provider);
    }

    public ASEScan(Map<String, String> properties, IProgress progress, IScanServiceProvider provider) {
        super(properties, progress, provider);
    }

    @Override
    public void run() throws ScannerException, InvalidTargetException {
        String id = this.getServiceProvider().createAndExecuteScan(null, this.getProperties());
        this.setScanId(id);
        if (this.getScanId() == null) {
            throw new ScannerException(Messages.getMessage("error.creating.scan", new Object[0]));
        }
    }

    @Override
    public String getType() {
        return "Appscan Enterprise Dynamic Analyzer";
    }

    @Override
    public IResultsProvider getResultsProvider() {
        ASEResultsProvider provider = new ASEResultsProvider(this.getScanId(), this.getType(), this.getServiceProvider(), this.getProgress(), this.getName());
        provider.setReportFormat(this.getReportFormat());
        return provider;
    }

    @Override
    public String getReportFormat() {
        return REPORT_FORMAT;
    }
}

