/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.vs.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.discovery.vs.Messages;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class DepsJsonReader {
    private File m_depsJson;
    private List<String> m_projectAssemblies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DepsJsonReader(File depsJson) throws IOException, JSONException {
        this.m_depsJson = depsJson;
        if (this.m_depsJson.exists() && this.m_depsJson.getName().endsWith(".deps.json")) {
            this.m_projectAssemblies = new ArrayList<String>();
            try (FileReader reader = new FileReader(this.m_depsJson);){
                JSONObject json = (JSONObject)JSON.parse((Reader)reader);
                JSONObject libraries = (JSONObject)json.get("libraries");
                for (Object key : libraries.keySet()) {
                    JSONObject lib = (JSONObject)libraries.get(key);
                    if (!lib.getString("type").equalsIgnoreCase("project")) continue;
                    this.addAssemblyToList(key.toString());
                }
            }
        } else {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("deps.json.invalid", this.m_depsJson.getAbsolutePath())));
        }
    }

    public List<String> getProjectAssemblies() {
        return this.m_projectAssemblies;
    }

    private void addAssemblyToList(String name) {
        name = name.substring(0, name.indexOf("/"));
        File assembly = new File(this.m_depsJson.getParentFile(), name + ".dll");
        if (assembly.isFile()) {
            this.m_projectAssemblies.add(assembly.getAbsolutePath());
        } else {
            assembly = new File(this.m_depsJson.getParentFile(), name + ".exe");
            if (assembly.isFile()) {
                this.m_projectAssemblies.add(assembly.getAbsolutePath());
            }
        }
    }
}

