/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.m2lstr;

import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.samso.m2lstr.BinEncoder;
import com.ibm.wala.samso.m2lstr.IBoolean;
import com.ibm.wala.samso.m2lstr.IDeclaration;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.IFormulaDeclaration;
import com.ibm.wala.samso.m2lstr.IFormulaFactory;
import com.ibm.wala.samso.m2lstr.IPosition;
import com.ibm.wala.samso.m2lstr.IPositionFunction;
import com.ibm.wala.samso.m2lstr.IPositionSet;
import com.ibm.wala.samso.m2lstr.IPositionSetFunction;
import com.ibm.wala.samso.m2lstr.IPositionSetTerm;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.IPositionSetVariableDefinition;
import com.ibm.wala.samso.m2lstr.IPositionTerm;
import com.ibm.wala.samso.m2lstr.IPositionVariable;
import com.ibm.wala.samso.m2lstr.IPositionVariableDefinition;
import com.ibm.wala.samso.m2lstr.IPredicate;
import com.ibm.wala.samso.m2lstr.IPredicateDeclaration;
import com.ibm.wala.samso.m2lstr.ITerm;
import com.ibm.wala.samso.m2lstr.IVariable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractExtendedFormulaFactory
implements IExtendedFormulaFactory {
    private final IFormulaFactory base;

    public AbstractExtendedFormulaFactory(IFormulaFactory base) {
        this.base = base;
    }

    @Override
    public List<IDeclaration> prologue() {
        return this.base.prologue();
    }

    @Override
    public IFormula createAnd(IFormula f1, IFormula f2) {
        return this.base.createAnd(f1, f2);
    }

    @Override
    public IPositionTerm createApplyPositionFunction(IPositionFunction func, ITerm ... args) {
        return this.base.createApplyPositionFunction(func, args);
    }

    @Override
    public IPositionSetTerm createApplyPositionSetFunction(IPositionSetFunction func, ITerm ... args) {
        return this.base.createApplyPositionSetFunction(func, args);
    }

    @Override
    public IFormula createApplyPredicate(IPredicate pred, ITerm ... args) {
        return this.base.createApplyPredicate(pred, args);
    }

    @Override
    public IFormula createExists(IPositionVariable v, IFormula body) {
        return this.base.createExists(v, body);
    }

    @Override
    public IFormula createExistsWhere(IPositionVariable v, IFormula where, IFormula body) {
        return this.base.createExistsWhere(v, where, body);
    }

    @Override
    public IFormula createForall(IPositionVariable v, IFormula body) {
        return this.base.createForall(v, body);
    }

    @Override
    public IFormula createForallWhere(IPositionVariable v, IFormula where, IFormula body) {
        return this.base.createForallWhere(v, where, body);
    }

    @Override
    public IFormula createExists(IPositionSetVariable v, IFormula body) {
        return this.base.createExists(v, body);
    }

    @Override
    public IFormula createExistsWhere(IPositionSetVariable v, IFormula where, IFormula body) {
        return this.base.createExistsWhere(v, where, body);
    }

    @Override
    public IFormula createForall(IPositionSetVariable v, IFormula body) {
        return this.base.createForall(v, body);
    }

    @Override
    public IFormula createForallWhere(IPositionSetVariable v, IFormula where, IFormula body) {
        return this.base.createForallWhere(v, where, body);
    }

    @Override
    public IFormula createIsChar(char ch, IPositionTerm pos) {
        return this.base.createIsChar(ch, pos);
    }

    @Override
    public IPositionTerm createLastPosition() {
        return this.base.createLastPosition();
    }

    @Override
    public IPositionFunction createMaxFunction() {
        return this.base.createMaxFunction();
    }

    @Override
    public IPositionFunction createMinFunction() {
        return this.base.createMinFunction();
    }

    @Override
    public IPositionTerm createPositionMinus(IPositionTerm pos, int n) {
        return this.base.createPositionMinus(pos, n);
    }

    @Override
    public IFormula createNot(IFormula body) {
        return this.base.createNot(body);
    }

    @Override
    public IFormula createOr(IFormula f1, IFormula f2) {
        return this.base.createOr(f1, f2);
    }

    @Override
    public IPositionTerm createPositionPlus(IPositionTerm pos, int n) {
        return this.base.createPositionPlus(pos, n);
    }

    @Override
    public IPosition createPosition(int pos) {
        return this.base.createPosition(pos);
    }

    @Override
    public IPositionFunction createPositionFunction(String name, int arity) {
        return this.base.createPositionFunction(name, arity);
    }

    @Override
    public IPositionSet createPositionSet(IPositionTerm ... pos) {
        return this.base.createPositionSet(pos);
    }

    @Override
    public IPositionSetFunction createPositionSetFunction(String name, int arity) {
        return this.base.createPositionSetFunction(name, arity);
    }

    @Override
    public IPositionSetVariable createPositionSetVariable() {
        return this.base.createPositionSetVariable();
    }

    @Override
    public IPositionVariable createPositionVariable() {
        return this.base.createPositionVariable();
    }

    @Override
    public IPositionSetVariable createPositionSetVariable(String name) {
        return this.base.createPositionSetVariable(name);
    }

    @Override
    public IPositionVariable createPositionVariable(String name) {
        return this.base.createPositionVariable(name);
    }

    @Override
    public IPredicate createPredicate(String name, int arity, IPredicate.ArgType[] argTypes) {
        return this.base.createPredicate(name, arity, argTypes);
    }

    @Override
    public IPredicate createPredicate(int arity, IPredicate.ArgType[] argTypes) {
        return this.base.createPredicate(arity, argTypes);
    }

    @Override
    public IPredicateDeclaration createPredicateDeclaration(IPredicate pred, IFormula body, IVariable ... vars) {
        return this.base.createPredicateDeclaration(pred, body, vars);
    }

    @Override
    public IFormulaDeclaration createFormulaDeclaration(IFormula f) {
        return this.base.createFormulaDeclaration(f);
    }

    @Override
    public IPositionSetTerm createSetIntersection(IPositionSetTerm t1, IPositionSetTerm t2) {
        return this.base.createSetIntersection(t1, t2);
    }

    @Override
    public IPositionSetTerm createPositionSetMinus(IPositionSetTerm pos, int n) {
        return this.base.createPositionSetMinus(pos, n);
    }

    @Override
    public IPositionSetTerm createPositionSetPlus(IPositionSetTerm pos, int n) {
        return this.base.createPositionSetPlus(pos, n);
    }

    @Override
    public IPositionSetTerm createSetSubtraction(IPositionSetTerm t1, IPositionSetTerm t2) {
        return this.base.createSetSubtraction(t1, t2);
    }

    @Override
    public IPositionSetTerm createSetUnion(IPositionSetTerm t1, IPositionSetTerm t2) {
        return this.base.createSetUnion(t1, t2);
    }

    @Override
    public IFormula createIsEmpty(IPositionSetTerm t) {
        return this.createPositionSetEqual(t, this.createPositionSet(new IPositionTerm[0]));
    }

    @Override
    public IFormula createIsStr(String str, IPositionSetTerm t) {
        IFormula eq;
        char[] c = str.toCharArray();
        IPositionTerm[] v = new IPositionVariable[c.length];
        for (int i = 0; i < c.length; ++i) {
            v[i] = this.createPositionVariable();
        }
        IPositionSet t2 = this.createPositionSet(v);
        IFormula f = eq = this.createPositionSetEqual(t, t2);
        if (v.length > 0) {
            for (int i = v.length - 1; i > 0; --i) {
                IFormula lt = this.createIsLT(v[i - 1], v[i]);
                IFormula isChar = this.createIsChar(c[i], v[i]);
                IFormula ltAndChar = this.createAnd(lt, isChar);
                f = this.createExists((IPositionVariable)v[i], this.createAnd(ltAndChar, f));
            }
            IFormula isChar0 = this.createIsChar(c[0], v[0]);
            f = this.createExists((IPositionVariable)v[0], this.createAnd(isChar0, f));
        }
        return f;
    }

    @Override
    public IFormula createImply(IFormula f1, IFormula f2) {
        return this.base.createImply(f1, f2);
    }

    @Override
    public IFormula createFormulaEqual(IFormula t1, IFormula t2) {
        return this.base.createFormulaEqual(t1, t2);
    }

    @Override
    public IFormula createPositionEqual(IPositionTerm t1, IPositionTerm t2) {
        return this.base.createPositionEqual(t1, t2);
    }

    @Override
    public IFormula createPositionSetEqual(IPositionSetTerm t1, IPositionSetTerm t2) {
        return this.base.createPositionSetEqual(t1, t2);
    }

    @Override
    public IBoolean createFalse() {
        return this.base.createFalse();
    }

    @Override
    public IBoolean createTrue() {
        return this.base.createTrue();
    }

    @Override
    public IPositionSetVariableDefinition createPositionSetVariableDefinition(IPositionSetVariable v) {
        return this.base.createPositionSetVariableDefinition(v);
    }

    @Override
    public IPositionVariableDefinition createPositionVariableDefinition(IPositionVariable v) {
        return this.base.createPositionVariableDefinition(v);
    }

    @Override
    public IPositionSetVariableDefinition createPositionSetVariableDefinitionWhere(IPositionSetVariable v, IFormula f) {
        return this.base.createPositionSetVariableDefinitionWhere(v, f);
    }

    @Override
    public IPositionVariableDefinition createPositionVariableDefinitionWhere(IPositionVariable v, IFormula f) {
        return this.base.createPositionVariableDefinitionWhere(v, f);
    }

    @Override
    public IFormula createIsGT(IPositionTerm pos1, IPositionTerm pos2) {
        return this.base.createIsGT(pos1, pos2);
    }

    @Override
    public IFormula createIsLT(IPositionTerm pos1, IPositionTerm pos2) {
        return this.base.createIsLT(pos1, pos2);
    }

    @Override
    public IFormula createSubset(IPositionSetTerm t1, IPositionSetTerm t2) {
        return this.base.createSubset(t1, t2);
    }

    @Override
    public IFormula createIn(IPositionTerm p1, IPositionSetTerm s1) {
        return this.base.createIn(p1, s1);
    }

    protected abstract IPredicate getConcatPredicate();

    protected abstract IPredicate getConsecutivePredicate();

    protected abstract IPredicate getStrrPredicate();

    protected abstract IPredicate getSubstrrPredicate();

    protected abstract IPredicate getSubstrPredicate();

    protected abstract IPredicate getChoicePredicate();

    protected abstract IPredicate getSeparatorPredicate();

    private IFormula createIsConcat(int n, IPositionSetTerm r, IPositionSetTerm ... t) {
        if (n == t.length - 1) {
            IFormula f = this.createPositionSetEqual(t[n], r);
            return f;
        }
        IPositionSetVariable v = this.createPositionSetVariable();
        IFormula f0 = this.createApplyPredicate(this.getConcatPredicate(), r, t[n], v);
        IFormula f1 = this.createIsConcat(n + 1, (IPositionSetTerm)v, t);
        IFormula f2 = this.createAnd(f0, f1);
        IFormula f3 = this.createExists(v, f2);
        return f3;
    }

    @Override
    public IFormula createIsConcat(IPositionSetTerm r, IPositionSetTerm ... t) {
        return this.createIsConcat(0, r, t);
    }

    @Override
    public IFormula createIsConsecutive(IPositionTerm p1, IPositionTerm p2, IPositionSetTerm R) {
        return this.createApplyPredicate(this.getConsecutivePredicate(), p1, p2, R);
    }

    @Override
    public IFormula createIsStrr(IPositionSetTerm R, IPositionSetTerm S, IPositionTerm p1, IPositionTerm p2) {
        return this.createApplyPredicate(this.getStrrPredicate(), R, S, p1, p2);
    }

    @Override
    public IFormula createIsSubstrr(IPositionSetTerm R, IPositionSetTerm S, IPositionTerm p1, IPositionTerm p2) {
        return this.createApplyPredicate(this.getSubstrrPredicate(), R, S, p1, p2);
    }

    @Override
    public IFormula createIsSubstr(IPositionSetTerm R, IPositionSetTerm S) {
        return this.createApplyPredicate(this.getSubstrPredicate(), R, S);
    }

    @Override
    public IFormula createChoice(IPositionSetTerm R, IPositionSetTerm S) {
        return this.createApplyPredicate(this.getChoicePredicate(), R, S);
    }

    @Override
    public IFormula createIsSeparator(IPositionTerm p) {
        return this.createApplyPredicate(this.getSeparatorPredicate(), p);
    }

    protected IAutomaton encodeCharset(char min, char max) {
        return BinEncoder.encodeCharset(min, max);
    }

    protected abstract IFormula createInBit(IPositionTerm var1, int var2);

    private IFormula patternToFormula(IAutomaton a, IState s, IPositionTerm p, int bitPos) {
        if (a.getFinalStates().contains(s)) {
            return this.createTrue();
        }
        Set transitions = a.getTransitions(s);
        HashSet<IState> nextStates = new HashSet<IState>();
        for (Object t : transitions) {
            nextStates.add(t.getPostState());
        }
        if (nextStates.size() == 1 && transitions.size() == 2) {
            return this.patternToFormula(a, (IState)nextStates.iterator().next(), p, bitPos + 1);
        }
        HashSet<IFormula> formulae = new HashSet<IFormula>();
        for (ITransition t : transitions) {
            IntSymbol input = (IntSymbol)t.getInputSymbol();
            IFormula f = this.patternToFormula(a, t.getPostState(), p, bitPos + 1);
            int bit = input.intValue();
            f = bit == 0 ? this.createAnd(this.createNot(this.createInBit(p, bitPos)), f) : this.createAnd(this.createInBit(p, bitPos), f);
            formulae.add(f);
        }
        switch (formulae.size()) {
            case 0: {
                return this.createTrue();
            }
            case 1: {
                return (IFormula)formulae.iterator().next();
            }
        }
        Iterator i = formulae.iterator();
        IFormula body = (IFormula)i.next();
        while (i.hasNext()) {
            body = this.createOr((IFormula)i.next(), body);
        }
        return body;
    }

    @Override
    public IFormula createCharset(IPositionTerm r, char min, char max) {
        IAutomaton a = this.encodeCharset(min, max);
        return this.patternToFormula(a, a.getInitialState(), r, 0);
    }

    @Override
    public IFormula createCharset(IPositionSetTerm R, char min, char max) {
        IPositionVariable p = this.createPositionVariable();
        IFormula body1 = this.createPositionSetEqual(R, this.createPositionSet(p));
        IFormula body2 = this.createCharset(p, min, max);
        IFormula body = this.createExists(p, this.createAnd(body1, body2));
        return body;
    }

    @Override
    public IFormula createPos(int n, IPositionTerm p, IPositionSetTerm P) {
        IPositionFunction min = this.createPositionFunction("min", 1);
        IPositionTerm minP = this.createApplyPositionFunction(min, P);
        if (n == 0) {
            IFormula f = this.createPositionEqual(p, minP);
            return f;
        }
        return this.createPos(n - 1, p, this.createSetSubtraction(P, this.createPositionSet(minP)));
    }
}

