/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.solver;

import com.ibm.wala.automaton.regex.string.IPatternCompiler;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.samso.m2lstr.DeclarationSets;
import com.ibm.wala.samso.m2lstr.IDeclaration;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.RegexpToM2L;
import com.ibm.wala.samso.solver.MONAUtil;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.NullProgressMonitor;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class MONA {
    public static String tmpPrefix = System.getProperty("com.ibm.wala.stringAnalysis.tmpPrefix", "m2lstr");
    public static String tmpSuffix = System.getProperty("com.ibm.wala.stringAnalysis.tmpSuffix", ".mona");
    public static String tmpDir = System.getProperty("com.ibm.wala.stringAnalysis.tmpDir", "C:/tmp");
    public static String MONA = System.getProperty("com.ibm.wala.stringAnalysis.mona", "C:\\home\\ttate\\bin\\mona-win32.exe");
    public static String CMD = System.getProperty("com.ibm.wala.stringAnalysis.cmd", "cmd.exe /c");
    public static String MONA_OPTS = "-s";
    public static String tmpOut = System.getProperty("com.ibm.wala.stringAnalysis.tmpOutput", "m2lstr.out");
    public static String tmpExec = System.getProperty("com.ibm.wala.stringAnalysis.tmpExec", "m2lstr.bat");
    private Map<String, char[]> lastCounterExample;
    private Map<String, char[]> lastSatisfyingExample;
    private Process monaProcess = null;
    private long monaTime = 0L;
    private long monaTotalTime = 0L;
    private long numberOfPredicates = 0L;
    private long numberOfDAGNodes = 0L;
    private long numberOfReducedDAGNodes = 0L;
    private long numberOfStates = 0L;
    private long numberOfBDDNodes = 0L;
    private long numberOfAutomata = 0L;
    private final IPatternCompiler<IDeclarationSet> m2lc;
    private final IExtendedFormulaFactory ffactory;
    private final MonitorUtil.IProgressMonitor monitor;
    private final MonitorUtil.IProgressMonitor defaultMonitor = new NullProgressMonitor();

    private File generateMonaProgram(IDeclarationSet decls) throws IOException {
        this.numberOfPredicates = decls.size();
        File tmp = tmpDir == null ? new File(tmpPrefix + tmpSuffix) : new File(new File(tmpDir), tmpPrefix + tmpSuffix);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
        OutputStreamWriter writer = new OutputStreamWriter(out);
        PrintWriter print = new PrintWriter(writer);
        for (IDeclaration decl : this.ffactory.prologue()) {
            print.println(decl + ";");
        }
        print.println(decls.toString());
        print.close();
        return tmp;
    }

    private boolean check(File f, String msg, String falseMsg, String opts) throws IOException, InterruptedException {
        InputStream in = this.runMONA(f, opts);
        return this.checkResult(in, msg, falseMsg);
    }

    public InputStream runMONA(IDeclarationSet declSet, String opts) throws IOException {
        File file = this.generateMonaProgram(declSet);
        return this.runMONA(file, opts);
    }

    public InputStream runMONA(File file, String opts) throws IOException {
        String filename = file.getName();
        File dir = file.getParentFile();
        return this.runMONA(filename, dir, opts);
    }

    protected InputStream runMONA(String filename, File dir, String opts) throws IOException {
        String cmds = MONA + " " + (opts == null ? "" : opts + " ") + filename;
        String[] cmdary = cmds.split("\\s+");
        Map<String, String> env = System.getenv();
        String[] envary = new String[env.size()];
        int i = 0;
        for (Map.Entry<String, String> e : env.entrySet()) {
            envary[i] = e.getKey() + "=" + e.getValue();
            ++i;
        }
        Runtime rt = Runtime.getRuntime();
        this.monaProcess = rt.exec(cmdary, envary, dir);
        return this.monaProcess.getInputStream();
    }

    protected InputStream runMONA2(String filename, File dir, String opts) throws IOException {
        File execFile = new File(dir, tmpExec);
        if (!execFile.exists()) {
            FileOutputStream batOut = new FileOutputStream(execFile);
            String mona = MONA + " " + (opts == null ? "" : opts + " ") + filename + " > " + tmpOut;
            ((OutputStream)batOut).write(mona.getBytes());
            batOut.flush();
            ((OutputStream)batOut).close();
        }
        String cmds = CMD + " " + tmpExec;
        String[] cmdary = cmds.split("\\s+");
        Map<String, String> env = System.getenv();
        String[] envary = new String[env.size()];
        int i = 0;
        for (Map.Entry<String, String> e : env.entrySet()) {
            envary[i] = e.getKey() + "=" + e.getValue();
            ++i;
        }
        Runtime rt = Runtime.getRuntime();
        this.monaProcess = rt.exec(cmdary, envary, dir);
        try {
            this.monaProcess.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return new FileInputStream(new File(dir, tmpOut));
    }

    protected void printLine(String line) {
    }

    protected boolean checkResult(InputStream in, String msg, String falseMsg) throws IOException {
        String totalTimeMsg = "Total time: ";
        InputStreamReader reader = new InputStreamReader(in);
        BufferedReader buff = new BufferedReader(reader);
        String line = buff.readLine();
        boolean result = false;
        while (line != null) {
            String[] s;
            this.printLine(line);
            if (this.monitor.isCanceled()) {
                this.monaProcess.destroy();
                buff.close();
                throw new MONAError("time limit!");
            }
            SAUtil.println((Object)line);
            if (line.startsWith("DAG hits:")) {
                long n;
                s = line.split(": ");
                this.numberOfDAGNodes = n = Long.parseLong(s[2]);
            } else if (line.startsWith("DAG nodes after reduction:")) {
                long n;
                s = line.split(": ");
                this.numberOfReducedDAGNodes = n = Long.parseLong(s[1]);
            } else if (line.startsWith("Largest number of states in a minimized automaton:")) {
                s = line.split("[:,]+");
                this.numberOfStates = Long.parseLong(s[1].trim());
                this.numberOfBDDNodes = Long.parseLong(s[3].trim());
            } else if (line.startsWith("Maximum number of automata in memory:")) {
                s = line.split(":");
                this.numberOfAutomata = Long.parseLong(s[1].trim());
            } else if (line.startsWith("Total time: ")) {
                String timeStr = line.substring("Total time: ".length());
                String[] hms = timeStr.split("[:.]");
                this.monaTime = Integer.parseInt(hms[3]) * 10;
                this.monaTime += (long)(Integer.parseInt(hms[2]) * 1000);
                this.monaTime += (long)(Integer.parseInt(hms[1]) * 60 * 1000);
                this.monaTime += (long)(Integer.parseInt(hms[0]) * 60 * 60 * 1000);
                this.monaTotalTime += this.monaTime;
            } else if (line.contains(msg)) {
                result = true;
            } else if (line.contains(falseMsg)) {
                result = false;
            } else {
                if (line.startsWith("Execution aborted")) {
                    throw new MONAError("MONA aborted");
                }
                if (line.startsWith("*** out of memory")) {
                    throw new MONAError("MONA aborted due to out of memory");
                }
            }
            if (line.startsWith("A satisfying example of least length")) {
                this.lastSatisfyingExample = this.makeExample(buff);
                if (SAUtil.DEBUG) {
                    MONAUtil.dumpExamples("Satisfying example", this.lastSatisfyingExample);
                }
            } else if (line.startsWith("A counter-example of least length")) {
                this.lastCounterExample = this.makeExample(buff);
                if (SAUtil.DEBUG) {
                    MONAUtil.dumpExamples("Counter example", this.lastCounterExample);
                }
            }
            line = buff.readLine();
        }
        buff.close();
        this.monaProcess = null;
        return result;
    }

    public Map<String, char[]> getLastCounterExample() {
        return this.lastCounterExample;
    }

    public Map<String, char[]> getLastSatisfyingExample() {
        return this.lastSatisfyingExample;
    }

    public Map<String, char[]> makeExample(BufferedReader rd) throws IOException {
        HashMap<String, char[]> example = new HashMap<String, char[]>();
        Pattern space = Pattern.compile("\\s+");
        String line = rd.readLine().trim();
        this.printLine(line);
        while (line != null && line.length() > 0) {
            String[] columns = space.split(line);
            if (columns.length >= 2) {
                char[] bits = columns.length == 2 ? new char[]{} : columns[2].toCharArray();
                example.put(columns[0], bits);
            }
            line = rd.readLine().trim();
            this.printLine(line);
        }
        return example;
    }

    public long getLastSolvingTime() {
        return this.monaTime;
    }

    public long getTotalSolvingTime() {
        return this.monaTotalTime;
    }

    public long getLastNumberOfPredicates() {
        return this.numberOfPredicates;
    }

    public long getLastNumberOfDAGNodes() {
        return this.numberOfDAGNodes;
    }

    public long getLastNumberOfReducedDAGNodes() {
        return this.numberOfReducedDAGNodes;
    }

    public long getLastNumberOfStates() {
        return this.numberOfStates;
    }

    public long getLastNumberOfBDDNodes() {
        return this.numberOfBDDNodes;
    }

    public long getLastNumberOfAutomata() {
        return this.numberOfAutomata;
    }

    protected boolean check(IDeclarationSet declSet, String msg, String falseMsg) {
        return this.check(declSet, msg, falseMsg, MONA_OPTS);
    }

    public boolean check(IDeclarationSet declSet, String msg, String falseMsg, String opts) {
        try {
            return this.check(this.generateMonaProgram(declSet), msg, falseMsg, opts);
        }
        catch (IOException e) {
            throw new MONAError(e);
        }
        catch (InterruptedException e) {
            throw new MONAError(e);
        }
    }

    public boolean checkValidity(IDeclarationSet declSet) {
        return this.check(declSet, "Formula is valid", "A counter-example of");
    }

    public boolean checkSatisfiability(IDeclarationSet declSet) {
        return this.check(declSet, "A satisfying example", "Formula is unsatisfiable");
    }

    public boolean checkUnsatisfiability(IDeclarationSet declSet) {
        return this.check(declSet, "Formula is unsatisfiable", "A satisfying example");
    }

    public MONA(IExtendedFormulaFactory ffactory, MonitorUtil.IProgressMonitor monitor) {
        this.ffactory = ffactory;
        this.m2lc = new RegexpToM2L(ffactory);
        this.monitor = monitor == null ? this.defaultMonitor : monitor;
    }

    public boolean containsAll(IAutomaton pattern, IDeclarationSet g) {
        IDeclarationSet spec = (IDeclarationSet)this.m2lc.compile(Automatons.toRegex((IAutomaton)pattern));
        IDeclarationSet decls = DeclarationSets.createImply(g, spec, this.ffactory);
        return this.checkValidity(decls);
    }

    public boolean containsSome(IDeclarationSet g, IAutomaton pattern) {
        IDeclarationSet spec = (IDeclarationSet)this.m2lc.compile(Automatons.toRegex((IAutomaton)pattern));
        IDeclarationSet declSet = DeclarationSets.createIntersection(Arrays.asList(g, spec), this.ffactory);
        return this.checkSatisfiability(declSet);
    }

    public boolean containsStringSometimes(IDeclarationSet g, String str) {
        IPositionSetVariable R = this.ffactory.createPositionSetVariable();
        IPositionSetVariable S = this.ffactory.createPositionSetVariable();
        IFormula specFormula = this.ffactory.createExists(S, this.ffactory.createAnd(this.ffactory.createSubset(S, R), this.ffactory.createIsStr(str, S)));
        IDeclarationSet spec = DeclarationSets.createDeclarationSet(R, specFormula, this.ffactory);
        IDeclarationSet declSet = DeclarationSets.createIntersection(Arrays.asList(g, spec), this.ffactory);
        return this.checkSatisfiability(declSet);
    }

    public boolean containsStringAlways(IDeclarationSet g, String str) {
        IPositionSetVariable R = this.ffactory.createPositionSetVariable();
        IPositionSetVariable S = this.ffactory.createPositionSetVariable();
        IFormula specFormula = this.ffactory.createExists(S, this.ffactory.createAnd(this.ffactory.createSubset(S, R), this.ffactory.createIsStr(str, S)));
        IDeclarationSet spec = DeclarationSets.createDeclarationSet(R, specFormula, this.ffactory);
        IDeclarationSet declSet = DeclarationSets.createImply(g, spec, this.ffactory);
        return this.checkValidity(declSet);
    }

    public static class MONAError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public MONAError(String msg) {
            super(msg);
        }

        public MONAError(Throwable e) {
            super(e);
        }
    }
}

