/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.solver;

import com.ibm.wala.samso.m2lstr.DeclarationSet;
import com.ibm.wala.samso.m2lstr.IDeclaration;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.mona.MONAFormulaFactory;
import com.ibm.wala.samso.solver.MONA;
import com.ibm.wala.samso.solver.MONAUtil;
import com.ibm.wala.samso.solver.parser.PrefixBasedDFAFileFinder;
import com.ibm.wala.samso.solver.parser.SolverParser;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.MonitorUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StringConstraintSolver {
    private final MONA mona;
    private final SolverParser parser;
    private IDeclarationSet declSet;
    private final PrefixBasedDFAFileFinder dfaFinder = new PrefixBasedDFAFileFinder();

    public StringConstraintSolver(IExtendedFormulaFactory ffactory, MonitorUtil.IProgressMonitor monitor) {
        this.mona = new MONA(ffactory, monitor);
        this.parser = new SolverParser(ffactory, this.dfaFinder);
        this.declSet = new DeclarationSet(null);
    }

    public StringConstraintSolver() {
        this(new MONAFormulaFactory(), null);
    }

    public MONA getMONA() {
        return this.mona;
    }

    public void clear() {
        this.parser.initScope();
        this.declSet.clear();
    }

    public void read(IDeclarationSet declSet) {
        for (IDeclaration decl : declSet) {
            String s = decl.toString() + ";";
            ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
            this.read(is);
        }
    }

    public void read(InputStream is) {
        List<IDeclaration> l = this.parser.parse(is);
        if (l == null) {
            SAUtil.print((Object)"failed to parse");
        } else {
            for (IDeclaration decl : l) {
                this.declSet.add(decl);
            }
        }
    }

    public boolean checkValidity() {
        return this.mona.checkValidity(this.declSet);
    }

    public boolean checkSatisfiability() {
        return this.mona.checkSatisfiability(this.declSet);
    }

    public boolean generateDFA(PrintStream out) {
        try {
            int n;
            InputStream is = this.mona.runMONA(this.declSet, "-xw");
            byte[] buff = new byte[256];
            while ((n = is.read(buff)) > 0) {
                out.write(buff, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public Map<String, char[]> getLastCounterExample() {
        return this.mona.getLastCounterExample();
    }

    public Map<String, char[]> getLastSatisfyingExample() {
        return this.mona.getLastSatisfyingExample();
    }

    public static void printUsage(PrintStream out) {
        out.println("java StringConstraintSolver [-i <filename>] [-I <search-dir>]* [-var <variable>]* [checkValid|checkSat|run|export]");
    }

    public void run(String[] args) throws FileNotFoundException {
        PrintStream out;
        ArrayList<String> varnames = new ArrayList<String>();
        String cmd = null;
        String input = null;
        String output = null;
        for (int i = 0; i < args.length; ++i) {
            String x = args[i];
            if (x.equals("-i")) {
                input = args[++i];
                continue;
            }
            if (x.equals("-o")) {
                output = args[++i];
                continue;
            }
            if (x.equals("-I")) {
                this.dfaFinder.getSearchPath().add(args[++i]);
                continue;
            }
            if (x.equals("-var")) {
                varnames.add(args[++i]);
                continue;
            }
            if (x.startsWith("-")) {
                StringConstraintSolver.printUsage(System.err);
                return;
            }
            cmd = x;
        }
        if (cmd == null) {
            StringConstraintSolver.printUsage(System.err);
            return;
        }
        InputStream is = input == null ? System.in : new FileInputStream(this.dfaFinder.findFile(input));
        this.read(is);
        PrintStream printStream = out = output == null ? System.out : new PrintStream(new FileOutputStream(output));
        if (cmd.equals("checkValid")) {
            boolean valid = this.checkValidity();
            if (valid) {
                out.println("Valid");
            } else {
                out.println("Invalid");
                Map<String, char[]> example = this.getLastCounterExample();
                for (String varname : varnames) {
                    String s = MONAUtil.makeExampleString(varname, example);
                    out.println("Counterexample for " + varname + ": \"" + s + "\"");
                }
            }
        } else if (cmd.equals("checkSat")) {
            boolean sat = this.checkSatisfiability();
            if (sat) {
                out.println("Satisfiable");
                Map<String, char[]> example = this.getLastSatisfyingExample();
                for (String varname : varnames) {
                    String s = MONAUtil.makeExampleString(varname, example);
                    out.println("Example for " + varname + ": \"" + s + "\"");
                }
            } else {
                out.println("Unsatisfiable");
            }
        } else if (cmd.equals("run")) {
            this.checkValidity();
        } else if (cmd.equals("export")) {
            this.generateDFA(out);
        } else {
            StringConstraintSolver.printUsage(System.err);
            System.exit(1);
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        StringConstraintSolver solver = new StringConstraintSolver();
        solver.run(args);
    }
}

