/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.solver.parser;

import com.ibm.wala.samso.m2lstr.DeclarationSets;
import com.ibm.wala.samso.m2lstr.IBoolean;
import com.ibm.wala.samso.m2lstr.IDeclaration;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.IFormulaDeclaration;
import com.ibm.wala.samso.m2lstr.ILambdaFormula;
import com.ibm.wala.samso.m2lstr.IPositionSet;
import com.ibm.wala.samso.m2lstr.IPositionSetTerm;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.IPositionSetVariableDefinition;
import com.ibm.wala.samso.m2lstr.IPositionTerm;
import com.ibm.wala.samso.m2lstr.IPositionVariable;
import com.ibm.wala.samso.m2lstr.IPositionVariableDefinition;
import com.ibm.wala.samso.m2lstr.IPredicate;
import com.ibm.wala.samso.m2lstr.IPredicateDeclaration;
import com.ibm.wala.samso.m2lstr.ITerm;
import com.ibm.wala.samso.m2lstr.IVariable;
import com.ibm.wala.samso.m2lstr.IVariableDefinition;
import com.ibm.wala.samso.m2lstr.LambdaFormula;
import com.ibm.wala.samso.m2lstr.mona.MONAFormulaFactory;
import com.ibm.wala.samso.parser.ParserException;
import com.ibm.wala.samso.solver.parser.IDFAFileFinder;
import com.ibm.wala.samso.translator.repository.ConcatTemplate;
import com.ibm.wala.samso.translator.repository.M2LTranslator;
import com.ibm.wala.samso.translator.repository.SubstringTemplate;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.Function;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;

public class ParserUtil
extends com.ibm.wala.automaton.parser.ParserUtil {
    private final Map<String, M2LTranslator> templateMap = new HashMap<String, M2LTranslator>();
    private final IDFAFileFinder dfaFinder;
    private final IExtendedFormulaFactory ffactory;
    private final Stack<Env> env = new Stack();
    private Env envPrologue = null;
    private static Map<String, Integer> symKind = new HashMap<String, Integer>();
    private Object yylval = null;
    private char[] BUFF = new char[256];
    static Pattern dfaVarsPattern;
    private final List<IDeclaration> decls = new LinkedList<IDeclaration>();

    public ParserUtil(IExtendedFormulaFactory ffactory, IDFAFileFinder dfaFinder) {
        this.ffactory = ffactory;
        this.dfaFinder = dfaFinder;
        this.templateMap.put("concat", new ConcatTemplate());
        this.templateMap.put("substring", new SubstringTemplate(0, 1));
        this.templateMap.put("substring2", new SubstringTemplate(0, 1, 2));
        this.initScope();
    }

    private void loadPrologue() {
        if (this.envPrologue == null) {
            for (IDeclaration decl : this.ffactory.prologue()) {
                if (decl instanceof IPredicateDeclaration) {
                    this.registerPredicate(((IPredicateDeclaration)decl).getPredicate());
                    continue;
                }
                if (!(decl instanceof IVariableDefinition)) continue;
                this.registerVariable(((IVariableDefinition)decl).getVariable());
            }
            this.envPrologue = this.env.peek();
        } else {
            this.env.push(this.envPrologue);
        }
        this.pushScope();
    }

    public void pushScope() {
        this.env.push(new Env());
    }

    public Env popScope() {
        return this.env.pop();
    }

    public void initScope() {
        this.env.clear();
        this.pushScope();
        this.loadPrologue();
    }

    public void registerVariable(IVariable v) {
        this.env.peek().varMap.put(v.getName(), v);
    }

    public IVariable lookupVariable(String name) {
        for (int i = this.env.size(); i > 0; --i) {
            Env e = (Env)this.env.get(i - 1);
            IVariable v = e.varMap.get(name);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    public void registerPredicate(IPredicate p) {
        this.env.peek().predMap.put(p.getName(), p);
    }

    public IPredicate lookupPredicate(String name) {
        for (int i = this.env.size(); i > 0; --i) {
            Env e = (Env)this.env.get(i - 1);
            IPredicate p = e.predMap.get(name);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public void registerVariables(Collection<IVariable> vs) {
        for (IVariable v : vs) {
            this.registerVariable(v);
        }
    }

    public void registerQVariables(Collection<Object[]> vws) {
        for (Object[] o : vws) {
            IVariable v = (IVariable)o[0];
            this.registerVariable(v);
        }
    }

    public void registerPredicates(Collection<IPredicate> ps) {
        for (IPredicate p : ps) {
            this.registerPredicate(p);
        }
    }

    public IPredicate lookupOrCreatePredicate(String name, IPredicate.ArgType[] argTypes) {
        IPredicate p = this.lookupPredicate(name);
        if (p == null) {
            p = this.ffactory.createPredicate(name, argTypes.length, argTypes);
            this.registerPredicate(p);
        }
        return p;
    }

    public boolean isSymbolChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public boolean isSymbolStartChar(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public boolean isSymbolEndChar(char c) {
        return this.isSymbolChar(c) || c == '\'';
    }

    public int getSymbolKind(String s) {
        if (symKind.containsKey(s)) {
            this.yylval = s;
            return symKind.get(s);
        }
        IPredicate p = this.lookupPredicate(s);
        if (p != null) {
            this.yylval = p;
            return 296;
        }
        IVariable v = this.lookupVariable(s);
        if (v == null) {
            this.yylval = s;
            return 289;
        }
        if (v instanceof IPositionVariable) {
            this.yylval = v;
            return 294;
        }
        if (v instanceof IPositionSetVariable) {
            this.yylval = v;
            return 295;
        }
        this.yylval = s;
        return 289;
    }

    protected void setYylval(Object obj) {
        this.yylval = obj;
    }

    public Object yylval() {
        return this.yylval;
    }

    public int yylex() {
        int c = this.yylexSub();
        return c;
    }

    private int yylexSub() {
        int n;
        int c3;
        int c2;
        int c;
        this.yylval = null;
        block0: while (true) {
            if ((c = this.getch()) < 0) {
                return 0;
            }
            if (c == 35) {
                while (true) {
                    if (c == 0 || c == 10) continue block0;
                    c = this.getch();
                }
            }
            if (c == 47) {
                c2 = this.getch();
                if (c2 == 42) {
                    c3 = this.getch();
                    if (c3 == 0) {
                        return 0;
                    }
                    int c4 = this.getch();
                    if (c4 == 0) {
                        return 0;
                    }
                    do {
                        if (c3 == 42 && c4 == 47) continue block0;
                        c3 = c4;
                    } while ((c4 = this.getch()) != 0);
                    return 0;
                }
                this.ungetch(c2);
                continue;
            }
            if (c == 32 || c == 9 || c == 13 || c == 10) continue;
            if (c == 34) {
                StringBuffer buff = new StringBuffer();
                c = this.getch();
                while (c != 34) {
                    if (c == 92) {
                        c = this.getch();
                    }
                    buff.append((char)c);
                    c = this.getch();
                }
                this.setYylval(buff.toString());
                return 288;
            }
            if (c != 37) break;
            c2 = this.getch();
            if (c2 == 114 || c2 == 102 || c2 == 105) {
                c3 = this.getch();
                if (c3 == 123) {
                    String s = this.readCharsUntil("}");
                    this.setYylval(s);
                    if (c2 == 114) {
                        return 290;
                    }
                    if (c2 == 102) {
                        return 292;
                    }
                    if (c2 == 105) {
                        return 293;
                    }
                }
                this.ungetch(c3);
            }
            this.ungetch(c2);
        }
        if (c == 36) {
            return 36;
        }
        if (c == 126) {
            c2 = this.getch();
            if (c2 == 61) {
                return 273;
            }
            this.ungetch(c2);
        }
        if (c == 34) {
            StringBuffer buff = new StringBuffer();
            int c22 = this.getch();
            while (c22 != c) {
                buff.append((char)c22);
                c22 = this.getch();
                if (c22 == 92) {
                    c22 = this.getch();
                    continue;
                }
                if (c22 != 34) continue;
            }
            this.yylval = buff.toString();
            return 288;
        }
        if (Character.isDigit((char)c)) {
            n = 0;
            this.BUFF[n++] = (char)c;
            c = this.getch();
            while (Character.isDigit((char)c) || c == 46) {
                this.BUFF[n++] = (char)c;
                c = this.getch();
            }
            this.ungetch(c);
            String numStr = new String(this.BUFF, 0, n);
            this.yylval = Integer.valueOf(numStr);
            return 287;
        }
        if (c == 62) {
            c2 = this.getch();
            if (c2 == 61) {
                this.yylval = ">=";
                return 272;
            }
            this.ungetch(c2);
        }
        if (c == 60) {
            c2 = this.getch();
            if (c2 == 61) {
                c3 = this.getch();
                if (c3 == 62) {
                    this.yylval = "<=>";
                    return 280;
                }
                this.ungetch(c3);
                this.yylval = "<=";
                return 271;
            }
            this.ungetch(c2);
        }
        if (c == 61) {
            c = this.getch();
            if (c == 62) {
                return 279;
            }
            this.ungetch(c);
            this.yylval = Character.toString('=');
            return 61;
        }
        if (this.isSymbolStartChar((char)c)) {
            n = 0;
            this.BUFF[n++] = (char)c;
            while (this.isSymbolChar((char)c)) {
                this.BUFF[n++] = (char)c;
                c = this.getch();
            }
            while (this.isSymbolEndChar((char)c)) {
                this.BUFF[n++] = (char)c;
                c = this.getch();
            }
            this.ungetch(c);
            return this.getSymbolKind(new String(this.BUFF, 1, n - 1));
        }
        this.yylval = Character.toString((char)c);
        return c;
    }

    public IFormula createIsString(String str, IPositionSetTerm t) {
        return this.ffactory.createIsStr(str, t);
    }

    public IFormula createIsRegexp(String regexp, IPositionSetTerm t) {
        ILambdaFormula f1 = DeclarationSets.createFormulaForRegexp(regexp, this.ffactory);
        IFormula f2 = this.ffactory.createPositionSetEqual(t, (IPositionSetVariable)f1.getVariable(0));
        return this.ffactory.createExists((IPositionSetVariable)f1.getVariable(0), this.ffactory.createAnd(f2, f1.getFormula()));
    }

    public IFormula createApplyTemplate(String name, IPositionTerm p, IPositionSetTerm P, List<IPredicate> l) {
        return this.templateMap.get(name).instantiate(this.ffactory, (IPositionVariable)p, (IPositionSetVariable)P, l.toArray(new IPredicate[l.size()]));
    }

    public ILambdaFormula createBinaryConstraint(ILambdaFormula f1, final ILambdaFormula f2, DeclarationSets.IBinaryOperation binOp) {
        assert (f1.getArity() == f2.getArity());
        final IVariable[] vs = new IVariable[f1.getArity()];
        for (int i = 0; i < f1.getArity(); ++i) {
            vs[i] = f1.getVariable(i);
        }
        IFormula f = f2.getFormula().replaceTerm(new Function<IVariable, ITerm>(){

            public ITerm apply(IVariable v) {
                for (int i = 0; i < vs.length; ++i) {
                    if (!f2.getVariable(i).equals(v)) continue;
                    return vs[i];
                }
                return v;
            }
        });
        return LambdaFormula.make(binOp.create(f1.getFormula(), f, this.ffactory), vs);
    }

    public ILambdaFormula createOrConstraint(ILambdaFormula f1, ILambdaFormula f2) {
        return this.createBinaryConstraint(f1, f2, DeclarationSets.orOperation);
    }

    public ILambdaFormula createAndConstraint(ILambdaFormula f1, ILambdaFormula f2) {
        return this.createBinaryConstraint(f1, f2, DeclarationSets.andOperation);
    }

    public ILambdaFormula createImplyConstraint(ILambdaFormula f1, ILambdaFormula f2) {
        return this.createBinaryConstraint(f1, f2, DeclarationSets.implyOperation);
    }

    public ILambdaFormula createEqualConstraint(ILambdaFormula f1, ILambdaFormula f2) {
        return this.createAndConstraint(this.createImplyConstraint(f1, f2), this.createImplyConstraint(f2, f1));
    }

    public ILambdaFormula createNotConstraint(ILambdaFormula f1) {
        IVariable[] vs = new IVariable[f1.getArity()];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = f1.getVariable(i);
        }
        return LambdaFormula.make(this.ffactory.createNot(f1.getFormula()), vs);
    }

    public IPredicate createAndRegisterPredicate(ILambdaFormula f) {
        int arity = f.getArity();
        IPredicate.ArgType[] argTypes = new IPredicate.ArgType[arity];
        IVariable[] vars = new IVariable[arity];
        for (int i = 0; i < arity; ++i) {
            IVariable v;
            vars[i] = v = f.getVariable(i);
            argTypes[i] = v instanceof IPositionSetVariable ? IPredicate.ArgType.POSITION_SET : (v instanceof IPositionVariable ? IPredicate.ArgType.POSITION : null);
        }
        IPredicate p = this.ffactory.createPredicate(arity, argTypes);
        this.registerPredicate(p);
        IPredicateDeclaration d = this.ffactory.createPredicateDeclaration(p, f.getFormula(), vars);
        this.addDeclaration(d);
        return p;
    }

    public List<IPredicate> createAndRegisterPredicates(List<ILambdaFormula> fs) {
        ArrayList<IPredicate> l = new ArrayList<IPredicate>();
        for (ILambdaFormula f : fs) {
            l.add(this.createAndRegisterPredicate(f));
        }
        return l;
    }

    public ILambdaFormula createConstraintForString(String str) {
        IPositionSetVariable S = this.ffactory.createPositionSetVariable("S");
        IFormula f = this.createIsString(str, S);
        return LambdaFormula.make(f, S);
    }

    public ILambdaFormula createConstraintForRegexp(String regexp) {
        IPositionSetVariable S = this.ffactory.createPositionSetVariable("S");
        IFormula f = this.createIsRegexp(regexp, S);
        return LambdaFormula.make(f, S);
    }

    public ILambdaFormula createConstraintForStringPredicate(IPredicate pred) {
        IPositionSetVariable S = this.ffactory.createPositionSetVariable("S");
        IFormula f = this.ffactory.createApplyPredicate(pred, S);
        return LambdaFormula.make(f, S);
    }

    public ILambdaFormula createConstraintForTemplate(String name, List<String> subscripts, List<ILambdaFormula> fs) {
        List<IPredicate> preds2 = this.createAndRegisterPredicates(fs);
        IPositionSetVariable S = this.ffactory.createPositionSetVariable("S");
        M2LTranslator tr = this.templateMap.get(name);
        IFormula f = tr.instantiate(this.ffactory, null, S, preds2.toArray(new IPredicate[preds2.size()]));
        return LambdaFormula.make(f, S);
    }

    public ILambdaFormula createConstraintForIndex(int num) {
        IPositionSetVariable S = this.ffactory.createPositionSetVariable("S");
        IPositionVariable n = this.ffactory.createPositionVariable("n");
        return LambdaFormula.make(this.ffactory.createPos(num, n, S), n, S);
    }

    public ILambdaFormula createConstraintForIndexPredicate(IPredicate pred) {
        IPositionSetVariable S = this.ffactory.createPositionSetVariable("S");
        IPositionVariable n = this.ffactory.createPositionVariable("n");
        IFormula f = this.ffactory.createApplyPredicate(pred, n, S);
        return LambdaFormula.make(f, n, S);
    }

    public ILambdaFormula createConstraintForIndexTemplate(String name, List<String> subscripts, List<ILambdaFormula> fs) {
        List<IPredicate> preds2 = this.createAndRegisterPredicates(fs);
        IPositionSetVariable S = this.ffactory.createPositionSetVariable("S");
        IPositionVariable n = this.ffactory.createPositionVariable("n");
        M2LTranslator tr = this.templateMap.get(name);
        IFormula f1 = tr.instantiate(this.ffactory, n, S, preds2.toArray(new IPredicate[preds2.size()]));
        return LambdaFormula.make(f1, n, S);
    }

    private static String gvar(String p, String s) {
        if (MONAFormulaFactory.getPredefinedVariables().contains(s)) {
            return s;
        }
        return "_" + p + "_" + s + "_";
    }

    private static boolean isGVar(String p, String s) {
        return s.startsWith("_" + p + "_") && s.endsWith("_");
    }

    private static String ivar(String s) {
        return ParserUtil.gvar("I", s);
    }

    private static String ovar(String s) {
        return ParserUtil.gvar("O", s);
    }

    private static boolean isIVar(String s) {
        return ParserUtil.isGVar("I", s);
    }

    private static boolean isOVar(String s) {
        return ParserUtil.isGVar("O", s);
    }

    private List<String> readFreeVariables(File file) throws IOException {
        BufferedReader rd = new BufferedReader(new FileReader(file));
        rd.readLine();
        rd.readLine();
        String line = rd.readLine();
        rd.close();
        if (line == null) {
            throw new RuntimeException("wrong format: " + file);
        }
        if (line.startsWith("variables:")) {
            ArrayList<String> vars = new ArrayList<String>();
            line = line.substring(line.indexOf(":") + 2).trim();
            int i = 0;
            int n = line.indexOf(" ");
            while (n > 0) {
                String s = line.substring(i, n);
                vars.add(s);
                i = n + 1;
                n = line.indexOf(" ", i);
            }
            vars.add(line.substring(i));
            return vars;
        }
        return Collections.emptyList();
    }

    public ILambdaFormula createImport(String filename, List<ILambdaFormula> params) {
        ArrayList<String> vars;
        ArrayList<IVariable> exVars;
        ArrayList<IVariable> globalVars;
        ArrayList<IPositionSetVariable> outVars;
        ArrayList<IPositionSetVariable> inVars;
        File file;
        block16: {
            file = this.dfaFinder.findFile(filename);
            if (file == null) {
                throw new RuntimeException("cannot find the DFA file: " + filename);
            }
            inVars = new ArrayList<IPositionSetVariable>();
            outVars = new ArrayList<IPositionSetVariable>();
            globalVars = new ArrayList<IVariable>();
            exVars = new ArrayList<IVariable>();
            vars = new ArrayList<String>();
            try {
                vars.addAll(this.readFreeVariables(file));
            }
            catch (IOException e) {
                SAUtil.println((Object)e.getMessage());
                if (!SAUtil.DEBUG) break block16;
                e.printStackTrace();
            }
        }
        for (String v : vars) {
            if (ParserUtil.isIVar(v)) {
                inVars.add(this.ffactory.createPositionSetVariable(v));
                continue;
            }
            if (ParserUtil.isOVar(v)) {
                outVars.add(this.ffactory.createPositionSetVariable(v));
                continue;
            }
            IVariable v1 = this.lookupVariable(v);
            if (v1 == null) {
                exVars.add(v1);
                continue;
            }
            globalVars.add(v1);
        }
        if (inVars.size() != params.size()) {
            SAUtil.println((Object)"parameters are inconsistent with input variables.");
            SAUtil.println((Object)("  file name: " + filename));
            SAUtil.println((Object)("  input variables: " + inVars));
            SAUtil.println((Object)("  parameters: " + params));
        }
        IFormula importFormula = this.createImportFormula(file, inVars, outVars, globalVars, exVars);
        IFormula inFormula = null;
        IPositionSetVariable R = this.ffactory.createPositionSetVariable("R");
        IPositionVariable sep = this.ffactory.createPositionVariable("sep");
        IPositionSet Sep = this.ffactory.createPositionSet(sep);
        IFormula fsep = this.ffactory.createIsSeparator(sep);
        for (int i = 0; i < params.size(); ++i) {
            ILambdaFormula p = params.get(i);
            ILambdaFormula c = LambdaFormula.make(R, this.ffactory.createExists(sep, this.ffactory.createExists((IPositionSetVariable)p.getVariable(0), this.ffactory.createAnd(this.ffactory.createAnd(p.getFormula(), fsep), this.ffactory.createIsConcat(R, (IPositionSetVariable)p.getVariable(0), Sep)))));
            p = DeclarationSets.createIteration(c, this.ffactory);
            IPositionSetVariable iPositionSetVariable = (IPositionSetVariable)inVars.get(i);
            IFormula pf = p.apply(iPositionSetVariable);
            inFormula = inFormula == null ? pf : this.ffactory.createAnd(inFormula, pf);
        }
        IFormula outFormula = null;
        IPositionSetVariable O = this.ffactory.createPositionSetVariable("O");
        for (IPositionSetVariable iPositionSetVariable : outVars) {
            IFormula choice = this.ffactory.createChoice(O, iPositionSetVariable);
            outFormula = outFormula == null ? choice : this.ffactory.createOr(outFormula, choice);
        }
        IFormula f = importFormula;
        if (inFormula != null) {
            f = this.ffactory.createAnd(inFormula, f);
        }
        if (outFormula != null) {
            f = this.ffactory.createAnd(outFormula, f);
        }
        for (IPositionSetVariable outVar : outVars) {
            f = this.ffactory.createExists(outVar, f);
        }
        ArrayList<IPositionSetVariable> arrayList = new ArrayList<IPositionSetVariable>(inVars);
        Collections.reverse(arrayList);
        for (IPositionSetVariable inVar : arrayList) {
            f = this.ffactory.createExists(inVar, f);
        }
        for (IVariable exVar : exVars) {
            if (exVar instanceof IPositionSetVariable) {
                f = this.ffactory.createExists((IPositionSetVariable)exVar, f);
                continue;
            }
            if (!(exVar instanceof IPositionVariable)) continue;
            f = this.ffactory.createExists((IPositionVariable)exVar, f);
        }
        return LambdaFormula.make(O, f);
    }

    private IFormula createImportFormula(File file, List<IPositionSetVariable> inVars, List<IPositionSetVariable> outVars, List<IVariable> globalVars, List<IVariable> exVars) {
        StringBuffer buff = new StringBuffer();
        buff.append("import(");
        buff.append("\"" + file.getAbsolutePath() + "\"");
        buff.append(", ");
        for (IVariable globalVar : globalVars) {
            buff.append(globalVar + "->" + globalVar + ",");
        }
        for (IVariable exVar : exVars) {
            buff.append(exVar + "->" + exVar + ",");
        }
        for (IPositionSetVariable inVar : inVars) {
            buff.append(inVar + "->" + inVar + ",");
        }
        for (IPositionSetVariable outVar : outVars) {
            buff.append(outVar + "->" + outVar + ",");
        }
        buff.deleteCharAt(buff.length() - 1);
        buff.append(")");
        final String expr = buff.toString();
        IFormula importFormula = new IFormula(){

            @Override
            public IFormula replaceTerm(Function<IVariable, ITerm> m) {
                return this;
            }

            public String toString() {
                return expr;
            }
        };
        return importFormula;
    }

    public List<IDeclaration> createAndRegisterOutputSVar(IPredicate pred) {
        IPositionSetVariable v = this.ffactory.createPositionSetVariable(ParserUtil.ovar(pred.getName()));
        this.registerVariable(v);
        IPositionSetVariableDefinition d1 = this.ffactory.createPositionSetVariableDefinition(v);
        IPositionSetVariable R = this.ffactory.createPositionSetVariable("R");
        IPositionSetVariable S = this.ffactory.createPositionSetVariable("S");
        IPositionVariable P = this.ffactory.createPositionVariable("P");
        IFormula fs = this.ffactory.createApplyPredicate(pred, S);
        IFormula fp = this.ffactory.createIsSeparator(P);
        IFormula fr = this.ffactory.createIsConcat(R, S, this.ffactory.createPositionSet(P));
        IFormula f = this.ffactory.createExists(S, this.ffactory.createExists(P, this.ffactory.createAnd(fr, this.ffactory.createAnd(fs, fp))));
        ILambdaFormula f2 = DeclarationSets.createIteration(LambdaFormula.make(R, f), this.ffactory);
        IFormula f3 = f2.apply(v);
        IFormula c1 = this.ffactory.createNot(this.ffactory.createIsEmpty(v));
        IFormula f4 = this.ffactory.createAnd(f3, c1);
        IFormulaDeclaration d2 = this.ffactory.createFormulaDeclaration(f4);
        return Arrays.asList(d1, d2);
    }

    public List<IDeclaration> createAndRegisterInputSVar(String name) {
        IPositionSetVariable v = this.ffactory.createPositionSetVariable(ParserUtil.ivar(name));
        IPositionSetVariableDefinition d1 = this.ffactory.createPositionSetVariableDefinition(v);
        this.registerVariable(v);
        IPositionSetVariable R = this.ffactory.createPositionSetVariable("R");
        ILambdaFormula f = LambdaFormula.make(R, this.ffactory.createChoice(R, v));
        IPredicateDeclaration d2 = this.createAndRegisterPredicateDeclaration(name, f);
        return Arrays.asList(d1, d2);
    }

    public List<IDeclaration> createAssertion(String vname, ILambdaFormula f) {
        IFormula g = f.getFormula();
        final IPositionSetVariable var = this.ffactory.createPositionSetVariable(vname);
        if (f.getArity() == 1) {
            final IVariable v = f.getVariable(0);
            IPositionSetVariableDefinition d1 = this.ffactory.createPositionSetVariableDefinition(var);
            IFormulaDeclaration d2 = this.ffactory.createFormulaDeclaration(g.replaceTerm(new Function<IVariable, ITerm>(){

                public ITerm apply(IVariable w) {
                    if (w.getName().equals(v.getName())) {
                        return var;
                    }
                    return w;
                }
            }));
            if (this.lookupVariable(var.getName()) == null) {
                this.registerVariable(var);
                return Arrays.asList(d1, d2);
            }
            return Arrays.asList(d2);
        }
        throw new UnimplementedError("unsupported variable type: " + var.getClass());
    }

    public IFormulaDeclaration createAssertion(ILambdaFormula f) {
        IFormula g = f.getFormula();
        for (int i = 0; i < f.getArity(); ++i) {
            IVariable v = f.getVariable(i);
            if (v instanceof IPositionSetVariable) {
                g = this.ffactory.createForall((IPositionSetVariable)v, g);
                continue;
            }
            if (v instanceof IPositionVariable) {
                g = this.ffactory.createForall((IPositionVariable)v, g);
                continue;
            }
            throw new UnimplementedError("createAssertion");
        }
        return this.ffactory.createFormulaDeclaration(g);
    }

    public void addDeclaration(IDeclaration decl) {
        this.decls.add(decl);
    }

    public void addDeclarations(List<IDeclaration> decls) {
        for (IDeclaration decl : decls) {
            this.addDeclaration(decl);
        }
    }

    public List<IDeclaration> getDeclarations() {
        return this.decls;
    }

    public Object[] createPair(Object obj1, Object obj2) {
        return new Object[]{obj1, obj2};
    }

    public <T> List<T> createList(T obj) {
        List<T> l = this.createList();
        l.add(obj);
        return l;
    }

    public <T> List<T> createList() {
        LinkedList l = new LinkedList();
        return l;
    }

    public List<IDeclaration> createFormulaDeclaration(IFormula f) {
        return this.createList(this.ffactory.createFormulaDeclaration(f));
    }

    public List<IDeclaration> createPositionVariableDefinition(List<Pair<IVariable, IFormula>> syms) {
        ArrayList<IDeclaration> decls = new ArrayList<IDeclaration>();
        for (Pair<IVariable, IFormula> o : syms) {
            IPositionVariable v = (IPositionVariable)o.fst;
            IFormula f = (IFormula)o.snd;
            IPositionVariableDefinition decl = f == null ? this.ffactory.createPositionVariableDefinition(v) : this.ffactory.createPositionVariableDefinitionWhere(v, f);
            decls.add(decl);
        }
        return decls;
    }

    public List<IDeclaration> createPositionSetVariableDefinition(List<Pair<IVariable, IFormula>> syms) {
        ArrayList<IDeclaration> decls = new ArrayList<IDeclaration>();
        for (Pair<IVariable, IFormula> o : syms) {
            IPositionSetVariable v = (IPositionSetVariable)o.fst;
            IFormula f = (IFormula)o.snd;
            IPositionSetVariableDefinition decl = f == null ? this.ffactory.createPositionSetVariableDefinition(v) : this.ffactory.createPositionSetVariableDefinitionWhere(v, f);
            decls.add(decl);
        }
        return decls;
    }

    public List<IDeclaration> createAndRegisterAllPosDeclaration(final IPositionSetVariable v) {
        IDeclaration decl = new IDeclaration(){

            public String toString() {
                return "allpos " + v;
            }
        };
        this.registerVariable(v);
        return this.createList(decl);
    }

    public List<IDeclaration> createDefaultWhere1(final IPositionVariable var, final IFormula f) {
        IDeclaration decl = new IDeclaration(){

            public String toString() {
                return "defaultwhere1(" + var + ") = " + f.toString();
            }
        };
        return this.createList(decl);
    }

    public List<IDeclaration> createDefaultWhere2(final IPositionSetVariable var, final IFormula f) {
        IDeclaration decl = new IDeclaration(){

            public String toString() {
                return "defaultwhere2(" + var + ") = " + f.toString();
            }
        };
        return this.createList(decl);
    }

    public IPredicateDeclaration createAndRegisterPredicateDeclaration(String predName, ILambdaFormula f) {
        ArrayList<IVariable> vars = new ArrayList<IVariable>();
        for (int i = 0; i < f.getArity(); ++i) {
            vars.add(f.getVariable(i));
        }
        return this.createAndRegisterPredicateDeclaration(predName, vars, f.getFormula());
    }

    public IPredicateDeclaration createAndRegisterPredicateDeclaration(String predName, List<IVariable> vars, IFormula formula) {
        IPredicate.ArgType[] argTypes = new IPredicate.ArgType[vars.size()];
        for (int i = 0; i < argTypes.length; ++i) {
            IVariable v = vars.get(i);
            argTypes[i] = v instanceof IPositionSetVariable ? IPredicate.ArgType.POSITION_SET : (v instanceof IPositionVariable ? IPredicate.ArgType.POSITION : null);
        }
        IPredicate pred = this.ffactory.createPredicate(predName, argTypes.length, argTypes);
        IPredicateDeclaration decl = this.ffactory.createPredicateDeclaration(pred, formula, vars.toArray(new IVariable[vars.size()]));
        this.registerPredicate(pred);
        return decl;
    }

    public IFormula createApplyPredicate(IPredicate pred, List<ITerm> terms) {
        IPredicate.ArgType[] argTypes = new IPredicate.ArgType[terms.size()];
        for (int i = 0; i < argTypes.length; ++i) {
            ITerm term = terms.get(i);
            argTypes[i] = term instanceof IPositionSetTerm ? IPredicate.ArgType.POSITION_SET : (term instanceof IPositionTerm ? IPredicate.ArgType.POSITION : (term instanceof IBoolean ? IPredicate.ArgType.BOOLEAN : null));
        }
        IFormula f = this.ffactory.createApplyPredicate(pred, terms.toArray(new ITerm[terms.size()]));
        return f;
    }

    public IFormula createQuantified(String q, List<Pair<IVariable, IFormula>> varWhereList, IFormula f) {
        Collections.reverse(varWhereList);
        for (Pair<IVariable, IFormula> varWhere : varWhereList) {
            IVariable var = (IVariable)varWhere.fst;
            IFormula where = (IFormula)varWhere.snd;
            if (q.equals("ex1")) {
                if (where == null) {
                    f = this.ffactory.createExists((IPositionVariable)var, f);
                    continue;
                }
                f = this.ffactory.createExistsWhere((IPositionVariable)var, where, f);
                continue;
            }
            if (q.equals("ex2")) {
                if (where == null) {
                    f = this.ffactory.createExists((IPositionSetVariable)var, f);
                    continue;
                }
                f = this.ffactory.createExistsWhere((IPositionSetVariable)var, where, f);
                continue;
            }
            if (q.equals("all1")) {
                if (where == null) {
                    f = this.ffactory.createForall((IPositionVariable)var, f);
                    continue;
                }
                f = this.ffactory.createForallWhere((IPositionVariable)var, where, f);
                continue;
            }
            if (q.equals("all2")) {
                if (where == null) {
                    f = this.ffactory.createForall((IPositionSetVariable)var, f);
                    continue;
                }
                f = this.ffactory.createForallWhere((IPositionSetVariable)var, where, f);
                continue;
            }
            throw new ParserException();
        }
        return f;
    }

    List<IPositionSetVariable> createPositionSetVariables(List<String> l) {
        ArrayList<IPositionSetVariable> ret = new ArrayList<IPositionSetVariable>();
        for (String s : l) {
            ret.add(this.ffactory.createPositionSetVariable(s));
        }
        return ret;
    }

    List<IPositionVariable> createPositionVariables(List<String> l) {
        ArrayList<IPositionVariable> ret = new ArrayList<IPositionVariable>();
        for (String s : l) {
            ret.add(this.ffactory.createPositionVariable(s));
        }
        return ret;
    }

    static {
        symKind.put("pred", 257);
        symKind.put("macro", 258);
        symKind.put("defaultwhere1", 260);
        symKind.put("defaultwhere2", 261);
        symKind.put("where", 266);
        symKind.put("var1", 262);
        symKind.put("var2", 263);
        symKind.put("ex1", 267);
        symKind.put("ex2", 268);
        symKind.put("all1", 269);
        symKind.put("all2", 270);
        symKind.put("allpos", 259);
        symKind.put("union", 274);
        symKind.put("inter", 275);
        symKind.put("sub", 276);
        symKind.put("in", 277);
        symKind.put("notin", 278);
        symKind.put("true", 297);
        symKind.put("false", 298);
        symKind.put("empty", 281);
        symKind.put("svar", 264);
        symKind.put("ivar", 265);
        symKind.put("assert", 282);
        symKind.put("rec", 284);
        symKind.put("and", 283);
        symKind.put("input", 285);
        symKind.put("output", 286);
        dfaVarsPattern = Pattern.compile("variables:(\\s\\S+)*");
    }

    public class Env {
        public Map<String, IPredicate> predMap = new HashMap<String, IPredicate>();
        public Map<String, IVariable> varMap = new HashMap<String, IVariable>();
    }
}

