/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.java.client;

import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.SSAPropagationCallGraphBuilder;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ZeroXInstanceKeys;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.stringAnalysis.callgraph.SelectiveOneLevelContextSelector;
import com.ibm.wala.stringAnalysis.java.callgraph.Util;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import java.io.File;
import java.io.IOException;

public class JavaBytecodeStringAnalysisEngine
extends AbstractAnalysisEngine {
    protected CallGraphBuilder getCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache) {
        SSAPropagationCallGraphBuilder builder = Util.makeZeroCFABuilder((AnalysisOptions)options, (AnalysisCache)cache, (IClassHierarchy)cha, (AnalysisScope)this.scope);
        ZeroXInstanceKeys zik = new ZeroXInstanceKeys(options, cha, builder.getContextInterpreter(), 1);
        builder.setInstanceKeys((InstanceKeyFactory)zik);
        builder.setContextSelector((ContextSelector)new SelectiveOneLevelContextSelector());
        Util.addBypassLogicForStringAnalysis(options, this.scope, cha);
        return builder;
    }

    public AnalysisOptions getDefaultOptions(Iterable<Entrypoint> entrypoints) {
        AnalysisOptions options = new AnalysisOptions(this.getScope(), entrypoints);
        SSAOptions ssaOptions = new SSAOptions();
        ssaOptions.setDefaultValues(SAUtil.getDefaultValues());
        options.setSSAOptions(ssaOptions);
        options.setUseConstantSpecificKeys(true);
        return options;
    }

    public void buildAnalysisScope() throws IOException {
        if (this.j2seLibs == null) {
            Assertions.UNREACHABLE((String)"no j2selibs specified. You probably did not call AppAnalysisEngine.setJ2SELibrary.");
        }
        this.scope = AnalysisScopeReader.readJavaScope((String)"SyntheticJ2SEModel.txt", (File)new FileProvider().getFile(this.getExclusionsFile()), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        for (int i = 0; i < this.j2seLibs.length; ++i) {
            this.scope.addToScope(this.scope.getPrimordialLoader(), this.j2seLibs[i]);
        }
        this.addApplicationModulesToScope();
    }
}

