/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.eclipse.utils;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class EclipseUtil {
    public static final String CLASSPATH = "additional_classpath";
    public static final String OUTPUT_DIR = "output_dir";
    public static final String WEB_CONTENT = "web_content";
    public static final String PROJECTS = "projects";
    public static final String SPLITTER = ";";
    public static final String META_DATA = ".metadata";
    public static final String WORKSPACE = "workspace";
    public static final String JDK_PATH = "jdk_path";
    public static final String SRC_ROOT = "src_root";
    public static final String JUNIT_TEST_FOLDER = "test";

    public static final boolean isWorkspace(File workspace) {
        if (workspace.isDirectory() && workspace.exists()) {
            String[] files = workspace.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(EclipseUtil.META_DATA);
                }
            });
            return files.length > 0;
        }
        return false;
    }

    public static final boolean isJavaProject(String project) {
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        IJavaProject javaProject = model.getJavaProject(project);
        return javaProject != null;
    }
}

