/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.DMap;
import com.ibm.wala.automaton.LabeledString;
import com.ibm.wala.automaton.grammar.string.CFLTranslator;
import com.ibm.wala.automaton.grammar.string.ContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.DeepGrammarCopier;
import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleVisitor;
import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.RTNRegularApproximation;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.grammar.string.SimpleGrammarCopier;
import com.ibm.wala.automaton.grammar.string.SimpleRuleCopier;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.BooleanSymbol;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.DeepSTSCopier;
import com.ibm.wala.automaton.string.FreshVariableFactory;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.ILabelSymbol;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolFactory;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.LabeledSymbol;
import com.ibm.wala.automaton.string.MatchContext;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.SimpleSTSCopier;
import com.ibm.wala.automaton.string.SimpleSymbolCopier;
import com.ibm.wala.automaton.string.SimpleTransitionCopier;
import com.ibm.wala.automaton.string.SimpleVariableFactory;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.automaton.string.VariableReplacer;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Grammars {
    public static String variablePrefix = "v";

    public static Set<ISymbol> collectTerminals(IGrammar ... grammars) {
        final HashSet<ISymbol> terminals = new HashSet<ISymbol>();
        for (IGrammar g : grammars) {
            g.traverseRules(new IRuleVisitor(){

                @Override
                public void onVisit(IProductionRule rule) {
                    rule.traverseSymbols(new ISymbolVisitor(){
                        private boolean inRange = false;

                        @Override
                        public void onVisit(ISymbol symbol) {
                            if (this.inRange) {
                                return;
                            }
                            if (symbol instanceof IVariable) {
                                return;
                            }
                            if (symbol instanceof RangeSymbol) {
                                this.inRange = true;
                            }
                            terminals.add(symbol);
                        }

                        @Override
                        public void onLeave(ISymbol symbol) {
                            if (symbol instanceof RangeSymbol) {
                                this.inRange = false;
                            }
                        }
                    });
                }
            });
        }
        return terminals;
    }

    public static void collectReachableRules(IGrammar grammar, Collection<? extends IVariable> v, Set<IProductionRule> rules) {
        final HashSet ss = new HashSet();
        ISymbolVisitor collector = new ISymbolVisitor(){

            @Override
            public void onVisit(ISymbol symbol) {
                if (symbol instanceof IVariable) {
                    ss.add((IVariable)symbol);
                }
            }

            @Override
            public void onLeave(ISymbol symbol) {
            }
        };
        HashSet<IProductionRule> rs = new HashSet<IProductionRule>();
        for (IVariable iVariable : v) {
            rs.addAll(grammar.getRules(iVariable));
        }
        for (IProductionRule iProductionRule : rs) {
            if (rules.contains(iProductionRule)) continue;
            rules.add(iProductionRule);
            for (ISymbol sym : iProductionRule.getRight()) {
                sym.traverse(collector);
            }
        }
        if (!ss.isEmpty()) {
            Grammars.collectReachableRules(grammar, ss, rules);
        }
    }

    public static Set<IVariable> collectVariables(IGrammar grammar) {
        final HashSet<IVariable> vars = new HashSet<IVariable>();
        grammar.traverseSymbols(new ISymbolVisitor(){

            @Override
            public void onLeave(ISymbol symbol) {
                if (symbol instanceof IVariable) {
                    vars.add((IVariable)symbol);
                }
            }

            @Override
            public void onVisit(ISymbol symbol) {
            }
        });
        return vars;
    }

    public static Collection<IVariable> collectUsedVariables(IGrammar grammar) {
        return Grammars.collectUsedVariables(grammar, Collections.singleton(grammar.getStartSymbol()));
    }

    public static Collection<IVariable> collectUsedVariables(IGrammar grammar, Collection<? extends IVariable> v) {
        HashSet<IVariable> usedVars = new HashSet<IVariable>();
        Grammars.collectUsedVariables(grammar, v, usedVars);
        return usedVars;
    }

    public static void collectUsedVariables(IGrammar grammar, Collection<? extends IVariable> v, final Collection<IVariable> s) {
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        Grammars.collectReachableRules(grammar, v, rules);
        for (IProductionRule rule : rules) {
            rule.traverseSymbols(new ISymbolVisitor(){

                @Override
                public void onVisit(ISymbol symbol) {
                    if (symbol instanceof IVariable) {
                        s.add((IVariable)symbol);
                    }
                }

                @Override
                public void onLeave(ISymbol symbol) {
                }
            });
        }
        if (grammar.getStartSymbol() != null) {
            s.add(grammar.getStartSymbol());
        }
    }

    public static Collection<String> collectVariableNames(Collection<IVariable> variables) {
        return AUtil.collect(variables, new AUtil.IElementMapper<IVariable, String>(){

            @Override
            public String map(IVariable var) {
                return var.getName();
            }
        });
    }

    public static Collection<IVariable> collectLeftVariables(IGrammar g) {
        final HashSet<IVariable> vars = new HashSet<IVariable>();
        g.traverseRules(new IRuleVisitor(){

            @Override
            public void onVisit(IProductionRule rule) {
                vars.add(rule.getLeft());
            }
        });
        return vars;
    }

    public static IGrammar useUniqueVariables(IGrammar g1, Set<IVariable> vars, Map<IVariable, IVariable> m) {
        FreshVariableFactory varFactory = new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, Grammars.collectVariableNames(vars));
        return Grammars.useUniqueVariables(g1, varFactory, m);
    }

    public static <T extends IGrammar> T useUniqueVariables(T g1, T g2, Map<IVariable, IVariable> m) {
        FreshVariableFactory varFactory = new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, g2);
        return Grammars.useUniqueVariables(g1, varFactory, m);
    }

    public static <T extends IGrammar> T useUniqueVariables(T g, IVariableFactory<? extends IVariable> varFactory, Map<IVariable, IVariable> m) {
        g = g.copy(new DeepGrammarCopier(new DeepRuleCopier(Grammars.createUniqueVariableReplacer(g, varFactory, m))));
        return g;
    }

    public static VariableReplacer createUniqueVariableReplacer(IGrammar g, IVariableFactory<? extends IVariable> varFactory, Map<IVariable, IVariable> m) {
        Set<IVariable> variables = g.getNonterminals();
        for (IVariable v : variables) {
            IVariable newVar = varFactory.createVariable(variablePrefix);
            m.put(v, newVar);
        }
        MatchContext mctx = new MatchContext(m);
        return new VariableReplacer(mctx);
    }

    public static void normalize(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        Collection<IVariable> vars = Grammars.collectUsedVariables(cfg);
        Grammars.eliminateEpsilonRules(cfg);
        Grammars.eliminateUnitRules(cfg);
        Grammars.simplifyRules(cfg, varFactory);
        Grammars.moveTerminalsToUnitRules(cfg, varFactory);
        Grammars.eliminateDanglingVariables(cfg, vars);
        Grammars.eliminateUselessRules(cfg);
    }

    public static IContextFreeGrammar reduceRules(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        if (varFactory == null) {
            varFactory = new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, cfg);
        }
        cfg = (IContextFreeGrammar)cfg.copy(new DeepGrammarCopier(new DeepRuleCopier(SimpleSymbolCopier.defaultCopier)));
        HashSet<IProductionRule> removed = new HashSet<IProductionRule>();
        HashSet<ProductionRule> added = new HashSet<ProductionRule>();
        do {
            cfg.getRules().removeAll(removed);
            cfg.addRules(added);
            removed.clear();
            added.clear();
            for (IProductionRule iProductionRule : cfg.getRules()) {
                List<ISymbol> r1 = iProductionRule.getRight();
                if (r1.size() <= 2) continue;
                ISymbol s11 = r1.get(0);
                ISymbol s12 = r1.get(1);
                for (IProductionRule rule2 : cfg.getRules()) {
                    List<ISymbol> r2;
                    if (iProductionRule.equals(rule2) || (r2 = rule2.getRight()).size() <= 2) continue;
                    ISymbol s21 = r2.get(0);
                    ISymbol s22 = r2.get(1);
                    if (!s11.equals(s21) || !s12.equals(s22)) continue;
                    Object v = varFactory.createVariable(variablePrefix);
                    ArrayList<ISymbol> s13 = new ArrayList<ISymbol>(r1.subList(2, r1.size()));
                    ArrayList<ISymbol> s23 = new ArrayList<ISymbol>(r2.subList(2, r2.size()));
                    added.add(new ProductionRule((IVariable)v, s11, s12));
                    s13.add(0, (ISymbol)v);
                    s23.add(0, (ISymbol)v);
                    added.add(new ProductionRule(iProductionRule.getLeft(), s13));
                    added.add(new ProductionRule(rule2.getLeft(), s23));
                    removed.add(iProductionRule);
                    removed.add(rule2);
                }
            }
        } while (!removed.isEmpty());
        while (true) {
            HashMap<List<ISymbol>, HashSet<IVariable>> m = new HashMap<List<ISymbol>, HashSet<IVariable>>();
            for (IProductionRule rule : cfg.getRules()) {
                HashSet<IVariable> vars = (HashSet<IVariable>)m.get(rule.getRight());
                if (vars == null) {
                    vars = new HashSet<IVariable>();
                    m.put(rule.getRight(), vars);
                }
                vars.add(rule.getLeft());
            }
            HashMap hashMap = new HashMap();
            for (Map.Entry e : m.entrySet()) {
                Set vars = (Set)e.getValue();
                if (vars.size() <= 1) continue;
                Iterator i = vars.iterator();
                IVariable v = (IVariable)i.next();
                while (i.hasNext()) {
                    hashMap.put(i.next(), v);
                }
            }
            if (hashMap.isEmpty()) {
                return cfg;
            }
            cfg = (IContextFreeGrammar)cfg.copy(new DeepGrammarCopier(new DeepRuleCopier(new VariableReplacer(hashMap))));
        }
    }

    public static void eliminateEpsilonRules(IGrammar g) {
        Grammars.eliminateEpsilonRules_v2(g);
    }

    public static void eliminateEpsilonRules_v2(IGrammar g) {
        IVariable start = g.getStartSymbol();
        HashSet<IVariable> epsilonVars = new HashSet<IVariable>();
        HashSet<IVariable> leftVars = new HashSet<IVariable>();
        HashSet<IProductionRule> allNullRules = new HashSet<IProductionRule>();
        HashSet<IProductionRule> nullRules = new HashSet<IProductionRule>();
        HashSet<IProductionRule> nonNullRules = new HashSet<IProductionRule>();
        while (true) {
            nullRules.clear();
            nonNullRules.clear();
            epsilonVars.clear();
            leftVars.clear();
            Grammars.collectNullRules(g, nullRules, nonNullRules);
            g.getRules().removeAll(nullRules);
            for (IProductionRule r : nullRules) {
                IVariable v = r.getLeft();
                if (v.equals(start)) {
                    g.getRules().add(r);
                    nonNullRules.add(r);
                    continue;
                }
                epsilonVars.add(v);
            }
            for (IProductionRule r : nonNullRules) {
                leftVars.add(r.getLeft());
            }
            if (epsilonVars.isEmpty()) break;
            allNullRules.addAll(nullRules);
            HashSet<ProductionRule> newRules = new HashSet<ProductionRule>();
            Iterator<IProductionRule> i = g.getRules().iterator();
            while (i.hasNext()) {
                IProductionRule rule = i.next();
                List<ISymbol> right = rule.getRight();
                if (!Grammars.contains(epsilonVars, right)) continue;
                i.remove();
                for (List<ISymbol> l : Grammars.eliminateEpsilonVar(new ArrayList<ISymbol>(right), epsilonVars, leftVars)) {
                    ProductionRule r = new ProductionRule(rule.getLeft(), l);
                    if (allNullRules.contains(r)) continue;
                    newRules.add(r);
                }
            }
            g.getRules().addAll(newRules);
        }
    }

    public static void eliminateEpsilonRules_v0(IContextFreeGrammar cfg) {
        boolean isAcceptEpsilon = false;
        if (Grammars.acceptEpsilon(cfg, cfg.getStartSymbol())) {
            isAcceptEpsilon = true;
        }
        HashSet<IVariable> epsilonVars = new HashSet<IVariable>();
        IVariable epsilonVar = null;
        boolean existsNonEpsilon = false;
        while (true) {
            epsilonVar = null;
            existsNonEpsilon = false;
            Iterator<IProductionRule> i = cfg.getRules().iterator();
            while (i.hasNext()) {
                IProductionRule rule = i.next();
                if (!rule.isEpsilonRule()) continue;
                i.remove();
                epsilonVar = rule.getLeft();
                break;
            }
            cfg.getRules().remove(new ProductionRule(epsilonVar, (ISymbol)epsilonVar));
            if (!cfg.getRules(epsilonVar).isEmpty()) {
                existsNonEpsilon = true;
            }
            if (epsilonVar == null) break;
            epsilonVars.add(epsilonVar);
            HashSet<ProductionRule> newRules = new HashSet<ProductionRule>();
            Iterator<IProductionRule> i2 = cfg.getRules().iterator();
            while (i2.hasNext()) {
                IProductionRule rule = i2.next();
                ArrayList<ISymbol> right = new ArrayList<ISymbol>();
                boolean containsEpsilonVar = false;
                for (ISymbol v : rule.getRight()) {
                    if (epsilonVar.equals(v)) {
                        containsEpsilonVar = true;
                        continue;
                    }
                    right.add(v);
                }
                if (!containsEpsilonVar || right.isEmpty() && epsilonVars.contains(rule.getLeft())) continue;
                ProductionRule newRule = new ProductionRule(rule.getLeft(), right);
                newRules.add(newRule);
                if (existsNonEpsilon) continue;
                i2.remove();
            }
            cfg.addRules(newRules);
        }
        if (isAcceptEpsilon) {
            ProductionRule newRule = new ProductionRule(cfg.getStartSymbol(), new ISymbol[0]);
            cfg.addRule(newRule);
        }
    }

    private static <T> boolean contains(Collection<? extends T> c1, Collection<? extends T> c2) {
        for (T e : c1) {
            if (!c2.contains(e)) continue;
            return true;
        }
        return false;
    }

    private static void collectNullRules(IGrammar g, Collection<IProductionRule> nullRules, Collection<IProductionRule> nonNullRules) {
        HashSet<IProductionRule> visited = new HashSet<IProductionRule>();
        for (IProductionRule r : g.getRules()) {
            Grammars.isNullRule(r, g, nullRules, nonNullRules, visited);
        }
    }

    private static boolean isNullRule(IProductionRule rule, IGrammar g, Collection<IProductionRule> nullRules, Collection<IProductionRule> nonNullRules, Collection<IProductionRule> visited) {
        if (nullRules.contains(rule)) {
            return true;
        }
        if (nonNullRules.contains(rule)) {
            return false;
        }
        if (visited.contains(rule)) {
            return true;
        }
        visited.add(rule);
        for (ISymbol s : rule.getRight()) {
            if (s instanceof IVariable) {
                for (IProductionRule r : g.getRules((IVariable)s)) {
                    if (Grammars.isNullRule(r, g, nullRules, nonNullRules, visited)) continue;
                    nonNullRules.add(rule);
                    return false;
                }
                continue;
            }
            nonNullRules.add(rule);
            return false;
        }
        nullRules.add(rule);
        return true;
    }

    private static Collection<List<ISymbol>> eliminateEpsilonVar(List<ISymbol> l, Collection<IVariable> evars, Collection<IVariable> lvars) {
        if (l.isEmpty()) {
            HashSet<List<ISymbol>> r = new HashSet<List<ISymbol>>();
            r.add(new ArrayList());
            return r;
        }
        ISymbol s = l.get(0);
        l.remove(0);
        Collection<List<ISymbol>> r = Grammars.eliminateEpsilonVar(l, evars, lvars);
        if (evars.contains(s)) {
            if (lvars.contains(s)) {
                HashSet<ArrayList<ISymbol>> r2 = new HashSet<ArrayList<ISymbol>>();
                for (List<ISymbol> l2 : r) {
                    ArrayList<ISymbol> l3 = new ArrayList<ISymbol>(l2);
                    l3.add(0, s);
                    r2.add(l3);
                }
                r.addAll(r2);
            }
        } else {
            for (List<ISymbol> l2 : r) {
                l2.add(0, s);
            }
        }
        return r;
    }

    public static void eliminateUselessRules(IGrammar g) {
        Grammars.eliminateUselessRules(g, Collections.singleton(g.getStartSymbol()));
    }

    public static void eliminateUselessRules(IGrammar g, Collection<? extends IVariable> startSymbols) {
        HashSet<IProductionRule> rs = new HashSet<IProductionRule>();
        Grammars.collectReachableRules(g, startSymbols, rs);
        g.getRules().clear();
        g.getRules().addAll(rs);
    }

    public static void eliminateReflectiveRules(IGrammar g) {
        HashMap<IVariable, Set<ISymbol>> m = new HashMap<IVariable, Set<ISymbol>>();
        for (IProductionRule r : g.getRules()) {
            List<ISymbol> rhs = r.getRight();
            if (rhs.size() != 1) continue;
            ISymbol sym = rhs.get(0);
            IVariable lhv = r.getLeft();
            HashSet<ISymbol> syms = (HashSet<ISymbol>)m.get(lhv);
            if (syms == null) {
                syms = new HashSet<ISymbol>();
                m.put(lhv, syms);
            }
            syms.add(sym);
        }
        HashSet<IVariable> done = new HashSet<IVariable>();
        HashMap<IVariable, IVariable> replaceMap = new HashMap<IVariable, IVariable>();
        HashMap<IVariable, HashSet<ISymbol>> m2 = new HashMap<IVariable, HashSet<ISymbol>>();
        ArrayList keys = new ArrayList(m.keySet());
        if (keys.contains(g.getStartSymbol())) {
            keys.remove(g.getStartSymbol());
            keys.add(0, g.getStartSymbol());
        }
        for (IVariable key : keys) {
            if (done.contains(key)) continue;
            HashMap<IVariable, Set<ISymbol>> cache = new HashMap<IVariable, Set<ISymbol>>(m2);
            HashSet<ISymbol> ss = new HashSet<ISymbol>();
            Grammars.collectReachableSymbols(m, key, ss, new HashSet<IVariable>(), cache);
            ss.remove(g.getStartSymbol());
            if (ss.contains(key)) {
                for (ISymbol s : ss) {
                    if (!(s instanceof IVariable) || done.contains(s)) continue;
                    replaceMap.put((IVariable)s, key);
                    done.add((IVariable)s);
                }
            }
            m2.put(key, ss);
        }
        IGrammar g2 = g.copy(new DeepGrammarCopier(new DeepRuleCopier(new VariableReplacer(replaceMap))));
        Iterator<IProductionRule> i = g2.getRules().iterator();
        while (i.hasNext()) {
            IProductionRule r = i.next();
            if (r.getRight().size() != 1 || !r.getLeft().equals(r.getRight(0))) continue;
            i.remove();
        }
        g.getRules().clear();
        g.getRules().addAll(g2.getRules());
    }

    public static void eliminateLeftRecursion(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        HashSet<IVariable> done = new HashSet<IVariable>();
        HashSet<IProductionRule> add = new HashSet<IProductionRule>();
        HashSet<IProductionRule> rm = new HashSet<IProductionRule>();
        do {
            add.clear();
            rm.clear();
            for (IProductionRule rule : cfg.getRules()) {
                List<ISymbol> right;
                IVariable left = rule.getLeft();
                if (done.contains(left) || (right = rule.getRight()).isEmpty() || !left.equals(right.get(0))) continue;
                Grammars.eliminateLeftRecursion(cfg, left, varFactory, add, rm);
                done.add(left);
            }
            cfg.getRules().removeAll(rm);
            cfg.getRules().addAll(add);
        } while (!rm.isEmpty());
    }

    private static void eliminateLeftRecursion(IContextFreeGrammar cfg, IVariable left, IVariableFactory<IVariable> varFactory, Set<IProductionRule> add, Set<IProductionRule> rm) {
        IVariable nv = varFactory.createVariable(variablePrefix);
        ProductionRule er = new ProductionRule(nv, new ISymbol[0]);
        add.add(er);
        Set<IProductionRule> rs = cfg.getRules(left);
        rm.addAll(rs);
        for (IProductionRule r : rs) {
            ProductionRule nr;
            List<ISymbol> l = r.getRight();
            if (!l.isEmpty() && left.equals(l.get(0))) {
                l = new ArrayList<ISymbol>(l.subList(1, l.size()));
                l.add(nv);
                nr = new ProductionRule(nv, l);
                add.add(nr);
                continue;
            }
            l = new ArrayList<ISymbol>(l);
            l.add(nv);
            nr = new ProductionRule(left, l);
            add.add(nr);
        }
    }

    private static void collectReachableSymbols(Map<IVariable, Set<ISymbol>> m, IVariable v, Collection<ISymbol> result, Collection<IVariable> visited, Map<IVariable, Set<ISymbol>> cache) {
        if (cache.containsKey(v)) {
            result.addAll((Collection<ISymbol>)cache.get(v));
            return;
        }
        if (visited.contains(v)) {
            return;
        }
        visited.add(v);
        Set<ISymbol> syms = m.get(v);
        if (syms == null) {
            return;
        }
        for (ISymbol s : syms) {
            result.add(s);
            if (!(s instanceof IVariable) || visited.contains(s)) continue;
            Grammars.collectReachableSymbols(m, (IVariable)s, result, visited, cache);
        }
    }

    public static Set<ISymbol> eliminateDanglingVariables(IGrammar g, Collection<IVariable> usedVars, Set<IVariable> dvars) {
        if (usedVars == null) {
            usedVars = new HashSet<IVariable>();
        }
        if (dvars == null) {
            dvars = new HashSet<IVariable>();
        }
        final HashSet drules = new HashSet();
        final HashSet<ISymbol> rs = new HashSet<ISymbol>();
        do {
            drules.clear();
            final Collection<IVariable> vars = Grammars.collectLeftVariables(g);
            vars.addAll(usedVars);
            vars.addAll(dvars);
            g.traverseRules(new IRuleVisitor(){

                @Override
                public void onVisit(final IProductionRule rule) {
                    for (final ISymbol right : rule.getRight()) {
                        right.traverse(new ISymbolVisitor(){

                            @Override
                            public void onVisit(ISymbol symbol) {
                                if (symbol instanceof IVariable && !vars.contains(symbol)) {
                                    drules.add(rule);
                                    rs.add(right);
                                }
                            }

                            @Override
                            public void onLeave(ISymbol symbol) {
                            }
                        });
                    }
                }
            });
            Iterator<IProductionRule> i = g.getRules().iterator();
            while (i.hasNext()) {
                IProductionRule r = i.next();
                if (!drules.contains(r)) continue;
                i.remove();
            }
        } while (!drules.isEmpty());
        return rs;
    }

    public static Set<ISymbol> eliminateDanglingVariables(IGrammar g, Collection<IVariable> usedVars) {
        return Grammars.eliminateDanglingVariables(g, usedVars, new HashSet<IVariable>());
    }

    public static Set<ISymbol> eliminateDanglingVariables(IGrammar g) {
        return Grammars.eliminateDanglingVariables(g, new HashSet<IVariable>());
    }

    private static boolean acceptEpsilon(IContextFreeGrammar cfg, IVariable v) {
        return Grammars.acceptEpsilon(cfg, v, new HashSet<IVariable>());
    }

    private static boolean acceptEpsilon(IContextFreeGrammar cfg, IVariable v, Collection<IVariable> history) {
        if (history.contains(v)) {
            return false;
        }
        history.add(v);
        for (IProductionRule rule : cfg.getRules(v)) {
            if (rule.isEpsilonRule()) {
                return true;
            }
            boolean allEpsilon = true;
            for (ISymbol sym : rule.getRight()) {
                if (sym instanceof IVariable) {
                    if (Grammars.acceptEpsilon(cfg, (IVariable)sym, history)) continue;
                    allEpsilon = false;
                    break;
                }
                allEpsilon = false;
                break;
            }
            if (!allEpsilon) continue;
            return true;
        }
        return false;
    }

    public static void eliminateUnitRules(IGrammar g) {
        ArrayList<IProductionRule> unitRules = new ArrayList<IProductionRule>();
        ArrayList<ProductionRule> newRules = new ArrayList<ProductionRule>();
        for (IProductionRule rule : g.getRules()) {
            if (rule.getRight().size() != 1 || !(rule.getRight().get(0) instanceof IVariable)) continue;
            unitRules.add(rule);
        }
        for (IProductionRule rule : unitRules) {
            IVariable lv = rule.getLeft();
            IVariable rv = (IVariable)rule.getRight().get(0);
            for (IProductionRule r : Grammars.getNonUnitRules(g, rv)) {
                ProductionRule newRule = new ProductionRule(lv, r.getRight());
                newRules.add(newRule);
            }
        }
        g.getRules().removeAll(unitRules);
        g.getRules().addAll(newRules);
    }

    private static Set<IProductionRule> getNonUnitRules(IGrammar g, IVariable v) {
        return Grammars.getNonUnitRules(g, v, new HashSet<IVariable>());
    }

    private static Set<IProductionRule> getNonUnitRules(IGrammar g, IVariable v, Set<IVariable> history) {
        if (history.contains(v)) {
            return new HashSet<IProductionRule>();
        }
        history.add(v);
        HashSet<IProductionRule> urules = new HashSet<IProductionRule>(g.getRules(v));
        HashSet<IProductionRule> nrules = new HashSet<IProductionRule>();
        Iterator i = urules.iterator();
        while (i.hasNext()) {
            IProductionRule rule = (IProductionRule)i.next();
            if (rule.getRight().size() == 1 && rule.getRight().get(0) instanceof IVariable) {
                i.remove();
                Set<IProductionRule> rs = Grammars.getNonUnitRules(g, (IVariable)rule.getRight().get(0), history);
                nrules.addAll(rs);
                continue;
            }
            if (rule.getRight().size() > 1) continue;
            nrules.add(rule);
        }
        urules.addAll(nrules);
        return urules;
    }

    public static void simplifyRules(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        HashSet<IProductionRule> longRules = new HashSet<IProductionRule>();
        if (varFactory == null) {
            varFactory = new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, cfg);
        }
        Iterator<IProductionRule> i = cfg.getRules().iterator();
        while (i.hasNext()) {
            IProductionRule rule = i.next();
            if (rule.getRight().size() <= 2) continue;
            i.remove();
            longRules.add(rule);
        }
        for (IProductionRule rule : longRules) {
            Set<IProductionRule> newRules = Grammars.simplifyRules(rule, (IVariableFactory<IVariable>)varFactory);
            cfg.addRules(newRules);
        }
    }

    private static Set<IProductionRule> simplifyRules(IProductionRule rule, IVariableFactory<IVariable> varFactory) {
        List<ISymbol> l = rule.getRight();
        if (l.size() <= 2) {
            HashSet<IProductionRule> s = new HashSet<IProductionRule>();
            s.add(rule);
            return s;
        }
        IVariable v = varFactory.createVariable("N");
        ArrayList<ISymbol> l1 = new ArrayList<ISymbol>();
        l1.add(l.get(0));
        l1.add(v);
        ProductionRule rule1 = new ProductionRule(rule.getLeft(), l1);
        ArrayList<ISymbol> l2 = new ArrayList<ISymbol>(l);
        l2.remove(0);
        ProductionRule rule2 = new ProductionRule(v, l2);
        Set<IProductionRule> s = Grammars.simplifyRules(rule2, varFactory);
        s.add(rule1);
        return s;
    }

    public static void moveTerminalsToUnitRules(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        HashMap<ISymbol, IVariable> m = new HashMap<ISymbol, IVariable>();
        if (varFactory == null) {
            varFactory = new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, cfg);
        }
        HashSet<IProductionRule> rmRules = new HashSet<IProductionRule>();
        HashSet<IProductionRule> addRules = new HashSet<IProductionRule>();
        for (IProductionRule rule : cfg.getRules()) {
            if (rule.getRight().size() < 2) continue;
            final ArrayList<ISymbol> right = new ArrayList<ISymbol>();
            for (ISymbol symbol : rule.getRight()) {
                if (!(symbol instanceof IVariable)) {
                    IVariable v = (IVariable)m.get(symbol);
                    if (v == null) {
                        v = varFactory.createVariable("N");
                        m.put(symbol, v);
                    }
                    right.add(v);
                    continue;
                }
                right.add(symbol);
            }
            rmRules.add(rule);
            addRules.add(rule.copy(new SimpleRuleCopier(){

                @Override
                public Collection<ISymbol> copyRight(Collection<? extends ISymbol> symbols, Collection<ISymbol> result) {
                    result.addAll(right);
                    return result;
                }
            }));
        }
        cfg.getRules().removeAll(rmRules);
        cfg.getRules().addAll(addRules);
        for (ISymbol s : m.keySet()) {
            IVariable v = (IVariable)m.get(s);
            cfg.addRule(new ProductionRule(v, new ISymbol[]{s}));
        }
    }

    public static String createUniqueVariableName(IGrammar grammar) {
        final HashSet<String> variables = new HashSet<String>();
        grammar.traverseRules(new IRuleVisitor(){

            @Override
            public void onVisit(IProductionRule rule) {
                IVariable v = rule.getLeft();
                variables.add(v.getName());
            }
        });
        return AUtil.createUniqueName("v", variables);
    }

    private static IVariableFactory<IVariable> createFreshVariableFactory(Collection<? extends IGrammar> gs) {
        HashSet<IVariable> vars = new HashSet<IVariable>();
        for (IGrammar iGrammar : gs) {
            vars.addAll(Grammars.collectVariables(iGrammar));
        }
        Collection<String> names = Grammars.collectVariableNames(vars);
        FreshVariableFactory freshVariableFactory = new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, names);
        return freshVariableFactory;
    }

    public static IContextFreeGrammar createAny(IVariable v) {
        return new ContextFreeGrammar(v, new IProductionRule[]{new ProductionRule(v, new RangeSymbol('\u0000', '\uffff'), v), new ProductionRule(v, new ISymbol[0])});
    }

    public static IContextFreeGrammar createAny(IVariableFactory<IVariable> vf) {
        return Grammars.createAny(vf.createVariable(variablePrefix));
    }

    public static IContextFreeGrammar createEmpty(IVariable v) {
        return new ContextFreeGrammar(v, new IProductionRule[]{new ProductionRule(v, new ISymbol[0])});
    }

    public static IContextFreeGrammar createEmpty(IVariableFactory<IVariable> vf) {
        return Grammars.createEmpty(vf.createVariable(variablePrefix));
    }

    public static IContextFreeGrammar createUnion(Collection<IContextFreeGrammar> cfgs, IVariableFactory<IVariable> varFactory) {
        if (cfgs.size() == 1) {
            return cfgs.iterator().next();
        }
        HashMap<IVariable, IVariable> m = new HashMap<IVariable, IVariable>();
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        IVariable startSymbol = varFactory.createVariable(variablePrefix);
        for (IContextFreeGrammar cfg : cfgs) {
            IContextFreeGrammar cfg2 = Grammars.useUniqueVariables(cfg, varFactory, m);
            rules.addAll(cfg2.getRules());
            ProductionRule r = new ProductionRule(startSymbol, new ISymbol[]{cfg2.getStartSymbol()});
            rules.add(r);
        }
        if (rules.isEmpty()) {
            rules.add(new ProductionRule(startSymbol, new ISymbol[0]));
        }
        ContextFreeGrammar cfg = new ContextFreeGrammar(startSymbol, (Collection<IProductionRule>)rules);
        return cfg;
    }

    public static IContextFreeGrammar createUnion(IContextFreeGrammar cfg1, IContextFreeGrammar cfg2, IVariableFactory<IVariable> varFactory) {
        return Grammars.createUnion(Arrays.asList(cfg1, cfg2), varFactory);
    }

    public static IContextFreeGrammar createUnion(Collection<IContextFreeGrammar> cfgs) {
        return Grammars.createUnion(cfgs, Grammars.createFreshVariableFactory(cfgs));
    }

    public static IContextFreeGrammar createUnion(IContextFreeGrammar cfg1, IContextFreeGrammar cfg2) {
        return Grammars.createUnion(Arrays.asList(cfg1, cfg2));
    }

    public static IContextFreeGrammar createConcatenation(List<IContextFreeGrammar> cfgs, IVariableFactory<IVariable> varFactory) {
        IContextFreeGrammar cfg2;
        if (cfgs.size() == 1) {
            return cfgs.iterator().next();
        }
        HashMap<IVariable, IVariable> m = new HashMap<IVariable, IVariable>();
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        IVariable startSymbol = varFactory.createVariable(variablePrefix);
        ArrayList<IVariable> l = new ArrayList<IVariable>();
        for (IContextFreeGrammar cfg2 : cfgs) {
            IContextFreeGrammar cfg22 = Grammars.useUniqueVariables(cfg2, varFactory, m);
            l.add(cfg22.getStartSymbol());
            rules.addAll(cfg22.getRules());
        }
        ProductionRule r = new ProductionRule(startSymbol, l);
        rules.add(r);
        cfg2 = new ContextFreeGrammar(startSymbol, (Collection<IProductionRule>)rules);
        return cfg2;
    }

    public static IContextFreeGrammar createConcatenation(IContextFreeGrammar cfg1, IContextFreeGrammar cfg2, IVariableFactory<IVariable> varFactory) {
        return Grammars.createConcatenation(Arrays.asList(cfg1, cfg2), varFactory);
    }

    public static IContextFreeGrammar createConcatenation(List<IContextFreeGrammar> cfgs) {
        return Grammars.createConcatenation(cfgs, Grammars.createFreshVariableFactory(cfgs));
    }

    public static IContextFreeGrammar createConcatenation(IContextFreeGrammar cfg1, IContextFreeGrammar cfg2) {
        return Grammars.createConcatenation(Arrays.asList(cfg1, cfg2));
    }

    public static IContextFreeGrammar createConcatenation(ISymbol sym1, IContextFreeGrammar cfg2, IVariableFactory<IVariable> varFactory) {
        Variable start = new Variable("N0");
        ProductionRule rule = new ProductionRule((IVariable)start, new ISymbol[]{sym1});
        ContextFreeGrammar cfg1 = new ContextFreeGrammar((IVariable)start, new IProductionRule[]{rule});
        return Grammars.createConcatenation(cfg1, cfg2, varFactory);
    }

    public static IContextFreeGrammar createConcatenation(ISymbol sym1, IContextFreeGrammar cfg2) {
        Variable start = new Variable("N0");
        ProductionRule rule = new ProductionRule((IVariable)start, new ISymbol[]{sym1});
        ContextFreeGrammar cfg1 = new ContextFreeGrammar((IVariable)start, new IProductionRule[]{rule});
        return Grammars.createConcatenation(cfg1, cfg2, (IVariableFactory<IVariable>)new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, cfg2));
    }

    public static IContextFreeGrammar createIntersection(IContextFreeGrammar cfg, IAutomaton fst, IVariableFactory<IVariable> varFactory, MonitorUtil.IProgressMonitor monitor) {
        fst = Automatons.determinize(fst, monitor);
        Collection<ISymbol> terminals = Grammars.collectTerminals(cfg);
        terminals.addAll(Automatons.collectTerminals(fst));
        terminals = RangeSymbol.splitSymbols(terminals);
        fst = Automatons.expand(fst, terminals);
        fst = (IAutomaton)fst.copy(new SimpleSTSCopier(){

            @Override
            public Collection<ITransition> copyTransitions(Collection<? extends ITransition> transitions, Collection<ITransition> result) {
                for (ITransition iTransition : transitions) {
                    result.add(iTransition.copy(this));
                }
                return result;
            }

            @Override
            public List<ISymbol> copyOutput(ITransition t, List<? extends ISymbol> l, List<ISymbol> result) {
                result.add(t.getInputSymbol());
                return result;
            }
        });
        cfg = CFLTranslator.translate(fst, cfg, varFactory, monitor);
        Grammars.eliminateUselessRules(cfg);
        return cfg;
    }

    public static IContextFreeGrammar createIntersection(IContextFreeGrammar cfg, IAutomaton fst, MonitorUtil.IProgressMonitor monitor) {
        return Grammars.createIntersection(cfg, fst, null, monitor);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends IGrammar> T reduceTerminals(T g) {
        HashMap m = new HashMap();
        IGrammar result = g.copy(new DeepGrammarCopier(new SimpleRuleCopier()));
        HashSet<IProductionRule> removed = new HashSet<IProductionRule>();
        for (IProductionRule iProductionRule : result.getRules()) {
            void var10_12;
            List<ISymbol> rhs = iProductionRule.getRight();
            if (rhs.size() <= 1 || rhs.get(0) instanceof IVariable) continue;
            ISymbol hd = rhs.get(0);
            List<ISymbol> rest = rhs.subList(1, rhs.size());
            Pair key = Pair.make((Object)iProductionRule.getLeft(), rest);
            Set set = (Set)m.get(key);
            if (set == null) {
                HashSet hashSet = new HashSet();
                m.put(key, hashSet);
            }
            var10_12.add(hd);
            removed.add(iProductionRule);
        }
        result.getRules().removeAll(removed);
        for (Map.Entry entry : m.entrySet()) {
            Pair key = (Pair)entry.getKey();
            Set cs = (Set)entry.getValue();
            Collection<ISymbol> syms = RangeSymbol.mergeSymbols(cs);
            for (ISymbol iSymbol : syms) {
                ArrayList<ISymbol> right = new ArrayList<ISymbol>();
                right.add(iSymbol);
                right.addAll((Collection)key.snd);
                result.getRules().add(new ProductionRule((IVariable)key.fst, right));
            }
        }
        return (T)result;
    }

    public static String toRuleChain(IGrammar g) {
        return Grammars.toRuleChain(g, g.getStartSymbol());
    }

    public static String toRuleChain(IGrammar g, IVariable v) {
        return Grammars.toRuleChain(g, v, "", new HashSet<IProductionRule>());
    }

    private static String toRuleChain(final IGrammar g, IProductionRule r, final String prefix, final Set<IProductionRule> h) {
        if (h.contains(r)) {
            return "";
        }
        h.add(r);
        final StringBuffer buff = new StringBuffer();
        buff.append(prefix + r.toString());
        buff.append(AUtil.lineSeparator);
        for (ISymbol s : r.getRight()) {
            s.traverse(new ISymbolVisitor(){

                @Override
                public void onVisit(ISymbol symbol) {
                    if (symbol instanceof IVariable) {
                        String s = Grammars.toRuleChain(g, (IVariable)symbol, prefix, (Set<IProductionRule>)h);
                        buff.append(s);
                    }
                }

                @Override
                public void onLeave(ISymbol symbol) {
                }
            });
        }
        return buff.toString();
    }

    private static String toRuleChain(IGrammar g, IVariable v, String prefix, Set<IProductionRule> h) {
        StringBuffer buff = new StringBuffer();
        for (IProductionRule nr : g.getRules(v)) {
            String s = Grammars.toRuleChain(g, nr, prefix + "  ", h);
            buff.append(s);
        }
        return buff.toString();
    }

    public static IContextFreeGrammar toCFG(IAutomaton automaton, Set<ISymbol> allSymbols, ITransitionSymbol transSym, IVariableFactory<IVariable> varFactory) {
        automaton = (IAutomaton)automaton.copy(new DeepSTSCopier(SimpleTransitionCopier.defaultCopier));
        return Grammars.toCFG(automaton, transSym, varFactory);
    }

    public static IContextFreeGrammar toCFG(IAutomaton automaton, ITransitionSymbol transSym, final IVariableFactory<IVariable> varFactory) {
        Automatons.eliminateUnreachableStates(automaton);
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        if (automaton.getTransitions().isEmpty()) {
            IVariable v = varFactory.createVariable(variablePrefix);
            rules.add(new ProductionRule(v, new ISymbol[0]));
            ContextFreeGrammar cfg = new ContextFreeGrammar(v, (Collection<IProductionRule>)rules);
            return cfg;
        }
        DMap<IState, IVariable> m = new DMap<IState, IVariable>(){

            @Override
            protected IVariable create(IState key) {
                return varFactory.createVariable(variablePrefix);
            }
        };
        for (ITransition t : automaton.getTransitions()) {
            IState preState = t.getPreState();
            IState postState = t.getPostState();
            List<ISymbol> rs = transSym.getSymbols(t);
            IVariable preVar = (IVariable)m.get(preState);
            IVariable postVar = (IVariable)m.get(postState);
            rs.add(postVar);
            ProductionRule rule = new ProductionRule(preVar, rs);
            rules.add(rule);
        }
        for (IState finState : automaton.getFinalStates()) {
            IVariable finVar = (IVariable)m.get(finState);
            ProductionRule rule = new ProductionRule(finVar, new ArrayList());
            rules.add(rule);
        }
        IVariable initVar = (IVariable)m.get(automaton.getInitialState());
        ContextFreeGrammar cfg = new ContextFreeGrammar(initVar, (Collection<IProductionRule>)rules);
        return cfg;
    }

    public static IContextFreeGrammar toCFG(IAutomaton automaton) {
        FreshVariableFactory varFactory = new FreshVariableFactory();
        return Grammars.toCFG(automaton, TransitionInput.defaultInstance, varFactory);
    }

    public static IContextFreeGrammar toCFG(IAutomaton automaton, IVariableFactory<IVariable> varFactory) {
        return Grammars.toCFG(automaton, TransitionInput.defaultInstance, varFactory);
    }

    public static Set<IProductionRule> collectLinearRules(IContextFreeGrammar cfg) {
        HashSet<IProductionRule> s = new HashSet<IProductionRule>();
        Grammars.collectLinearRules(cfg, s, s);
        return s;
    }

    public static Set<IProductionRule> collectLeftLinearRules(IContextFreeGrammar cfg) {
        HashSet<IProductionRule> l = new HashSet<IProductionRule>();
        HashSet<IProductionRule> r = new HashSet<IProductionRule>();
        Grammars.collectLinearRules(cfg, l, r);
        return l;
    }

    public static Set<IProductionRule> collectRightLinearRules(IContextFreeGrammar cfg) {
        HashSet<IProductionRule> l = new HashSet<IProductionRule>();
        HashSet<IProductionRule> r = new HashSet<IProductionRule>();
        Grammars.collectLinearRules(cfg, l, r);
        return r;
    }

    public static void collectLinearRules(IContextFreeGrammar cfg, Set<IProductionRule> lset, Set<IProductionRule> rset) {
        block0: for (IProductionRule rule : cfg.getRules()) {
            List<ISymbol> right = rule.getRight();
            if (right.size() <= 1) continue;
            Iterator<ISymbol> r = right.iterator();
            ISymbol s = r.next();
            if (s instanceof IVariable) {
                while (r.hasNext()) {
                    s = r.next();
                    if (!(s instanceof IVariable)) continue;
                    continue block0;
                }
                lset.add(rule);
                continue;
            }
            while (r.hasNext()) {
                s = r.next();
                if (!(s instanceof IVariable) || !r.hasNext()) continue;
                continue block0;
            }
            rset.add(rule);
        }
    }

    public static IGrammar reverse(IGrammar g) {
        return g.copy(new DeepGrammarCopier(new SimpleRuleCopier(){

            @Override
            public Collection<ISymbol> copyRight(Collection<? extends ISymbol> symbols, Collection<ISymbol> result) {
                ArrayList<? extends ISymbol> l = new ArrayList<ISymbol>(symbols);
                Collections.reverse(l);
                result.addAll(l);
                return result;
            }

            @Override
            public IVariable copyLeft(IVariable v) {
                return v;
            }
        }));
    }

    public static Set<IVariable> collectMutuallyRecursiveVariables(IGrammar g) {
        HashSet<IVariable> mvars = new HashSet<IVariable>();
        for (IVariable v : g.getNonterminals()) {
            boolean isRec = Grammars.isMutuallyRecursiveVariables(g, v, v, new HashSet<IVariable>());
            if (!isRec) continue;
            mvars.add(v);
        }
        return mvars;
    }

    private static boolean isMutuallyRecursiveVariables(final IGrammar g, final IVariable sv, IVariable cv, final Set<IVariable> history) {
        if (history.contains(cv)) {
            return false;
        }
        history.add(cv);
        final RuntimeException isMutualException = new RuntimeException();
        try {
            for (IProductionRule rule : g.getRules(cv)) {
                for (ISymbol s : rule.getRight()) {
                    s.traverse(new ISymbolVisitor(){

                        @Override
                        public void onVisit(ISymbol symbol) {
                            if (sv.equals(symbol)) {
                                throw isMutualException;
                            }
                            if (symbol instanceof IVariable && Grammars.isMutuallyRecursiveVariables(g, sv, (IVariable)symbol, history)) {
                                throw isMutualException;
                            }
                        }

                        @Override
                        public void onLeave(ISymbol symbol) {
                        }
                    });
                }
            }
            return false;
        }
        catch (RuntimeException e) {
            if (e == isMutualException) {
                return true;
            }
            throw e;
        }
    }

    public static List<List<ISymbol>> unfold(List<ISymbol> l, Collection<IVariable> mvars, IContextFreeGrammar cfg) {
        if (l.isEmpty()) {
            return Collections.singletonList(l);
        }
        ISymbol s = l.get(0);
        l.remove(0);
        List<List<ISymbol>> subResult = Grammars.unfold(l, mvars, cfg);
        ArrayList<List<ISymbol>> result = new ArrayList<List<ISymbol>>();
        if (s instanceof IVariable && !mvars.contains(s)) {
            Set<IProductionRule> rules = cfg.getRules((IVariable)s);
            for (List<ISymbol> t : subResult) {
                if (t.isEmpty()) {
                    LinkedList<ISymbol> tt = new LinkedList<ISymbol>();
                    tt.add(s);
                    result.add(tt);
                    continue;
                }
                for (IProductionRule r : rules) {
                    LinkedList<ISymbol> tt = new LinkedList<ISymbol>();
                    tt.addAll(r.getRight());
                    tt.addAll(t);
                    result.add(tt);
                }
            }
        } else {
            for (List<ISymbol> t : subResult) {
                LinkedList<ISymbol> tt = new LinkedList<ISymbol>();
                tt.add(s);
                tt.addAll(t);
                result.add(tt);
            }
        }
        return result;
    }

    public boolean isRegular(ContextFreeGrammar cfg) {
        for (IProductionRule rule : cfg.getRules()) {
            if (rule.getRight().size() <= 2) continue;
            return false;
        }
        for (IVariable v : Grammars.collectMutuallyRecursiveVariables(cfg)) {
            for (IProductionRule r : cfg.getRules(v)) {
                ISymbol lastSym;
                if (r.getRight().isEmpty() || (lastSym = r.getRight().get(r.getRight().size() - 1)) instanceof IVariable) continue;
                return false;
            }
        }
        return true;
    }

    public static IContextFreeGrammar toRegularGrammar(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory, MonitorUtil.IProgressMonitor monitor) {
        return RTNRegularApproximation.toRegularGrammar(cfg, varFactory, monitor);
    }

    public static IContextFreeGrammar toRegularGrammar(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        return Grammars.toRegularGrammar(cfg, varFactory, AUtil.nullProgressMonitor);
    }

    public static IAutomaton toAutomaton(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory, MonitorUtil.IProgressMonitor monitor) {
        return RTNRegularApproximation.toAutomaton(cfg, varFactory, monitor);
    }

    public static IAutomaton toAutomaton(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        return Grammars.toAutomaton(cfg, varFactory);
    }

    public static IAutomaton toAutomaton(IContextFreeGrammar cfg, MonitorUtil.IProgressMonitor monitor) {
        return RTNRegularApproximation.toAutomaton(cfg, monitor);
    }

    public static IAutomaton toAutomaton(IContextFreeGrammar cfg) {
        return Grammars.toAutomaton(cfg, AUtil.nullProgressMonitor);
    }

    public static Set<String> stringValues(IContextFreeGrammar cfg, int sizeLimit) {
        Set<LabeledString> strs = Grammars.labeledStringValues(cfg, sizeLimit);
        return LabeledString.strings(strs, new HashSet());
    }

    public static Set<String> stringValues(IContextFreeGrammar cfg, int sizeLimit, ILabeledStringDecorator decorator) {
        return LabeledString.strings(Grammars.labeledStringValues(cfg, sizeLimit, decorator), new HashSet());
    }

    public static Set<LabeledString> labeledStringValues(IContextFreeGrammar cfg, int sizeLimit) {
        return LabeledString.reduce(Grammars.labeledStringValues(cfg, cfg.getStartSymbol(), sizeLimit, new HashSet<IVariable>(), new SimpleLabeledStringDecorator()));
    }

    public static Set<LabeledString> labeledStringValues(IContextFreeGrammar cfg, int sizeLimit, ILabeledStringDecorator decorator) {
        return LabeledString.reduce(Grammars.labeledStringValues(cfg, cfg.getStartSymbol(), sizeLimit, new HashSet<IVariable>(), decorator));
    }

    private static Set<LabeledString> labeledStringValues(IContextFreeGrammar cfg, IVariable v, int sizeLimit, Set<IVariable> h, ILabeledStringDecorator decorator) {
        HashSet<LabeledString> vals = new HashSet<LabeledString>();
        if (h.contains(v)) {
            LabeledString lstr = decorator.cyclic(v, cfg);
            if (lstr == null) {
                return null;
            }
            vals.add(lstr);
            return vals;
        }
        h.add(v);
        Set<IProductionRule> rules = cfg.getRules(v);
        for (IProductionRule r : rules) {
            Set<LabeledString> vvals = new HashSet<LabeledString>();
            vvals.add(LabeledString.make("", ILabelSymbol.BOTTOM));
            for (ISymbol s : r.getRight()) {
                ILabelSymbol label = ILabelSymbol.BOTTOM;
                if (s instanceof LabeledSymbol) {
                    LabeledSymbol lsym = (LabeledSymbol)s;
                    label = lsym.getLabel();
                    s = lsym.getValueSymbol();
                }
                if (s instanceof CharSymbol) {
                    CharSymbol c = (CharSymbol)s;
                    String str = decorator.character(c.charValue());
                    vvals = Grammars.appendString(vvals, str, label);
                    continue;
                }
                if (s instanceof StringSymbol) {
                    StringSymbol strSym = (StringSymbol)s;
                    char[] c = strSym.getName().toCharArray();
                    StringBuffer buff = new StringBuffer();
                    for (int i = 0; i < c.length; ++i) {
                        buff.append(decorator.character(c[i]));
                    }
                    vvals = Grammars.appendString(vvals, buff.toString(), label);
                    continue;
                }
                if (s instanceof IVariable) {
                    Set<LabeledString> ss = Grammars.labeledStringValues(cfg, (IVariable)s, sizeLimit, new HashSet<IVariable>(h), decorator);
                    if (ss == null) {
                        return null;
                    }
                    vvals = Grammars.appendString(vvals, ss);
                    continue;
                }
                if (s instanceof RangeSymbol) {
                    LabeledString lstr = decorator.range((RangeSymbol)s);
                    if (lstr == null) {
                        return null;
                    }
                    vvals = Grammars.appendString(vvals, lstr.getString(), label.meet(lstr.getLabel()));
                    continue;
                }
                String str = decorator.unknown(s);
                if (str == null) {
                    return null;
                }
                vvals = Grammars.appendString(vvals, str, label);
            }
            vals.addAll(vvals);
        }
        if (vals.size() > sizeLimit) {
            return null;
        }
        return vals;
    }

    public static Set<NumberSymbol> numberValues(IGrammar g, IVariable v) throws IllegalGrammarException {
        return Grammars.constantValues(g, v, NumberSymbol.class);
    }

    public static Set<CharSymbol> charValues(IGrammar g, IVariable v) throws IllegalGrammarException {
        return Grammars.constantValues(g, v, CharSymbol.class);
    }

    public static Set<BooleanSymbol> booleanValues(IGrammar g, IVariable v) throws IllegalGrammarException {
        return Grammars.constantValues(g, v, BooleanSymbol.class);
    }

    public static <T extends ISymbol> Set<T> constantValues(IGrammar g, IVariable v, Class<T> klass) throws IllegalGrammarException {
        HashSet<IVariable> h = new HashSet<IVariable>();
        SimpleGrammar sg = new SimpleGrammar(v, g.getRules());
        Grammars.eliminateUselessRules(sg);
        Grammars.eliminateEpsilonRules(sg);
        return Grammars.constantValues(sg, sg.getStartSymbol(), klass, h);
    }

    private static <T extends ISymbol> Set<T> constantValues(IGrammar g, IVariable v, Class<T> klass, Set<IVariable> h) throws IllegalGrammarException {
        Set<IProductionRule> rules = g.getRules(v);
        HashSet<T> objs = new HashSet<T>();
        if (h.contains(v)) {
            return objs;
        }
        h.add(v);
        for (IProductionRule rule : rules) {
            List<ISymbol> syms = rule.getRight();
            if (syms.size() > 1) {
                throw new IllegalGrammarException("can't produce a constant symbol.", g);
            }
            if (syms.isEmpty()) continue;
            ISymbol sym = syms.get(0);
            if (sym instanceof IVariable) {
                objs.addAll(Grammars.constantValues(g, (IVariable)sym, klass, h));
                continue;
            }
            if (klass.isInstance(sym)) {
                objs.add(klass.cast(sym));
                continue;
            }
            throw new IllegalGrammarException("the grammar can't produce constants.", g);
        }
        return objs;
    }

    private static Set<LabeledString> appendString(Set<LabeledString> s1, Set<LabeledString> s2) {
        HashSet<LabeledString> s = new HashSet<LabeledString>();
        for (LabeledString str1 : s1) {
            for (LabeledString str2 : s2) {
                s.add(str1.concat(str2));
            }
        }
        return s;
    }

    private static Set<LabeledString> appendString(Set<LabeledString> s1, String str2, ILabelSymbol label) {
        return Grammars.appendString(s1, AUtil.set(LabeledString.make(str2, label)));
    }

    public static IGrammar expand(IGrammar g, Collection<ISymbol> allSymbols) {
        final HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        for (IProductionRule rule : g.getRules()) {
            Collection<IProductionRule> newRules = Grammars.expandRule(rule, allSymbols);
            rules.addAll(newRules);
        }
        g = g.copy(new SimpleGrammarCopier(){

            @Override
            public Collection<IProductionRule> copyRules(Collection<? extends IProductionRule> _rules, Collection<IProductionRule> result) {
                result.addAll(rules);
                return result;
            }
        });
        return g;
    }

    public static Collection<IProductionRule> expandRule(IProductionRule rule, Collection<ISymbol> terminals) {
        HashSet<IProductionRule> result = new HashSet<IProductionRule>();
        List<ISymbol> rights = rule.getRight();
        Collection<List<ISymbol>> newRights = Grammars.expandRangeSymbol(rights.iterator(), terminals);
        for (final List<ISymbol> l : newRights) {
            IProductionRule r = rule.copy(new SimpleRuleCopier(){

                @Override
                public Collection<ISymbol> copyRight(Collection<? extends ISymbol> symbols, Collection<ISymbol> result) {
                    result.addAll(l);
                    return result;
                }
            });
            result.add(r);
        }
        return result;
    }

    private static Collection<List<ISymbol>> expandRangeSymbol(Iterator<ISymbol> iter, Collection<ISymbol> terminals) {
        if (iter.hasNext()) {
            ISymbol s = iter.next();
            Collection<List<ISymbol>> expanded = Grammars.expandRangeSymbol(iter, terminals);
            if (s instanceof RangeSymbol) {
                HashSet<List<ISymbol>> result = new HashSet<List<ISymbol>>();
                Collection<ISymbol> ranges = RangeSymbol.unrange(RangeSymbol.splitRanges((RangeSymbol)s, terminals));
                for (List<ISymbol> l : expanded) {
                    for (ISymbol r : ranges) {
                        ArrayList<ISymbol> ll = new ArrayList<ISymbol>(l);
                        ll.add(0, r);
                        result.add(ll);
                    }
                }
                return result;
            }
            for (List<ISymbol> l : expanded) {
                l.add(0, s);
            }
            return expanded;
        }
        HashSet<List<ISymbol>> result = new HashSet<List<ISymbol>>();
        result.add(new ArrayList());
        return result;
    }

    public static IContextFreeGrammar createCFG(List<ISymbol> symbols) {
        Variable startVar = new Variable(variablePrefix + "1");
        ProductionRule rule = new ProductionRule((IVariable)startVar, symbols);
        ContextFreeGrammar cfg = new ContextFreeGrammar((IVariable)startVar, new IProductionRule[]{rule});
        return cfg;
    }

    public static IContextFreeGrammar createCFG(ISymbol[] symbols) {
        Variable startVar = new Variable(variablePrefix + "1");
        ProductionRule rule = new ProductionRule((IVariable)startVar, symbols);
        ContextFreeGrammar cfg = new ContextFreeGrammar((IVariable)startVar, new IProductionRule[]{rule});
        return cfg;
    }

    public static <T extends IGrammar> T minimize(T g) {
        boolean cont = true;
        while (cont) {
            cont = false;
            DMap<List<ISymbol>, Collection<IVariable>> m = new DMap<List<ISymbol>, Collection<IVariable>>(){

                @Override
                protected Collection<IVariable> create(List<ISymbol> key) {
                    return new HashSet<IVariable>();
                }
            };
            for (IProductionRule r : g.getRules()) {
                if (g.getRules(r.getLeft()).size() != 1) continue;
                ((Collection)m.get(r.getRight())).add(r.getLeft());
            }
            HashMap replace = new HashMap();
            for (Map.Entry e : m.entrySet()) {
                Collection l = (Collection)e.getValue();
                if (l.size() <= 1) continue;
                Iterator i = l.iterator();
                IVariable v = (IVariable)i.next();
                while (i.hasNext()) {
                    replace.put(i.next(), v);
                }
                cont = true;
            }
            g = g.copy(new DeepGrammarCopier(new DeepRuleCopier(new VariableReplacer(replace))));
        }
        return g;
    }

    public static class DotStarLabeledStringDecorator
    implements ILabeledStringDecorator {
        private static String STAR = "*";
        private static String DOT = ".";
        private static String ESCAPE = "\\";

        @Override
        public LabeledString cyclic(IVariable v, IContextFreeGrammar cfg) {
            return LabeledString.make(STAR, ILabelSymbol.BOTTOM);
        }

        @Override
        public String character(char c) {
            switch (c) {
                case '.': {
                    return ESCAPE + ".";
                }
                case '*': {
                    return ESCAPE + "*";
                }
                case '\\': {
                    return ESCAPE + ESCAPE;
                }
            }
            return Character.toString(c);
        }

        @Override
        public String unknown(ISymbol s) {
            return DOT;
        }

        @Override
        public LabeledString range(RangeSymbol r) {
            IEnumerableSymbol min = r.getMin();
            IEnumerableSymbol max = r.getMax();
            ILabelSymbol label = ILabelSymbol.BOTTOM;
            if (min instanceof LabeledSymbol) {
                label = label.meet(((LabeledSymbol)min).getLabel());
            }
            if (max instanceof LabeledSymbol) {
                label = label.meet(((LabeledSymbol)max).getLabel());
            }
            return LabeledString.make(DOT, label);
        }

        public static String toPlain(String dotStar) {
            StringBuffer buff = new StringBuffer();
            char[] c = dotStar.toCharArray();
            boolean escape = false;
            block5: for (int i = 0; i < c.length; ++i) {
                switch (c[i]) {
                    case '\\': {
                        if (escape) {
                            buff.append('\\');
                            escape = false;
                            continue block5;
                        }
                        escape = true;
                        continue block5;
                    }
                    case '.': {
                        if (escape) {
                            buff.append('.');
                            escape = false;
                            continue block5;
                        }
                        return null;
                    }
                    case '*': {
                        if (escape) {
                            buff.append('*');
                            escape = false;
                            continue block5;
                        }
                        return null;
                    }
                    default: {
                        buff.append(c[i]);
                    }
                }
            }
            String plain = buff.toString();
            return plain;
        }

        public static Set<Pair<StringKind, LabeledString>> categorize(Set<LabeledString> lstrs) {
            HashSet<Pair<StringKind, LabeledString>> result = new HashSet<Pair<StringKind, LabeledString>>();
            for (LabeledString lstr : lstrs) {
                if (lstr == null || lstr.getString().length() == 0) {
                    result.add((Pair<StringKind, LabeledString>)Pair.make((Object)((Object)StringKind.EMPTY), (Object)((Object)LabeledString.make("", ILabelSymbol.BOTTOM))));
                    continue;
                }
                String str = lstr.getString();
                String plain = DotStarLabeledStringDecorator.toPlain(str);
                if (plain == null) {
                    result.add((Pair<StringKind, LabeledString>)Pair.make((Object)((Object)StringKind.DOTSTAR), (Object)((Object)lstr)));
                    continue;
                }
                result.add((Pair<StringKind, LabeledString>)Pair.make((Object)((Object)StringKind.PLAIN), (Object)((Object)LabeledString.make(plain, lstr.getLabel()))));
            }
            return result;
        }

        public static enum StringKind {
            PLAIN,
            DOTSTAR,
            EMPTY;

        }
    }

    public static class SimpleLabeledStringDecorator
    implements ILabeledStringDecorator {
        @Override
        public String character(char c) {
            return Character.toString(c);
        }

        @Override
        public LabeledString cyclic(IVariable v, IContextFreeGrammar cfg) {
            return null;
        }

        @Override
        public LabeledString range(RangeSymbol r) {
            return null;
        }

        @Override
        public String unknown(ISymbol s) {
            return null;
        }
    }

    public static interface ILabeledStringDecorator {
        public LabeledString cyclic(IVariable var1, IContextFreeGrammar var2);

        public LabeledString range(RangeSymbol var1);

        public String character(char var1);

        public String unknown(ISymbol var1);
    }

    public static class TransitionOutput
    implements ITransitionSymbol {
        public static TransitionOutput defaultInstance = new TransitionOutput();

        @Override
        public List<ISymbol> getSymbols(ITransition transition) {
            ArrayList<ISymbol> l = new ArrayList<ISymbol>();
            for (ISymbol s : transition.getOutputSymbols()) {
                l.add(s);
            }
            return l;
        }
    }

    public static class TransitionInput
    implements ITransitionSymbol {
        public static TransitionInput defaultInstance = new TransitionInput();

        @Override
        public List<ISymbol> getSymbols(ITransition transition) {
            ArrayList<ISymbol> l = new ArrayList<ISymbol>();
            ISymbol is = transition.getInputSymbol();
            if (is != null) {
                l.add(is);
            }
            return l;
        }
    }

    public static interface ITransitionSymbol {
        public List<ISymbol> getSymbols(ITransition var1);
    }
}

