/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.regex.string;

import com.ibm.wala.automaton.regex.string.AbstractPattern;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.IPatternCopier;
import com.ibm.wala.automaton.regex.string.IPatternVisitor;
import java.util.ArrayList;

public class IterationPattern
extends AbstractPattern
implements IPattern {
    private IPattern pattern;
    private int lower;
    private int upper;

    public static IPattern make(IPattern p) {
        return new IterationPattern(p);
    }

    public IterationPattern(IPattern pattern, int lower, int upper) {
        this.pattern = pattern;
        this.lower = lower;
        this.upper = upper;
    }

    public IterationPattern(IPattern pattern) {
        this(pattern, 0, -1);
    }

    @Override
    public void traverse(IPatternVisitor visitor) {
        visitor.onVisit(this);
        this.pattern.traverse(visitor);
        visitor.onLeave(this);
    }

    @Override
    public IPattern copy(IPatternCopier copier) {
        ArrayList<IPattern> l = new ArrayList<IPattern>();
        l.add(this.pattern.copy(copier));
        return copier.copy(this, l);
    }

    public IPattern getPattern() {
        return this.pattern;
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        IterationPattern p = (IterationPattern)obj;
        return this.pattern.equals(p.getPattern()) && this.lower == p.lower && this.upper == p.upper;
    }

    public String toString() {
        String suffix = this.upper == -1 ? (this.lower == 0 ? "*" : (this.lower == 1 ? "?" : "{" + this.lower + "," + this.upper + "}")) : "{" + this.lower + "," + this.upper + "}";
        return "(" + this.pattern.toString() + ")" + suffix;
    }
}

