/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.grammar.string.DeepGrammarCopier;
import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarSymbol;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.ILabelSymbol;
import com.ibm.wala.automaton.string.ILabeledValueSymbol;
import com.ibm.wala.automaton.string.ISubstitution;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.LabeledSymbol;
import com.ibm.wala.automaton.string.Labeling;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.Substitution;
import java.util.Stack;

public class LabelSubstitution
extends Substitution
implements ISubstitution {
    private Stack<ILabelSymbol> labels = new Stack();

    private ILabelSymbol getCurrentLabel() {
        ILabelSymbol l = ILabelSymbol.BOTTOM;
        for (ILabelSymbol s : this.labels) {
            l = l.meet(s);
        }
        return l;
    }

    @Override
    public ISymbol copy(ISymbol s) {
        if (s instanceof CharSymbol) {
            ILabelSymbol l = this.getCurrentLabel();
            if (l.isBottom()) {
                return s;
            }
            return new LabeledSymbol((CharSymbol)s, l);
        }
        if (s instanceof NumberSymbol) {
            return s;
        }
        if (s instanceof ILabeledValueSymbol) {
            ILabeledValueSymbol ls = (ILabeledValueSymbol)s;
            ILabelSymbol l = ls.getLabel();
            IValueSymbol base = ls.getValueSymbol();
            this.labels.push(l);
            ISymbol result = base.copy(this);
            this.labels.pop();
            return result;
        }
        if (s instanceof IGrammarSymbol) {
            IGrammarSymbol gsym = (IGrammarSymbol)s;
            SimpleGrammar sg = (SimpleGrammar)gsym.getGrammar();
            ILabelSymbol l = this.getCurrentLabel();
            if (!l.isBottom()) {
                sg = (SimpleGrammar)sg.copy(new DeepGrammarCopier(new DeepRuleCopier(new Labeling(l))));
            }
            this.rules.addAll(sg.getRules());
            return sg.getStartSymbol();
        }
        return super.copy(s);
    }

    @Override
    public ISymbol copySymbolReference(ISymbol parent, ISymbol sym) {
        return sym;
    }

    public <T extends IGrammar> T substitute(T g, ILabelSymbol label) {
        if (label == null) {
            label = ILabelSymbol.BOTTOM;
        }
        this.labels.push(label);
        IGrammar g2 = g.copy(new DeepGrammarCopier(new DeepRuleCopier(this)));
        g2.getRules().addAll(this.getRules());
        this.labels.pop();
        return (T)g2;
    }
}

